/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.jungle;

import java.awt.geom.Dimension2D;
import java.util.Arrays;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.graphic.AbstractTextBlock;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.jungle.GTile;
import net.sourceforge.plantuml.jungle.GTileGeometry;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UPath;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class GTileLeftRight
extends AbstractTextBlock
implements GTile {
    private final GTile left;
    private final GTile right;
    private final double space;
    private final double step = 5.0;

    public GTileLeftRight(GTile left, GTile right, double space) {
        this.left = left;
        this.right = right;
        this.space = space;
    }

    @Override
    public void drawU(UGraphic ug) {
        StringBounder stringBounder = ug.getStringBounder();
        GTileGeometry dimLeft = this.left.calculateDimension(stringBounder);
        GTileGeometry dimRight = this.right.calculateDimension(stringBounder);
        GTileGeometry dimTotal = this.calculateDimension(stringBounder);
        double deltaH1 = ((Dimension2D)dimTotal).getHeight() - dimLeft.getHeight();
        double deltaH2 = ((Dimension2D)dimTotal).getHeight() - dimRight.getHeight();
        this.left.drawU(ug.apply(new UTranslate(0.0, deltaH1 / 2.0)));
        double dx2 = dimLeft.getWidth() + this.space;
        this.right.drawU(ug.apply(new UTranslate(dx2, deltaH2 / 2.0)));
        ug = ug.apply(new UChangeColor(HtmlColorUtils.BLACK));
        double step = dimLeft.getHeight() / (double)(dimRight.getWestPositions().size() + 1);
        double ystart = step + deltaH1 / 2.0;
        for (Double w2 : dimRight.getWestPositions()) {
            this.line(ug, dimLeft.getWidth(), ystart, dx2, w2 + deltaH2 / 2.0);
            ystart += step;
        }
    }

    private void line(UGraphic ug, double x1, double y1, double x2, double y2) {
        UPath path2 = new UPath();
        path2.moveTo(x1, y1);
        path2.lineTo(x1 + 5.0, y1);
        path2.lineTo(x2 - 5.0, y2);
        path2.lineTo(x2, y2);
        ug.apply(new UTranslate(0.0, 0.0)).draw(path2);
    }

    @Override
    public GTileGeometry calculateDimension(StringBounder stringBounder) {
        GTileGeometry dimLeft = this.left.calculateDimension(stringBounder);
        GTileGeometry dimRight = this.right.calculateDimension(stringBounder);
        Dimension2DDouble dimTotal = new Dimension2DDouble(dimLeft.getWidth() + this.space + ((Dimension2D)dimRight).getHeight(), Math.max(dimLeft.getHeight(), ((Dimension2D)dimRight).getHeight()));
        double deltaH1 = ((Dimension2D)dimTotal).getHeight() - dimLeft.getHeight();
        double west = dimLeft.getWestPositions().get(0) + deltaH1 / 2.0;
        return new GTileGeometry(dimTotal, Arrays.asList(west));
    }
}

