/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.preproc;

import java.io.IOException;
import net.sourceforge.plantuml.CharSequence2;
import net.sourceforge.plantuml.CharSequence2Impl;
import net.sourceforge.plantuml.command.regex.Matcher2;
import net.sourceforge.plantuml.command.regex.MyPattern;
import net.sourceforge.plantuml.command.regex.Pattern2;
import net.sourceforge.plantuml.preproc.ReadLine;
import net.sourceforge.plantuml.utils.StartUtils;

public class UncommentReadLine
implements ReadLine {
    private final ReadLine raw;
    private final Pattern2 start;
    private final Pattern2 unpause;
    private String headerToRemove;
    private boolean paused;

    public UncommentReadLine(ReadLine source) {
        this.raw = source;
        this.start = MyPattern.cmpile("(?i)((?:[^\\w~]|\\<[^<>]*\\>)*)[@\\\\]start");
        this.unpause = MyPattern.cmpile("(?i)((?:\\W|\\<[^<>]*\\>)*)[@\\\\]unpause");
    }

    @Override
    public CharSequence2 readLine() throws IOException {
        Matcher2 m2;
        CharSequence2 result = this.raw.readLine();
        if (result == null) {
            return null;
        }
        String tmp = StartUtils.beforeStartUml(result);
        if (tmp != null) {
            this.headerToRemove = tmp;
        }
        if (this.paused && (m2 = this.unpause.matcher(result)).find()) {
            this.headerToRemove = m2.group(1);
        }
        if (this.headerToRemove != null && this.headerToRemove.startsWith(result.toString2())) {
            return new CharSequence2Impl("", result.getLocation());
        }
        if (this.headerToRemove != null && result.toString2().startsWith(this.headerToRemove)) {
            return result.subSequence(this.headerToRemove.length(), result.length());
        }
        return result;
    }

    @Override
    public void close() throws IOException {
        this.raw.close();
    }

    public void setPaused(boolean paused) {
        this.paused = paused;
    }
}

