/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project3;

import net.sourceforge.plantuml.command.regex.IRegex;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.project3.Complement;
import net.sourceforge.plantuml.project3.ComplementPattern;
import net.sourceforge.plantuml.project3.Failable;
import net.sourceforge.plantuml.project3.GanttDiagram;
import net.sourceforge.plantuml.project3.Task;
import net.sourceforge.plantuml.project3.TaskAttribute;
import net.sourceforge.plantuml.project3.TaskInstant;

public class ComplementBeforeOrAfterOrAtTaskStartOrEnd
implements ComplementPattern {
    @Override
    public IRegex toRegex(String suffix) {
        return new RegexLeaf("COMPLEMENT" + suffix, "(?:at|(\\d+)[%s]+days?[%s]+(before|after))[%s]+\\[([^\\[\\]]+?)\\].?s[%s]+(start|end)");
    }

    @Override
    public Failable<Complement> getComplement(GanttDiagram system, RegexResult arg, String suffix) {
        String code = arg.get("COMPLEMENT" + suffix, 2);
        String position = arg.get("COMPLEMENT" + suffix, 3);
        Task task = system.getExistingTask(code);
        if (task == null) {
            return Failable.error("No such task " + code);
        }
        String days = arg.get("COMPLEMENT" + suffix, 0);
        TaskInstant result = new TaskInstant(task, TaskAttribute.fromString(position));
        if (days != null) {
            int delta = Integer.parseInt(days);
            if ("before".equalsIgnoreCase(arg.get("COMPLEMENT" + suffix, 1))) {
                delta = -delta;
            }
            result = result.withDelta(delta);
        }
        return Failable.ok(result);
    }
}

