/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project3;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import net.sourceforge.plantuml.project3.Duration;
import net.sourceforge.plantuml.project3.Instant;
import net.sourceforge.plantuml.project3.TaskAttribute;
import net.sourceforge.plantuml.project3.Value;

public class Solver {
    private final Map<TaskAttribute, Value> values = new LinkedHashMap<TaskAttribute, Value>();

    public void setData(TaskAttribute attribute, Value value) {
        this.values.remove((Object)attribute);
        this.values.put(attribute, value);
        if (this.values.size() > 2) {
            this.removeFirstElement();
        }
        assert (this.values.size() <= 2);
    }

    private void removeFirstElement() {
        Iterator<Map.Entry<TaskAttribute, Value>> it = this.values.entrySet().iterator();
        it.next();
        it.remove();
    }

    public Value getData(TaskAttribute attribute) {
        Value result = this.values.get((Object)attribute);
        if (result == null) {
            if (attribute == TaskAttribute.END) {
                return this.computeEnd();
            }
            if (attribute == TaskAttribute.START) {
                return this.computeStart();
            }
            throw new UnsupportedOperationException(attribute.toString());
        }
        return result;
    }

    private Instant computeStart() {
        Instant end = (Instant)this.values.get((Object)TaskAttribute.END);
        Duration duration = (Duration)this.values.get((Object)TaskAttribute.DURATION);
        assert (end != null && duration != null);
        return end.sub(duration).increment();
    }

    private Instant computeEnd() {
        Instant start = (Instant)this.values.get((Object)TaskAttribute.START);
        Duration duration = (Duration)this.values.get((Object)TaskAttribute.DURATION);
        assert (start != null && duration != null);
        return start.add(duration).decrement();
    }
}

