/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.teoz;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.graphic.AbstractTextBlock;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.VerticalAlignment;
import net.sourceforge.plantuml.real.Real;
import net.sourceforge.plantuml.sequencediagram.teoz.LivingSpaces;
import net.sourceforge.plantuml.sequencediagram.teoz.MainTile;
import net.sourceforge.plantuml.skin.SimpleContext2D;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class MainTileAdapter
extends AbstractTextBlock
implements TextBlock {
    private final MainTile mainTile;
    private Dimension2D cacheDimension;

    public MainTileAdapter(MainTile mainTile) {
        if (mainTile == null) {
            throw new IllegalArgumentException();
        }
        this.mainTile = mainTile;
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        if (this.cacheDimension == null) {
            double width = this.mainTile.getMaxX(stringBounder).getCurrentValue() - this.mainTile.getMinX(stringBounder).getCurrentValue();
            int factor = this.mainTile.isShowFootbox() ? 2 : 1;
            double height = this.mainTile.getPreferredHeight(stringBounder) + (double)factor * this.mainTile.getLivingSpaces().getHeadHeight(stringBounder);
            this.cacheDimension = new Dimension2DDouble(width, height);
        }
        return this.cacheDimension;
    }

    @Override
    public void drawU(UGraphic ug) {
        StringBounder stringBounder = ug.getStringBounder();
        SimpleContext2D context = new SimpleContext2D(false);
        double height = this.mainTile.getPreferredHeight(stringBounder);
        LivingSpaces livingSpaces = this.mainTile.getLivingSpaces();
        double headHeight = livingSpaces.getHeadHeight(stringBounder);
        this.mainTile.drawU(ug.apply(new UTranslate(0.0, headHeight)));
        livingSpaces.drawLifeLines(ug.apply(new UTranslate(0.0, headHeight)), height, context);
        livingSpaces.drawHeads(ug, context, VerticalAlignment.BOTTOM);
        if (this.mainTile.isShowFootbox()) {
            livingSpaces.drawHeads(ug.apply(new UTranslate(0.0, height + headHeight)), context, VerticalAlignment.TOP);
        }
        this.mainTile.drawForeground(ug.apply(new UTranslate(0.0, headHeight)));
    }

    public Real getMinX(StringBounder stringBounder) {
        return this.mainTile.getMinX(stringBounder);
    }
}

