/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.timingdiagram;

import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.timingdiagram.TimingDiagram;
import net.sourceforge.plantuml.timingdiagram.TimingStyle;

public class CommandLifeLine
extends SingleLineCommand2<TimingDiagram> {
    public CommandLifeLine() {
        super(CommandLifeLine.getRegexConcat());
    }

    private static RegexConcat getRegexConcat() {
        return new RegexConcat(new RegexLeaf("^"), new RegexLeaf("TYPE", "(robust|concise)[%s]+"), new RegexLeaf("FULL", "[%g]([^%g]+)[%g]"), new RegexLeaf("[%s]+as[%s]+"), new RegexLeaf("CODE", "([\\p{L}0-9_.@]+)"), new RegexLeaf("$"));
    }

    @Override
    protected final CommandExecutionResult executeArg(TimingDiagram diagram, RegexResult arg) {
        String code = arg.get("CODE", 0);
        String full = arg.get("FULL", 0);
        TimingStyle type = TimingStyle.valueOf(arg.get("TYPE", 0).toUpperCase());
        diagram.createLifeLine(code, full, type);
        return CommandExecutionResult.ok();
    }
}

