/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.webp;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.version.PSystemVersion;
import net.sourceforge.plantuml.webp.Portrait;

public class Portraits {
    private static final List<Portrait> all = new ArrayList<Portrait>();
    private static final AtomicInteger current = new AtomicInteger();

    private static InputStream getInputStream() {
        return PSystemVersion.class.getResourceAsStream("out.png");
    }

    private static void read(InputStream is) throws IOException {
        int i;
        DataInputStream dis = new DataInputStream(is);
        int nb = dis.readShort();
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<Integer> ages = new ArrayList<Integer>();
        ArrayList<String> quotes = new ArrayList<String>();
        for (i = 0; i < nb; ++i) {
            names.add(dis.readUTF());
            ages.add(Integer.valueOf(dis.readByte()));
            quotes.add(dis.readUTF());
        }
        for (i = 0; i < nb; ++i) {
            short len = dis.readShort();
            byte[] data = new byte[len];
            dis.readFully(data);
            all.add(new Portrait((String)names.get(i), (Integer)ages.get(i), (String)quotes.get(i), data));
        }
        Collections.shuffle(all);
    }

    public static Portrait getOne() {
        if (all.size() == 0) {
            return null;
        }
        int nb = current.get() % all.size();
        return all.get(nb);
    }

    public static void nextOne() {
        current.getAndIncrement();
    }

    public static Portrait getOne(String line) {
        Portrait candidat = null;
        for (Portrait p : all) {
            int dist = Portraits.similar(p.getName(), line);
            if (dist > 3 || candidat != null && dist < Portraits.similar(candidat.getName(), line)) continue;
            candidat = p;
        }
        return candidat;
    }

    public static int similar(String s1, String s2) {
        int[] tab1 = Portraits.countLetter(s1);
        int[] tab2 = Portraits.countLetter(s2);
        int result = 0;
        for (int i = 0; i < tab1.length; ++i) {
            result += Math.abs(tab1[i] - tab2[i]);
        }
        return result;
    }

    private static String noAccent(String str) {
        String nfdNormalizedString = Normalizer.normalize(str, Normalizer.Form.NFD);
        Pattern pattern = Pattern.compile("\\p{InCombiningDiacriticalMarks}+");
        return pattern.matcher(nfdNormalizedString).replaceAll("");
    }

    private static int[] countLetter(String s) {
        s = Portraits.noAccent(s).toLowerCase(Locale.US);
        int[] result = new int[26];
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c < 'a' || c > 'z') continue;
            int n = c - 97;
            result[n] = result[n] + 1;
        }
        return result;
    }

    static final List<Portrait> getAll() {
        return all;
    }

    static {
        InputStream is = Portraits.getInputStream();
        if (is != null) {
            try {
                Portraits.read(is);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

