/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.history;

import com.intellij.openapi.util.Pair;
import com.intellij.util.Consumer;
import com.intellij.util.ThrowableConsumer;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.history.LogEntry;
import org.jetbrains.idea.svn.history.LogHierarchyNode;

public class MergeSourceHierarchyBuilder
implements ThrowableConsumer<Pair<LogEntry, Integer>, SvnBindException> {
    private LogHierarchyNode myCurrentHierarchy;
    @NotNull
    private final Consumer<LogHierarchyNode> myConsumer;

    public MergeSourceHierarchyBuilder(@NotNull Consumer<LogHierarchyNode> consumer) {
        if (consumer == null) {
            MergeSourceHierarchyBuilder.$$$reportNull$$$0(0);
        }
        this.myConsumer = consumer;
    }

    public void consume(Pair<LogEntry, Integer> svnLogEntryIntegerPair) {
        LogEntry logEntry = (LogEntry)svnLogEntryIntegerPair.getFirst();
        Integer mergeLevel = (Integer)svnLogEntryIntegerPair.getSecond();
        if (mergeLevel < 0) {
            if (this.myCurrentHierarchy != null) {
                this.myConsumer.consume((Object)this.myCurrentHierarchy);
            }
            if (logEntry.hasChildren()) {
                this.myCurrentHierarchy = new LogHierarchyNode(logEntry);
            } else {
                this.myCurrentHierarchy = null;
                this.myConsumer.consume((Object)new LogHierarchyNode(logEntry));
            }
        } else {
            MergeSourceHierarchyBuilder.addToLevel(this.myCurrentHierarchy, logEntry, mergeLevel);
        }
    }

    public void finish() {
        if (this.myCurrentHierarchy != null) {
            this.myConsumer.consume((Object)this.myCurrentHierarchy);
        }
    }

    private static void addToLevel(LogHierarchyNode tree, LogEntry entry, int left) {
        assert (tree != null);
        if (left == 0) {
            tree.add(entry);
        } else {
            List<LogHierarchyNode> children = tree.getChildren();
            assert (!children.isEmpty());
            MergeSourceHierarchyBuilder.addToLevel(children.get(children.size() - 1), entry, left - 1);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "org/jetbrains/idea/svn/history/MergeSourceHierarchyBuilder", "<init>"));
    }
}

