/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.integrate;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.api.Url;
import org.jetbrains.idea.svn.branchConfig.SelectBranchPopup;
import org.jetbrains.idea.svn.branchConfig.SvnBranchConfigurationNew;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.integrate.IntegratedSelectedOptionsDialog;
import org.jetbrains.idea.svn.integrate.MergerFactory;
import org.jetbrains.idea.svn.integrate.SvnIntegrateChangesTask;
import org.jetbrains.idea.svn.integrate.WorkingCopyInfo;

public class SvnIntegrateChangesActionPerformer
implements SelectBranchPopup.BranchSelectedCallback {
    private final SvnVcs myVcs;
    @NotNull
    private final MergerFactory myMergerFactory;
    private final Url myCurrentBranch;

    public SvnIntegrateChangesActionPerformer(Project project, Url currentBranchUrl, @NotNull MergerFactory mergerFactory) {
        if (mergerFactory == null) {
            SvnIntegrateChangesActionPerformer.$$$reportNull$$$0(0);
        }
        this.myVcs = SvnVcs.getInstance(project);
        this.myCurrentBranch = currentBranchUrl;
        this.myMergerFactory = mergerFactory;
    }

    @Override
    public void branchSelected(Project project, SvnBranchConfigurationNew configuration, @NotNull Url url, long revision) {
        if (url == null) {
            SvnIntegrateChangesActionPerformer.$$$reportNull$$$0(1);
        }
        this.onBranchSelected(url, null, null);
    }

    public void onBranchSelected(@NotNull Url url, @Nullable String selectedLocalBranchPath, @Nullable String dialogTitle) {
        if (url == null) {
            SvnIntegrateChangesActionPerformer.$$$reportNull$$$0(2);
        }
        if (this.myCurrentBranch.equals(url)) {
            SvnIntegrateChangesActionPerformer.showSameSourceAndTargetMessage();
        } else {
            Pair<WorkingCopyInfo, Url> pair = this.selectWorkingCopy(url, selectedLocalBranchPath, dialogTitle);
            if (pair != null) {
                this.runIntegrate(url, (WorkingCopyInfo)pair.first, (Url)pair.second);
            }
        }
    }

    @Nullable
    private Pair<WorkingCopyInfo, Url> selectWorkingCopy(@NotNull Url url, @Nullable String selectedLocalBranchPath, @Nullable String dialogTitle) {
        if (url == null) {
            SvnIntegrateChangesActionPerformer.$$$reportNull$$$0(3);
        }
        return IntegratedSelectedOptionsDialog.selectWorkingCopy(this.myVcs.getProject(), this.myCurrentBranch, url, true, selectedLocalBranchPath, dialogTitle);
    }

    private void runIntegrate(@NotNull Url url, @NotNull WorkingCopyInfo workingCopy, @NotNull Url workingCopyUrl) {
        Url sourceUrl;
        if (url == null) {
            SvnIntegrateChangesActionPerformer.$$$reportNull$$$0(4);
        }
        if (workingCopy == null) {
            SvnIntegrateChangesActionPerformer.$$$reportNull$$$0(5);
        }
        if (workingCopyUrl == null) {
            SvnIntegrateChangesActionPerformer.$$$reportNull$$$0(6);
        }
        if ((sourceUrl = this.correctSourceUrl(url, workingCopyUrl)) != null) {
            SvnIntegrateChangesTask integrateTask = new SvnIntegrateChangesTask(this.myVcs, workingCopy, this.myMergerFactory, sourceUrl, SvnBundle.message("action.Subversion.integrate.changes.messages.title", new Object[0]), this.myVcs.getSvnConfiguration().isMergeDryRun(), this.myCurrentBranch.getTail());
            integrateTask.queue();
        }
    }

    @Nullable
    private Url correctSourceUrl(@NotNull Url targetUrl, @NotNull Url realTargetUrl) {
        if (targetUrl == null) {
            SvnIntegrateChangesActionPerformer.$$$reportNull$$$0(7);
        }
        if (realTargetUrl == null) {
            SvnIntegrateChangesActionPerformer.$$$reportNull$$$0(8);
        }
        if (SvnUtil.isAncestor(targetUrl, realTargetUrl)) {
            try {
                return this.myCurrentBranch.appendPath(SvnUtil.getRelativeUrl(targetUrl, realTargetUrl), false);
            }
            catch (SvnBindException svnBindException) {
                // empty catch block
            }
        }
        return null;
    }

    private static void showSameSourceAndTargetMessage() {
        Messages.showErrorDialog((String)SvnBundle.message("action.Subversion.integrate.changes.error.source.and.target.same.text", new Object[0]), (String)SvnBundle.message("action.Subversion.integrate.changes.messages.title", new Object[0]));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mergerFactory";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workingCopy";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workingCopyUrl";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetUrl";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "realTargetUrl";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/svn/integrate/SvnIntegrateChangesActionPerformer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "branchSelected";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "onBranchSelected";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "selectWorkingCopy";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "runIntegrate";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "correctSourceUrl";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

