/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xmlb;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.xmlb.MultiNodeBinding;
import com.intellij.util.xmlb.MutableAccessor;
import com.intellij.util.xmlb.NotNullDeserializeBinding;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.XmlSerializationException;
import com.intellij.util.xmlb.annotations.Tag;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class JDOMElementBinding
extends NotNullDeserializeBinding
implements MultiNodeBinding {
    private final String myTagName;

    public JDOMElementBinding(@NotNull MutableAccessor accessor) {
        if (accessor == null) {
            JDOMElementBinding.$$$reportNull$$$0(0);
        }
        super(accessor);
        Tag tag = this.myAccessor.getAnnotation(Tag.class);
        assert (tag != null) : "jdom.Element property without @Tag annotation: " + accessor;
        String tagName = tag.value();
        if (StringUtil.isEmpty(tagName)) {
            tagName = this.myAccessor.getName();
        }
        this.myTagName = tagName;
    }

    @Override
    public Object serialize(@NotNull Object o, @Nullable Object context, @Nullable SerializationFilter filter) {
        Object value;
        if (o == null) {
            JDOMElementBinding.$$$reportNull$$$0(1);
        }
        if ((value = this.myAccessor.read(o)) == null) {
            return null;
        }
        if (value instanceof Element) {
            Element targetElement = ((Element)value).clone();
            assert (targetElement != null);
            targetElement.setName(this.myTagName);
            return targetElement;
        }
        if (value instanceof Element[]) {
            ArrayList<Element> result = new ArrayList<Element>();
            for (Element element : (Element[])value) {
                result.add(element.clone().setName(this.myTagName));
            }
            return result;
        }
        throw new XmlSerializationException("org.jdom.Element expected but " + value + " found");
    }

    @Override
    @Nullable
    public Object deserializeList(@NotNull Object context, @NotNull List<Element> elements) {
        if (context == null) {
            JDOMElementBinding.$$$reportNull$$$0(2);
        }
        if (elements == null) {
            JDOMElementBinding.$$$reportNull$$$0(3);
        }
        if (this.myAccessor.getValueClass().isArray()) {
            this.myAccessor.set(context, elements.toArray(new Element[0]));
        } else {
            this.myAccessor.set(context, elements.get(0));
        }
        return context;
    }

    @Override
    public boolean isMulti() {
        return true;
    }

    @Override
    @NotNull
    public Object deserialize(@NotNull Object context, @NotNull Element element) {
        if (context == null) {
            JDOMElementBinding.$$$reportNull$$$0(4);
        }
        if (element == null) {
            JDOMElementBinding.$$$reportNull$$$0(5);
        }
        this.myAccessor.set(context, element);
        Object object = context;
        if (object == null) {
            JDOMElementBinding.$$$reportNull$$$0(6);
        }
        return object;
    }

    @Override
    public boolean isBoundTo(@NotNull Element element) {
        if (element == null) {
            JDOMElementBinding.$$$reportNull$$$0(7);
        }
        return element.getName().equals(this.myTagName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/xmlb/JDOMElementBinding";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/xmlb/JDOMElementBinding";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "deserialize";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "deserializeList";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "deserialize";
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isBoundTo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

