/*
 * Decompiled with CFR 0.152.
 */
package javolution.context;

import javax.realtime.MemoryArea;
import javolution.JavolutionError;
import javolution.context.Context;
import javolution.context.HeapContext;
import javolution.context.ObjectFactory;
import javolution.context.ObjectPool;
import javolution.context.RealtimeObject;
import javolution.text.Text;
import javolution.util.FastTable;
import javolution.xml.XMLFormat;
import javolution.xml.stream.XMLStreamException;

public class PoolContext
extends Context {
    private static final Class CLASS = new PoolContext().getClass();
    protected static final XMLFormat<PoolContext> XML = new XMLFormat(CLASS){

        public void read(XMLFormat.InputElement inputElement, Object object) throws XMLStreamException {
            PoolContext poolContext = (PoolContext)object;
            FastTable fastTable = (FastTable)inputElement.get("pools");
            poolContext.setPools(fastTable);
        }

        public void write(Object object, XMLFormat.OutputElement outputElement) throws XMLStreamException {
            PoolContext poolContext = (PoolContext)object;
            outputElement.add(poolContext._pools, "pools");
        }
    };
    final ObjectPool[] _pools = new ObjectPool[ObjectFactory._Instances.length];
    private final ObjectPool[] _inUsePools = new ObjectPool[ObjectFactory._Instances.length];
    private int _inUsePoolsLength;
    private int _tmpIndex;
    private Runnable NEW_POOL = new Runnable(){

        public void run() {
            PoolContext.this._pools[((PoolContext)PoolContext.this)._tmpIndex] = ObjectFactory._Instances[PoolContext.this._tmpIndex].newStackPool();
        }
    };

    public FastTable getPools() {
        FastTable<ObjectPool> fastTable = FastTable.newInstance();
        int n = ObjectFactory._Count;
        while (n > 0) {
            ObjectPool objectPool;
            if ((objectPool = this._pools[--n]) == null) continue;
            fastTable.add(objectPool);
        }
        return fastTable;
    }

    public void setPools(FastTable fastTable) {
        for (int i = 0; i < fastTable.size(); ++i) {
            ObjectPool objectPool;
            this._pools[objectPool.getFactory()._index] = objectPool = (ObjectPool)fastTable.get(i);
        }
    }

    public static PoolContext current() {
        for (Context context = Context.current(); context != null; context = context.getOuter()) {
            if (context instanceof PoolContext) {
                return (PoolContext)context;
            }
            if (!(context instanceof HeapContext)) continue;
            return null;
        }
        throw new JavolutionError("No heap context or pool context");
    }

    public static void enter() {
        Context.enter(CLASS);
    }

    public static void exit() {
        Context.exit(CLASS);
    }

    public void clear() {
        super.clear();
        int n = ObjectFactory._Count;
        while (n > 0) {
            ObjectPool objectPool;
            if ((objectPool = this._pools[--n]) == null) continue;
            objectPool.clearAll();
        }
        this._inUsePoolsLength = 0;
    }

    protected void enterAction() {
        Context context = this.getOuter();
        if (context != null) {
            context.setPoolsActive(false);
        }
        this._poolsShortcut = this._pools;
    }

    protected void exitAction() {
        this.recyclePools();
        Context context = this.getOuter();
        if (context != null) {
            context.setPoolsActive(true);
        }
    }

    void setPoolsActive(boolean bl) {
        Thread thread = bl ? this.getOwner() : null;
        int n = this._inUsePoolsLength;
        while (n > 0) {
            this._inUsePools[--n]._user = thread;
        }
    }

    ObjectPool getPool(int n, boolean bl) {
        ObjectPool objectPool = this._pools[n];
        if (objectPool == null) {
            this._tmpIndex = n;
            MemoryArea.getMemoryArea(this).executeInArea(this.NEW_POOL);
            objectPool = this._pools[n];
        }
        if (!objectPool._inUse) {
            objectPool._inUse = true;
            this._inUsePools[this._inUsePoolsLength++] = objectPool;
        }
        if (bl) {
            objectPool._user = this.getOwner();
        }
        return objectPool;
    }

    void recyclePools() {
        int n = this._inUsePoolsLength;
        while (n > 0) {
            ObjectPool objectPool = this._inUsePools[--n];
            objectPool.recycleAll();
            objectPool._user = null;
            objectPool._inUse = false;
        }
        this._inUsePoolsLength = 0;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Reference<T>
    extends RealtimeObject
    implements javolution.lang.Reference<T> {
        private static final RealtimeObject.Factory FACTORY = new RealtimeObject.Factory(){

            protected Object create() {
                return new Reference();
            }

            protected void cleanup(Object object) {
                ((Reference)object)._value = null;
            }
        };
        private T _value;

        private Reference() {
        }

        public static <T> Reference<T> newInstance() {
            return (Reference)FACTORY.object();
        }

        @Override
        public Text toText() {
            return Text.valueOf(this.get());
        }

        @Override
        public T get() {
            return this._value;
        }

        @Override
        public void set(T t) {
            this._value = t;
        }
    }
}

