/*
 * Decompiled with CFR 0.152.
 */
package javolution.text;

import java.io.IOException;
import javolution.lang.MathLib;
import javolution.text.CharArray;
import javolution.text.Text;
import javolution.text.TextBuilder;
import javolution.text.TextFormat;

public final class TypeFormat {
    static final ThreadLocal CURSOR = new ThreadLocal(){

        protected Object initialValue() {
            return new TextFormat.Cursor();
        }
    };
    private static final char[] DIGIT_TO_CHAR = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
    private static final int[] INT_POW_10 = new int[10];
    private static final long[] LONG_POW_10;
    private static final double POSITIVE_INFINITY = Double.POSITIVE_INFINITY;
    private static final double NEGATIVE_INFINITY = Double.NEGATIVE_INFINITY;

    private TypeFormat() {
    }

    public static boolean parseBoolean(CharSequence charSequence) {
        if (!(charSequence.length() != 4 || charSequence.charAt(0) != 't' && charSequence.charAt(0) != 'T' || charSequence.charAt(1) != 'r' && charSequence.charAt(1) != 'R' || charSequence.charAt(2) != 'u' && charSequence.charAt(2) != 'U' || charSequence.charAt(3) != 'e' && charSequence.charAt(3) != 'E')) {
            return true;
        }
        if (!(charSequence.length() != 5 || charSequence.charAt(0) != 'f' && charSequence.charAt(0) != 'F' || charSequence.charAt(1) != 'a' && charSequence.charAt(1) != 'A' || charSequence.charAt(2) != 'l' && charSequence.charAt(2) != 'L' || charSequence.charAt(3) != 's' && charSequence.charAt(3) != 'S' || charSequence.charAt(4) != 'e' && charSequence.charAt(4) != 'E')) {
            return false;
        }
        throw new IllegalArgumentException("Cannot parse " + charSequence + " as boolean");
    }

    public static boolean parseBoolean(CharSequence charSequence, TextFormat.Cursor cursor) {
        int n = cursor.getIndex();
        if (!(charSequence.length() <= n + 4 || charSequence.charAt(n) != 't' && charSequence.charAt(n) != 'T' || charSequence.charAt(n + 1) != 'r' && charSequence.charAt(n + 1) != 'R' || charSequence.charAt(n + 2) != 'u' && charSequence.charAt(n + 2) != 'U' || charSequence.charAt(n + 3) != 'e' && charSequence.charAt(n + 3) != 'E')) {
            cursor.increment(4);
            return true;
        }
        if (!(charSequence.length() <= n + 5 || charSequence.charAt(n) != 'f' && charSequence.charAt(n) != 'F' || charSequence.charAt(n + 1) != 'a' && charSequence.charAt(n + 1) != 'A' || charSequence.charAt(n + 2) != 'l' && charSequence.charAt(n + 2) != 'L' || charSequence.charAt(n + 3) != 's' && charSequence.charAt(n + 3) != 'S' || charSequence.charAt(n + 4) != 'e' && charSequence.charAt(n + 4) != 'E')) {
            cursor.increment(5);
            return false;
        }
        throw new IllegalArgumentException("Cannot parse boolean at " + cursor.getIndex());
    }

    public static byte parseByte(CharSequence charSequence) {
        return TypeFormat.parseByte(charSequence, 10);
    }

    public static byte parseByte(CharSequence charSequence, int n) {
        int n2 = TypeFormat.parseInt(charSequence, n);
        if (n2 < -128 || n2 > 127) {
            throw new NumberFormatException("Overflow");
        }
        return (byte)n2;
    }

    public static byte parseByte(CharSequence charSequence, int n, TextFormat.Cursor cursor) {
        int n2 = TypeFormat.parseInt(charSequence, n, cursor);
        if (n2 < -128 || n2 > 127) {
            throw new NumberFormatException("Overflow");
        }
        return (byte)n2;
    }

    public static short parseShort(CharSequence charSequence) {
        return TypeFormat.parseShort(charSequence, 10);
    }

    public static short parseShort(CharSequence charSequence, int n) {
        int n2 = TypeFormat.parseInt(charSequence, n);
        if (n2 < Short.MIN_VALUE || n2 > Short.MAX_VALUE) {
            throw new NumberFormatException("Overflow");
        }
        return (short)n2;
    }

    public static short parseShort(CharSequence charSequence, int n, TextFormat.Cursor cursor) {
        int n2 = TypeFormat.parseInt(charSequence, n, cursor);
        if (n2 < Short.MIN_VALUE || n2 > Short.MAX_VALUE) {
            throw new NumberFormatException("Overflow");
        }
        return (short)n2;
    }

    public static int parseInt(CharSequence charSequence) {
        return TypeFormat.parseInt(charSequence, 10);
    }

    public static int parseInt(CharSequence charSequence, int n) {
        return TypeFormat.parseInt(charSequence, n, null);
    }

    public static int parseInt(CharSequence charSequence, int n, TextFormat.Cursor cursor) {
        if (charSequence instanceof CharArray) {
            return TypeFormat.parseIntCharArray((CharArray)charSequence, n, cursor);
        }
        if (charSequence instanceof TextBuilder) {
            return TypeFormat.parseIntTextBuilder((TextBuilder)charSequence, n, cursor);
        }
        if (charSequence instanceof Text) {
            return TypeFormat.parseIntText((Text)charSequence, n, cursor);
        }
        if (charSequence instanceof String) {
            return TypeFormat.parseIntString((String)charSequence, n, cursor);
        }
        return TypeFormat.parseIntCharSequence(charSequence, n, cursor);
    }

    private static int parseIntCharArray(CharArray charArray, int n, TextFormat.Cursor cursor) {
        int n2;
        int n3 = cursor != null ? cursor.getIndex() : 0;
        int n4 = charArray.length();
        boolean bl = false;
        int n5 = 0;
        for (n2 = n3; n2 < n4; ++n2) {
            int n6;
            char c = charArray.charAt(n2);
            int n7 = c <= '9' ? c - 48 : (c <= 'Z' && c >= 'A' ? c - 65 + 10 : (n6 = c <= 'z' && c >= 'a' ? c - 97 + 10 : -1));
            if (n6 >= 0 && n6 < n) {
                int n8 = n5 * n - n6;
                if (n8 > n5) {
                    throw new NumberFormatException("Overflow");
                }
                n5 = n8;
                continue;
            }
            if (c == '-' && n2 == n3) {
                bl = true;
                continue;
            }
            if (c == '+' && n2 == n3) continue;
            if (cursor != null) break;
            throw new NumberFormatException("Incomplete parsing");
        }
        if (n5 == 0 && (n4 == 0 || charArray.charAt(n2 - 1) != '0')) {
            throw new NumberFormatException("Cannot parse " + charArray + " as int");
        }
        if (n5 == Integer.MIN_VALUE && !bl) {
            throw new NumberFormatException("Overflow");
        }
        if (cursor != null) {
            cursor.setIndex(n2);
        }
        return bl ? n5 : -n5;
    }

    private static int parseIntTextBuilder(TextBuilder textBuilder, int n, TextFormat.Cursor cursor) {
        int n2;
        int n3 = cursor != null ? cursor.getIndex() : 0;
        int n4 = textBuilder.length();
        boolean bl = false;
        int n5 = 0;
        for (n2 = n3; n2 < n4; ++n2) {
            int n6;
            char c = textBuilder.charAt(n2);
            int n7 = c <= '9' ? c - 48 : (c <= 'Z' && c >= 'A' ? c - 65 + 10 : (n6 = c <= 'z' && c >= 'a' ? c - 97 + 10 : -1));
            if (n6 >= 0 && n6 < n) {
                int n8 = n5 * n - n6;
                if (n8 > n5) {
                    throw new NumberFormatException("Overflow");
                }
                n5 = n8;
                continue;
            }
            if (c == '-' && n2 == n3) {
                bl = true;
                continue;
            }
            if (c == '+' && n2 == n3) continue;
            if (cursor != null) break;
            throw new NumberFormatException("Incomplete parsing");
        }
        if (n5 == 0 && (n4 == 0 || textBuilder.charAt(n2 - 1) != '0')) {
            throw new NumberFormatException("Cannot parse " + textBuilder + " as int");
        }
        if (n5 == Integer.MIN_VALUE && !bl) {
            throw new NumberFormatException("Overflow");
        }
        if (cursor != null) {
            cursor.setIndex(n2);
        }
        return bl ? n5 : -n5;
    }

    private static int parseIntText(Text text, int n, TextFormat.Cursor cursor) {
        int n2;
        int n3 = cursor != null ? cursor.getIndex() : 0;
        int n4 = text.length();
        boolean bl = false;
        int n5 = 0;
        for (n2 = n3; n2 < n4; ++n2) {
            int n6;
            char c = text.charAt(n2);
            int n7 = c <= '9' ? c - 48 : (c <= 'Z' && c >= 'A' ? c - 65 + 10 : (n6 = c <= 'z' && c >= 'a' ? c - 97 + 10 : -1));
            if (n6 >= 0 && n6 < n) {
                int n8 = n5 * n - n6;
                if (n8 > n5) {
                    throw new NumberFormatException("Overflow");
                }
                n5 = n8;
                continue;
            }
            if (c == '-' && n2 == n3) {
                bl = true;
                continue;
            }
            if (c == '+' && n2 == n3) continue;
            if (cursor != null) break;
            throw new NumberFormatException("Incomplete parsing");
        }
        if (n5 == 0 && (n4 == 0 || text.charAt(n2 - 1) != '0')) {
            throw new NumberFormatException("Cannot parse " + text + " as int");
        }
        if (n5 == Integer.MIN_VALUE && !bl) {
            throw new NumberFormatException("Overflow");
        }
        if (cursor != null) {
            cursor.setIndex(n2);
        }
        return bl ? n5 : -n5;
    }

    private static int parseIntString(String string, int n, TextFormat.Cursor cursor) {
        int n2;
        int n3 = cursor != null ? cursor.getIndex() : 0;
        int n4 = string.length();
        boolean bl = false;
        int n5 = 0;
        for (n2 = n3; n2 < n4; ++n2) {
            int n6;
            char c = string.charAt(n2);
            int n7 = c <= '9' ? c - 48 : (c <= 'Z' && c >= 'A' ? c - 65 + 10 : (n6 = c <= 'z' && c >= 'a' ? c - 97 + 10 : -1));
            if (n6 >= 0 && n6 < n) {
                int n8 = n5 * n - n6;
                if (n8 > n5) {
                    throw new NumberFormatException("Overflow");
                }
                n5 = n8;
                continue;
            }
            if (c == '-' && n2 == n3) {
                bl = true;
                continue;
            }
            if (c == '+' && n2 == n3) continue;
            if (cursor != null) break;
            throw new NumberFormatException("Incomplete parsing");
        }
        if (n5 == 0 && (n4 == 0 || string.charAt(n2 - 1) != '0')) {
            throw new NumberFormatException("Cannot parse " + string + " as int");
        }
        if (n5 == Integer.MIN_VALUE && !bl) {
            throw new NumberFormatException("Overflow");
        }
        if (cursor != null) {
            cursor.setIndex(n2);
        }
        return bl ? n5 : -n5;
    }

    private static int parseIntCharSequence(CharSequence charSequence, int n, TextFormat.Cursor cursor) {
        int n2;
        int n3 = cursor != null ? cursor.getIndex() : 0;
        int n4 = charSequence.length();
        boolean bl = false;
        int n5 = 0;
        for (n2 = n3; n2 < n4; ++n2) {
            int n6;
            char c = charSequence.charAt(n2);
            int n7 = c <= '9' ? c - 48 : (c <= 'Z' && c >= 'A' ? c - 65 + 10 : (n6 = c <= 'z' && c >= 'a' ? c - 97 + 10 : -1));
            if (n6 >= 0 && n6 < n) {
                int n8 = n5 * n - n6;
                if (n8 > n5) {
                    throw new NumberFormatException("Overflow");
                }
                n5 = n8;
                continue;
            }
            if (c == '-' && n2 == n3) {
                bl = true;
                continue;
            }
            if (c == '+' && n2 == n3) continue;
            if (cursor != null) break;
            throw new NumberFormatException("Incomplete parsing");
        }
        if (n5 == 0 && (n4 == 0 || charSequence.charAt(n2 - 1) != '0')) {
            throw new NumberFormatException("Cannot parse " + charSequence + " as int");
        }
        if (n5 == Integer.MIN_VALUE && !bl) {
            throw new NumberFormatException("Overflow");
        }
        if (cursor != null) {
            cursor.setIndex(n2);
        }
        return bl ? n5 : -n5;
    }

    public static long parseLong(CharSequence charSequence) {
        return TypeFormat.parseLong(charSequence, 10);
    }

    public static long parseLong(CharSequence charSequence, int n) {
        return TypeFormat.parseLong(charSequence, n, null);
    }

    public static long parseLong(CharSequence charSequence, int n, TextFormat.Cursor cursor) {
        if (charSequence instanceof CharArray) {
            return TypeFormat.parseLongCharArray((CharArray)charSequence, n, cursor);
        }
        if (charSequence instanceof TextBuilder) {
            return TypeFormat.parseLongTextBuilder((TextBuilder)charSequence, n, cursor);
        }
        if (charSequence instanceof Text) {
            return TypeFormat.parseLongText((Text)charSequence, n, cursor);
        }
        if (charSequence instanceof String) {
            return TypeFormat.parseLongString((String)charSequence, n, cursor);
        }
        return TypeFormat.parseLongCharSequence(charSequence, n, cursor);
    }

    private static long parseLongCharArray(CharArray charArray, int n, TextFormat.Cursor cursor) {
        int n2;
        int n3 = cursor != null ? cursor.getIndex() : 0;
        int n4 = charArray.length();
        boolean bl = false;
        long l = 0L;
        for (n2 = n3; n2 < n4; ++n2) {
            int n5;
            char c = charArray.charAt(n2);
            int n6 = c <= '9' ? c - 48 : (c <= 'Z' && c >= 'A' ? c - 65 + 10 : (n5 = c <= 'z' && c >= 'a' ? c - 97 + 10 : -1));
            if (n5 >= 0 && n5 < n) {
                long l2 = l * (long)n - (long)n5;
                if (l2 > l) {
                    throw new NumberFormatException("Overflow");
                }
                l = l2;
                continue;
            }
            if (c == '-' && n2 == n3) {
                bl = true;
                continue;
            }
            if (c == '+' && n2 == n3) continue;
            if (cursor != null) break;
            throw new NumberFormatException("Incomplete parsing");
        }
        if (l == 0L && (n4 == 0 || charArray.charAt(n2 - 1) != '0')) {
            throw new NumberFormatException("Cannot parse " + charArray + " as int");
        }
        if (l == Long.MIN_VALUE && !bl) {
            throw new NumberFormatException("Overflow");
        }
        if (cursor != null) {
            cursor.setIndex(n2);
        }
        return bl ? l : -l;
    }

    private static long parseLongTextBuilder(TextBuilder textBuilder, int n, TextFormat.Cursor cursor) {
        int n2;
        int n3 = cursor != null ? cursor.getIndex() : 0;
        int n4 = textBuilder.length();
        boolean bl = false;
        long l = 0L;
        for (n2 = n3; n2 < n4; ++n2) {
            int n5;
            char c = textBuilder.charAt(n2);
            int n6 = c <= '9' ? c - 48 : (c <= 'Z' && c >= 'A' ? c - 65 + 10 : (n5 = c <= 'z' && c >= 'a' ? c - 97 + 10 : -1));
            if (n5 >= 0 && n5 < n) {
                long l2 = l * (long)n - (long)n5;
                if (l2 > l) {
                    throw new NumberFormatException("Overflow");
                }
                l = l2;
                continue;
            }
            if (c == '-' && n2 == n3) {
                bl = true;
                continue;
            }
            if (c == '+' && n2 == n3) continue;
            if (cursor != null) break;
            throw new NumberFormatException("Incomplete parsing");
        }
        if (l == 0L && (n4 == 0 || textBuilder.charAt(n2 - 1) != '0')) {
            throw new NumberFormatException("Cannot parse " + textBuilder + " as int");
        }
        if (l == Long.MIN_VALUE && !bl) {
            throw new NumberFormatException("Overflow");
        }
        if (cursor != null) {
            cursor.setIndex(n2);
        }
        return bl ? l : -l;
    }

    private static long parseLongText(Text text, int n, TextFormat.Cursor cursor) {
        int n2;
        int n3 = cursor != null ? cursor.getIndex() : 0;
        int n4 = text.length();
        boolean bl = false;
        long l = 0L;
        for (n2 = n3; n2 < n4; ++n2) {
            int n5;
            char c = text.charAt(n2);
            int n6 = c <= '9' ? c - 48 : (c <= 'Z' && c >= 'A' ? c - 65 + 10 : (n5 = c <= 'z' && c >= 'a' ? c - 97 + 10 : -1));
            if (n5 >= 0 && n5 < n) {
                long l2 = l * (long)n - (long)n5;
                if (l2 > l) {
                    throw new NumberFormatException("Overflow");
                }
                l = l2;
                continue;
            }
            if (c == '-' && n2 == n3) {
                bl = true;
                continue;
            }
            if (c == '+' && n2 == n3) continue;
            if (cursor != null) break;
            throw new NumberFormatException("Incomplete parsing");
        }
        if (l == 0L && (n4 == 0 || text.charAt(n2 - 1) != '0')) {
            throw new NumberFormatException("Cannot parse " + text + " as int");
        }
        if (l == Long.MIN_VALUE && !bl) {
            throw new NumberFormatException("Overflow");
        }
        if (cursor != null) {
            cursor.setIndex(n2);
        }
        return bl ? l : -l;
    }

    private static long parseLongString(String string, int n, TextFormat.Cursor cursor) {
        int n2;
        int n3 = cursor != null ? cursor.getIndex() : 0;
        int n4 = string.length();
        boolean bl = false;
        long l = 0L;
        for (n2 = n3; n2 < n4; ++n2) {
            int n5;
            char c = string.charAt(n2);
            int n6 = c <= '9' ? c - 48 : (c <= 'Z' && c >= 'A' ? c - 65 + 10 : (n5 = c <= 'z' && c >= 'a' ? c - 97 + 10 : -1));
            if (n5 >= 0 && n5 < n) {
                long l2 = l * (long)n - (long)n5;
                if (l2 > l) {
                    throw new NumberFormatException("Overflow");
                }
                l = l2;
                continue;
            }
            if (c == '-' && n2 == n3) {
                bl = true;
                continue;
            }
            if (c == '+' && n2 == n3) continue;
            if (cursor != null) break;
            throw new NumberFormatException("Incomplete parsing");
        }
        if (l == 0L && (n4 == 0 || string.charAt(n2 - 1) != '0')) {
            throw new NumberFormatException("Cannot parse " + string + " as int");
        }
        if (l == Long.MIN_VALUE && !bl) {
            throw new NumberFormatException("Overflow");
        }
        if (cursor != null) {
            cursor.setIndex(n2);
        }
        return bl ? l : -l;
    }

    private static long parseLongCharSequence(CharSequence charSequence, int n, TextFormat.Cursor cursor) {
        int n2;
        int n3 = cursor != null ? cursor.getIndex() : 0;
        int n4 = charSequence.length();
        boolean bl = false;
        long l = 0L;
        for (n2 = n3; n2 < n4; ++n2) {
            int n5;
            char c = charSequence.charAt(n2);
            int n6 = c <= '9' ? c - 48 : (c <= 'Z' && c >= 'A' ? c - 65 + 10 : (n5 = c <= 'z' && c >= 'a' ? c - 97 + 10 : -1));
            if (n5 >= 0 && n5 < n) {
                long l2 = l * (long)n - (long)n5;
                if (l2 > l) {
                    throw new NumberFormatException("Overflow");
                }
                l = l2;
                continue;
            }
            if (c == '-' && n2 == n3) {
                bl = true;
                continue;
            }
            if (c == '+' && n2 == n3) continue;
            if (cursor != null) break;
            throw new NumberFormatException("Incomplete parsing");
        }
        if (l == 0L && (n4 == 0 || charSequence.charAt(n2 - 1) != '0')) {
            throw new NumberFormatException("Cannot parse " + charSequence + " as int");
        }
        if (l == Long.MIN_VALUE && !bl) {
            throw new NumberFormatException("Overflow");
        }
        if (cursor != null) {
            cursor.setIndex(n2);
        }
        return bl ? l : -l;
    }

    public static float parseFloat(CharSequence charSequence) {
        return (float)TypeFormat.parseDouble(charSequence);
    }

    public static float parseFloat(CharSequence charSequence, TextFormat.Cursor cursor) {
        return (float)TypeFormat.parseDouble(charSequence, cursor);
    }

    public static double parseDouble(CharSequence charSequence) throws NumberFormatException {
        TextFormat.Cursor cursor = (TextFormat.Cursor)CURSOR.get();
        cursor.setIndex(0);
        double d = TypeFormat.parseDouble(charSequence, cursor);
        if (cursor.getIndex() != charSequence.length()) {
            throw new NumberFormatException("Incomplete parsing");
        }
        return d;
    }

    public static double parseDouble(CharSequence charSequence, TextFormat.Cursor cursor) throws NumberFormatException {
        try {
            int n;
            int n2;
            int n3 = cursor.getIndex();
            boolean bl = charSequence.charAt(n3) == '-';
            char c = charSequence.charAt(n3 += bl || charSequence.charAt(n3) == '+' ? 1 : 0);
            if (c == 'N' && TypeFormat.startWith(charSequence, n3, "NaN")) {
                cursor.setIndex(n3 + 3);
                return Double.NaN;
            }
            if (c == 'I' && TypeFormat.startWith(charSequence, n3, "Infinity")) {
                cursor.setIndex(n3 + 8);
                return bl ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
            }
            cursor.setIndex(n3);
            long l = TypeFormat.parseLong(charSequence, 10, cursor);
            int n4 = charSequence.length();
            long l2 = 0L;
            int n5 = 0;
            if (cursor.getIndex() < n4 && (n2 = charSequence.charAt(cursor.getIndex())) == 46) {
                cursor.increment();
                n = cursor.getIndex();
                l2 = TypeFormat.parseLong(charSequence, 10, cursor);
                n5 = cursor.getIndex() - n;
            }
            n2 = 0;
            if (cursor.getIndex() < n4 && ((n = charSequence.charAt(cursor.getIndex())) == 101 || n == 69)) {
                cursor.increment();
                n2 = TypeFormat.parseInt(charSequence, 10, cursor);
            }
            double d = MathLib.toDouble(l, n2);
            double d2 = MathLib.toDouble(l < 0L ? -l2 : l2, n2 - n5);
            return bl ? -d - d2 : d + d2;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new NumberFormatException();
        }
    }

    static boolean startWith(CharSequence charSequence, int n, String string) {
        for (int i = 0; i < string.length(); ++i) {
            if (n + i < charSequence.length() && charSequence.charAt(n + i) == string.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public static Appendable format(boolean bl, Appendable appendable) throws IOException {
        return bl ? TypeFormat.append(appendable, "true") : TypeFormat.append(appendable, "false");
    }

    public static Appendable format(int n, Appendable appendable) throws IOException {
        if (appendable instanceof TextBuilder) {
            return TypeFormat.format(n, (TextBuilder)appendable);
        }
        if (n < 0) {
            if (n == Integer.MIN_VALUE) {
                return TypeFormat.append(appendable, "-2147483648");
            }
            n = -n;
            appendable.append('-');
        }
        if (n >= 100000) {
            int n2 = n / 100000;
            TypeFormat.writeDigits(n2, appendable, false);
            TypeFormat.writeDigits(n -= n2 * 100000, appendable, true);
        } else {
            TypeFormat.writeDigits(n, appendable, false);
        }
        return appendable;
    }

    static TextBuilder format(int n, TextBuilder textBuilder) {
        if (n < 0) {
            if (n == Integer.MIN_VALUE) {
                return textBuilder.append("-2147483648");
            }
            n = -n;
            textBuilder.append('-');
        }
        if (n >= 100000) {
            int n2 = n / 100000;
            TypeFormat.writeDigits(n2, textBuilder, false);
            TypeFormat.writeDigits(n -= n2 * 100000, textBuilder, true);
        } else {
            TypeFormat.writeDigits(n, textBuilder, false);
        }
        return textBuilder;
    }

    public static Appendable format(int n, int n2, Appendable appendable) throws IOException {
        if (n2 == 10) {
            return TypeFormat.format(n, appendable);
        }
        if (n2 < 2 || n2 > 36) {
            throw new IllegalArgumentException("radix: " + n2);
        }
        if (n < 0) {
            appendable.append('-');
        } else {
            n = -n;
        }
        TypeFormat.format2(n, n2, appendable);
        return appendable;
    }

    private static void format2(int n, int n2, Appendable appendable) throws IOException {
        if (n <= -n2) {
            TypeFormat.format2(n / n2, n2, appendable);
            appendable.append(DIGIT_TO_CHAR[-(n % n2)]);
        } else {
            appendable.append(DIGIT_TO_CHAR[-n]);
        }
    }

    public static Appendable format(long l, Appendable appendable) throws IOException {
        int n;
        if (appendable instanceof TextBuilder) {
            return TypeFormat.format(l, (TextBuilder)appendable);
        }
        if (l < 0L) {
            if (l == Long.MIN_VALUE) {
                return TypeFormat.append(appendable, "-9223372036854775808");
            }
            l = -l;
            appendable.append('-');
        }
        boolean bl = false;
        if (l >= 1000000000000000L) {
            n = (int)(l / 1000000000000000L);
            TypeFormat.writeDigits(n, appendable, bl);
            l -= (long)n * 1000000000000000L;
            bl = true;
        }
        if (bl || l >= 10000000000L) {
            n = (int)(l / 10000000000L);
            TypeFormat.writeDigits(n, appendable, bl);
            l -= (long)n * 10000000000L;
            bl = true;
        }
        if (bl || l >= 100000L) {
            n = (int)(l / 100000L);
            TypeFormat.writeDigits(n, appendable, bl);
            l -= (long)n * 100000L;
            bl = true;
        }
        TypeFormat.writeDigits((int)l, appendable, bl);
        return appendable;
    }

    static TextBuilder format(long l, TextBuilder textBuilder) {
        int n;
        if (l < 0L) {
            if (l == Long.MIN_VALUE) {
                return textBuilder.append("-9223372036854775808");
            }
            l = -l;
            textBuilder.append('-');
        }
        boolean bl = false;
        if (l >= 1000000000000000L) {
            n = (int)(l / 1000000000000000L);
            TypeFormat.writeDigits(n, textBuilder, bl);
            l -= (long)n * 1000000000000000L;
            bl = true;
        }
        if (bl || l >= 10000000000L) {
            n = (int)(l / 10000000000L);
            TypeFormat.writeDigits(n, textBuilder, bl);
            l -= (long)n * 10000000000L;
            bl = true;
        }
        if (bl || l >= 100000L) {
            n = (int)(l / 100000L);
            TypeFormat.writeDigits(n, textBuilder, bl);
            l -= (long)n * 100000L;
            bl = true;
        }
        TypeFormat.writeDigits((int)l, textBuilder, bl);
        return textBuilder;
    }

    public static Appendable format(long l, int n, Appendable appendable) throws IOException {
        if (n == 10) {
            return TypeFormat.format(l, appendable);
        }
        if (n < 2 || n > 36) {
            throw new IllegalArgumentException("radix: " + n);
        }
        if (l < 0L) {
            appendable.append('-');
        } else {
            l = -l;
        }
        TypeFormat.format2(l, n, appendable);
        return appendable;
    }

    private static void format2(long l, int n, Appendable appendable) throws IOException {
        if (l <= (long)(-n)) {
            TypeFormat.format2(l / (long)n, n, appendable);
            appendable.append(DIGIT_TO_CHAR[(int)(-(l % (long)n))]);
        } else {
            appendable.append(DIGIT_TO_CHAR[(int)(-l)]);
        }
    }

    public static Appendable format(float f, Appendable appendable) throws IOException {
        return TypeFormat.format(f, 10, (double)MathLib.abs(f) > 1.0E7, false, appendable);
    }

    public static Appendable format(double d, Appendable appendable) throws IOException {
        return TypeFormat.format(d, 17, MathLib.abs(d) > 1.0E7, false, appendable);
    }

    public static Appendable format(double d, int n, boolean bl, boolean bl2, Appendable appendable) throws IOException {
        if (n > 19 || n <= 0) {
            throw new IllegalArgumentException("digits: " + n);
        }
        if (d != d) {
            return TypeFormat.append(appendable, "NaN");
        }
        if (d == Double.POSITIVE_INFINITY) {
            return TypeFormat.append(appendable, "Infinity");
        }
        if (d == Double.NEGATIVE_INFINITY) {
            return TypeFormat.append(appendable, "-Infinity");
        }
        if (d == 0.0) {
            if (n == 1) {
                return TypeFormat.append(appendable, "0");
            }
            if (!bl2) {
                return TypeFormat.append(appendable, "0.0");
            }
            TypeFormat.append(appendable, "0.0");
            for (int i = 2; i < n; ++i) {
                appendable.append('0');
            }
            return appendable;
        }
        if (d < 0.0) {
            d = -d;
            appendable.append('-');
        }
        int n2 = d >= 1.0 ? 1 + TypeFormat.minPow10(d) : -TypeFormat.minPow10(1.0 / d);
        double d2 = d * MathLib.toDouble(1L, n - n2);
        long l = (long)(d2 + 0.5);
        if (bl || n2 <= 0 || n2 > n) {
            TypeFormat.format(l / LONG_POW_10[n - 1], appendable);
            TypeFormat.formatFraction(l % LONG_POW_10[n - 1], n - 1, bl2, appendable);
            appendable.append('E');
            TypeFormat.format(n2 - 1, appendable);
        } else if (n2 == n) {
            TypeFormat.format(l, appendable);
        } else {
            TypeFormat.format(l / LONG_POW_10[n - n2], appendable);
            TypeFormat.formatFraction(l % LONG_POW_10[n - n2], n - n2, bl2, appendable);
        }
        return appendable;
    }

    private static void formatFraction(long l, int n, boolean bl, Appendable appendable) throws IOException {
        if (n == 0) {
            return;
        }
        appendable.append('.');
        int n2 = n;
        while (n2 > 0) {
            long l2 = LONG_POW_10[--n2];
            int n3 = (int)(l / l2);
            appendable.append(DIGIT_TO_CHAR[n3]);
            if ((l -= (long)n3 * l2) != 0L || bl) continue;
            return;
        }
    }

    private static int minPow10(double d) {
        int n = 0;
        int n2 = 308;
        while (n2 - n > 1) {
            int n3 = n + n2 >> 1;
            if (d >= MathLib.toDouble(1L, n3)) {
                n = n3;
                continue;
            }
            n2 = n3;
        }
        return n;
    }

    private static Appendable append(Appendable appendable, String string) throws IOException {
        for (int i = 0; i < string.length(); ++i) {
            appendable.append(string.charAt(i));
        }
        return appendable;
    }

    private static void writeDigits(int n, TextBuilder textBuilder, boolean bl) {
        if (n >= 10000) {
            bl = true;
            if (n >= 50000) {
                if (n >= 80000) {
                    if (n >= 90000) {
                        textBuilder.append('9');
                        n -= 90000;
                    } else {
                        textBuilder.append('8');
                        n -= 80000;
                    }
                } else if (n >= 70000) {
                    textBuilder.append('7');
                    n -= 70000;
                } else if (n >= 60000) {
                    textBuilder.append('6');
                    n -= 60000;
                } else {
                    textBuilder.append('5');
                    n -= 50000;
                }
            } else if (n >= 30000) {
                if (n >= 40000) {
                    textBuilder.append('4');
                    n -= 40000;
                } else {
                    textBuilder.append('3');
                    n -= 30000;
                }
            } else if (n >= 20000) {
                textBuilder.append('2');
                n -= 20000;
            } else {
                textBuilder.append('1');
                n -= 10000;
            }
        } else if (bl) {
            textBuilder.append('0');
        }
        if (n >= 1000) {
            bl = true;
            if (n >= 5000) {
                if (n >= 8000) {
                    if (n >= 9000) {
                        textBuilder.append('9');
                        n -= 9000;
                    } else {
                        textBuilder.append('8');
                        n -= 8000;
                    }
                } else if (n >= 7000) {
                    textBuilder.append('7');
                    n -= 7000;
                } else if (n >= 6000) {
                    textBuilder.append('6');
                    n -= 6000;
                } else {
                    textBuilder.append('5');
                    n -= 5000;
                }
            } else if (n >= 3000) {
                if (n >= 4000) {
                    textBuilder.append('4');
                    n -= 4000;
                } else {
                    textBuilder.append('3');
                    n -= 3000;
                }
            } else if (n >= 2000) {
                textBuilder.append('2');
                n -= 2000;
            } else {
                textBuilder.append('1');
                n -= 1000;
            }
        } else if (bl) {
            textBuilder.append('0');
        }
        if (n >= 100) {
            bl = true;
            if (n >= 500) {
                if (n >= 800) {
                    if (n >= 900) {
                        textBuilder.append('9');
                        n -= 900;
                    } else {
                        textBuilder.append('8');
                        n -= 800;
                    }
                } else if (n >= 700) {
                    textBuilder.append('7');
                    n -= 700;
                } else if (n >= 600) {
                    textBuilder.append('6');
                    n -= 600;
                } else {
                    textBuilder.append('5');
                    n -= 500;
                }
            } else if (n >= 300) {
                if (n >= 400) {
                    textBuilder.append('4');
                    n -= 400;
                } else {
                    textBuilder.append('3');
                    n -= 300;
                }
            } else if (n >= 200) {
                textBuilder.append('2');
                n -= 200;
            } else {
                textBuilder.append('1');
                n -= 100;
            }
        } else if (bl) {
            textBuilder.append('0');
        }
        if (n >= 10) {
            bl = true;
            if (n >= 50) {
                if (n >= 80) {
                    if (n >= 90) {
                        textBuilder.append('9');
                        n -= 90;
                    } else {
                        textBuilder.append('8');
                        n -= 80;
                    }
                } else if (n >= 70) {
                    textBuilder.append('7');
                    n -= 70;
                } else if (n >= 60) {
                    textBuilder.append('6');
                    n -= 60;
                } else {
                    textBuilder.append('5');
                    n -= 50;
                }
            } else if (n >= 30) {
                if (n >= 40) {
                    textBuilder.append('4');
                    n -= 40;
                } else {
                    textBuilder.append('3');
                    n -= 30;
                }
            } else if (n >= 20) {
                textBuilder.append('2');
                n -= 20;
            } else {
                textBuilder.append('1');
                n -= 10;
            }
        } else if (bl) {
            textBuilder.append('0');
        }
        textBuilder.append(DIGIT_TO_CHAR[n]);
    }

    private static void writeDigits(int n, Appendable appendable, boolean bl) throws IOException {
        if (n >= 10000) {
            bl = true;
            if (n >= 50000) {
                if (n >= 80000) {
                    if (n >= 90000) {
                        appendable.append('9');
                        n -= 90000;
                    } else {
                        appendable.append('8');
                        n -= 80000;
                    }
                } else if (n >= 70000) {
                    appendable.append('7');
                    n -= 70000;
                } else if (n >= 60000) {
                    appendable.append('6');
                    n -= 60000;
                } else {
                    appendable.append('5');
                    n -= 50000;
                }
            } else if (n >= 30000) {
                if (n >= 40000) {
                    appendable.append('4');
                    n -= 40000;
                } else {
                    appendable.append('3');
                    n -= 30000;
                }
            } else if (n >= 20000) {
                appendable.append('2');
                n -= 20000;
            } else {
                appendable.append('1');
                n -= 10000;
            }
        } else if (bl) {
            appendable.append('0');
        }
        if (n >= 1000) {
            bl = true;
            if (n >= 5000) {
                if (n >= 8000) {
                    if (n >= 9000) {
                        appendable.append('9');
                        n -= 9000;
                    } else {
                        appendable.append('8');
                        n -= 8000;
                    }
                } else if (n >= 7000) {
                    appendable.append('7');
                    n -= 7000;
                } else if (n >= 6000) {
                    appendable.append('6');
                    n -= 6000;
                } else {
                    appendable.append('5');
                    n -= 5000;
                }
            } else if (n >= 3000) {
                if (n >= 4000) {
                    appendable.append('4');
                    n -= 4000;
                } else {
                    appendable.append('3');
                    n -= 3000;
                }
            } else if (n >= 2000) {
                appendable.append('2');
                n -= 2000;
            } else {
                appendable.append('1');
                n -= 1000;
            }
        } else if (bl) {
            appendable.append('0');
        }
        if (n >= 100) {
            bl = true;
            if (n >= 500) {
                if (n >= 800) {
                    if (n >= 900) {
                        appendable.append('9');
                        n -= 900;
                    } else {
                        appendable.append('8');
                        n -= 800;
                    }
                } else if (n >= 700) {
                    appendable.append('7');
                    n -= 700;
                } else if (n >= 600) {
                    appendable.append('6');
                    n -= 600;
                } else {
                    appendable.append('5');
                    n -= 500;
                }
            } else if (n >= 300) {
                if (n >= 400) {
                    appendable.append('4');
                    n -= 400;
                } else {
                    appendable.append('3');
                    n -= 300;
                }
            } else if (n >= 200) {
                appendable.append('2');
                n -= 200;
            } else {
                appendable.append('1');
                n -= 100;
            }
        } else if (bl) {
            appendable.append('0');
        }
        if (n >= 10) {
            bl = true;
            if (n >= 50) {
                if (n >= 80) {
                    if (n >= 90) {
                        appendable.append('9');
                        n -= 90;
                    } else {
                        appendable.append('8');
                        n -= 80;
                    }
                } else if (n >= 70) {
                    appendable.append('7');
                    n -= 70;
                } else if (n >= 60) {
                    appendable.append('6');
                    n -= 60;
                } else {
                    appendable.append('5');
                    n -= 50;
                }
            } else if (n >= 30) {
                if (n >= 40) {
                    appendable.append('4');
                    n -= 40;
                } else {
                    appendable.append('3');
                    n -= 30;
                }
            } else if (n >= 20) {
                appendable.append('2');
                n -= 20;
            } else {
                appendable.append('1');
                n -= 10;
            }
        } else if (bl) {
            appendable.append('0');
        }
        appendable.append(DIGIT_TO_CHAR[n]);
    }

    static {
        int n = 1;
        for (int i = 0; i < 10; ++i) {
            TypeFormat.INT_POW_10[i] = n;
            n *= 10;
        }
        LONG_POW_10 = new long[19];
        long l = 1L;
        for (int i = 0; i < 19; ++i) {
            TypeFormat.LONG_POW_10[i] = l;
            l *= 10L;
        }
    }
}

