{application, tsung_controller,
      [{description,  "tsung, a bench tool for TCP/UDP servers"},
       {vsn,          "1.5.1"},
       {modules,      [
                       tsung_controller,
                       ts_controller_sup,
                       ts_stats_mon,
                       ts_mon,
                       ts_timer,
                       ts_user_server,
                       ts_config_server,
                       ts_msg_server,
                       ts_file_server,
                       ts_os_mon
                      ]},
       {registered,   [
                       ts_stats,
                       ts_mon,
                       ts_config_server,
                       ts_os_mon
                      ]},
       {env,        [
                     {debug_level, 6},
                     {smp_disable, true}, % disable smp on clients
                     {ts_cookie, "humhum"},
                     {clients_timeout, 60000},    % timeout for global synchro
                     {file_server_timeout, 30000},% timeout for reading file
                     {warm_time, 1}, % (seconds) initial waiting time when launching clients

                     {thinktime_value, "5"}, % default value = 5sec
                     {thinktime_override, "false"},
                     {thinktime_random, "false"},

                     {munin_port, 4949},

                     {snmp_port, 161},
                     {snmp_version, v2},
                     {snmp_community, "public"},

                     {mysql_port, 3306},
                     {mysql_user, "root"},
                     {mysql_password, false},

                     {dumpstats_interval, 10000},
                     {dump, none},          %% full or light or none
                     {stats_backend, none}, %% text|rrdtool

                     {nclients, 10},        %% number of clients
                     {nclients_deb, 1},     %% beginning of interval
                     {nclients_fin, 2000},     %% end of interval
                     {config_file, "./tsung.xml"},
                     {log_file, "./tsung.log"},
                     {match_log_file, "./match.log"},
                     {exclude_tag, ""}
                    ]},
       {applications, [ kernel,stdlib,asn1,crypto,public_key,ssl,crypto ]},
       {start_phases, [{load_config, []},{start_os_monitoring,[{timeout,30000}]},
                       {start_clients,[]}]},
       {mod,          {tsung_controller, []}}
      ]}.
