/*
 * Decompiled with CFR 0.152.
 */
package MCview;

import MCview.Bond;
import MCview.Matrix;
import MCview.PDBChain;
import MCview.PDBfile;
import MCview.Zsort;
import MCview.myAtom;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.io.IOException;
import java.util.Vector;

public class rotCanvas
extends Canvas {
    Matrix idmat = new Matrix(3, 3);
    Matrix objmat = new Matrix(3, 3);
    boolean redrawneeded = true;
    int omx;
    int mx;
    int omy;
    int my;
    public PDBfile pdb;
    int bsize;
    Image img;
    Graphics ig;
    Dimension prefsize;
    float[] centre = new float[3];
    float[] width = new float[3];
    float maxwidth;
    float scale;
    String inStr;
    String inType;
    boolean depthcue = true;
    boolean wire = false;
    boolean bymolecule = false;
    boolean zbuffer = true;
    boolean dragging;
    int xstart;
    int xend;
    int ystart;
    int yend;
    int xmid;
    int ymid;
    Font font = new Font("Helvetica", 0, 10);

    public rotCanvas(PDBfile pDBfile, Dimension dimension) throws IOException {
        this.pdb = pDBfile;
        this.prefsize = new Dimension(dimension);
        int n = 0;
        while (n < 3) {
            int n2 = 0;
            while (n2 < 3) {
                if (n != n2) {
                    this.idmat.addElement(n, n2, 0.0f);
                    this.objmat.addElement(n, n2, 0.0f);
                } else {
                    this.idmat.addElement(n, n2, 1.0f);
                    this.objmat.addElement(n, n2, 1.0f);
                }
                ++n2;
            }
            ++n;
        }
        this.addPDBfile();
    }

    public void addPDBfile() {
        this.findCentre();
        this.findWidth();
        this.scale = this.findScale();
        System.out.println("Scale factor = " + this.scale);
    }

    public void deleteBonds() {
        this.scale = 0.0f;
        this.maxwidth = 0.0f;
        this.width[0] = 0.0f;
        this.width[1] = 0.0f;
        this.width[2] = 0.0f;
        this.centre[0] = 0.0f;
        this.centre[1] = 0.0f;
        this.centre[2] = 0.0f;
        int n = 0;
        while (n < this.pdb.chains.size()) {
            ((PDBChain)this.pdb.chains.elementAt((int)n)).bonds = null;
            ++n;
        }
    }

    public void findWidth() {
        float[] fArray = new float[3];
        float[] fArray2 = new float[3];
        fArray[0] = -1.0E30f;
        fArray[1] = -1.0E30f;
        fArray[2] = -1.0E30f;
        fArray2[0] = 1.0E30f;
        fArray2[1] = 1.0E30f;
        fArray2[2] = 1.0E30f;
        int n = 0;
        while (n < this.pdb.chains.size()) {
            if (((PDBChain)this.pdb.chains.elementAt((int)n)).isVisible) {
                Vector vector = ((PDBChain)this.pdb.chains.elementAt((int)n)).bonds;
                int n2 = 0;
                while (n2 < vector.size()) {
                    Bond bond = (Bond)vector.elementAt(n2);
                    if (bond.start[0] >= fArray[0]) {
                        fArray[0] = bond.start[0];
                    }
                    if (bond.start[1] >= fArray[1]) {
                        fArray[1] = bond.start[1];
                    }
                    if (bond.start[2] >= fArray[2]) {
                        fArray[2] = bond.start[2];
                    }
                    if (bond.start[0] <= fArray2[0]) {
                        fArray2[0] = bond.start[0];
                    }
                    if (bond.start[1] <= fArray2[1]) {
                        fArray2[1] = bond.start[1];
                    }
                    if (bond.start[2] <= fArray2[2]) {
                        fArray2[2] = bond.start[2];
                    }
                    if (bond.end[0] >= fArray[0]) {
                        fArray[0] = bond.end[0];
                    }
                    if (bond.end[1] >= fArray[1]) {
                        fArray[1] = bond.end[1];
                    }
                    if (bond.end[2] >= fArray[2]) {
                        fArray[2] = bond.end[2];
                    }
                    if (bond.end[0] <= fArray2[0]) {
                        fArray2[0] = bond.end[0];
                    }
                    if (bond.end[1] <= fArray2[1]) {
                        fArray2[1] = bond.end[1];
                    }
                    if (bond.end[2] <= fArray2[2]) {
                        fArray2[2] = bond.end[2];
                    }
                    ++n2;
                }
            }
            ++n;
        }
        System.out.println("xmax " + fArray[0] + " min " + fArray2[0]);
        System.out.println("ymax " + fArray[1] + " min " + fArray2[1]);
        System.out.println("zmax " + fArray[2] + " min " + fArray2[2]);
        this.width[0] = Math.abs(fArray[0] - fArray2[0]);
        this.width[1] = Math.abs(fArray[1] - fArray2[1]);
        this.width[2] = Math.abs(fArray[2] - fArray2[2]);
        this.maxwidth = this.width[0];
        if (this.width[1] > this.width[0]) {
            this.maxwidth = this.width[1];
        }
        if (this.width[2] > this.width[1]) {
            this.maxwidth = this.width[2];
        }
        System.out.println("Maxwidth = " + this.maxwidth);
    }

    public float findScale() {
        int n;
        int n2;
        if (this.size().width != 0) {
            n2 = this.size().width;
            n = this.size().height;
        } else {
            n2 = this.prefsize.width;
            n = this.prefsize.height;
        }
        int n3 = n2 < n ? n2 : n;
        return (float)((double)n3 / (1.5 * (double)this.maxwidth));
    }

    public void findCentre() {
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        int n = 0;
        int n2 = 0;
        while (n2 < this.pdb.chains.size()) {
            if (((PDBChain)this.pdb.chains.elementAt((int)n2)).isVisible) {
                Vector vector = ((PDBChain)this.pdb.chains.elementAt((int)n2)).bonds;
                n += vector.size();
                int n3 = 0;
                while (n3 < vector.size()) {
                    f = f + ((Bond)vector.elementAt((int)n3)).start[0] + ((Bond)vector.elementAt((int)n3)).end[0];
                    f2 = f2 + ((Bond)vector.elementAt((int)n3)).start[1] + ((Bond)vector.elementAt((int)n3)).end[1];
                    f3 = f3 + ((Bond)vector.elementAt((int)n3)).start[2] + ((Bond)vector.elementAt((int)n3)).end[2];
                    ++n3;
                }
            }
            ++n2;
        }
        this.centre[0] = f / (2.0f * (float)n);
        this.centre[1] = f2 / (2.0f * (float)n);
        this.centre[2] = f3 / (2.0f * (float)n);
    }

    public void paint(Graphics graphics) {
        if (this.img == null || this.prefsize.width != this.size().width || this.prefsize.height != this.size().height) {
            this.prefsize.width = this.size().width;
            this.prefsize.height = this.size().height;
            this.scale = this.findScale();
            this.img = this.createImage(this.prefsize.width, this.prefsize.height);
            this.ig = this.img.getGraphics();
            this.redrawneeded = true;
        }
        if (this.redrawneeded) {
            this.drawBackground(this.ig, Color.black);
            this.drawScene(this.ig);
            this.redrawneeded = false;
        } else {
            this.ig = this.img.getGraphics();
        }
        graphics.drawImage(this.img, 0, 0, this);
    }

    public void drawBackground(Graphics graphics, Color color) {
        graphics.setColor(color);
        graphics.fillRect(0, 0, this.prefsize.width, this.prefsize.height);
    }

    public void drawScene(Graphics graphics) {
        Vector vector = new Vector();
        int n = 0;
        while (n < this.pdb.chains.size()) {
            if (((PDBChain)this.pdb.chains.elementAt((int)n)).isVisible) {
                Vector vector2 = ((PDBChain)this.pdb.chains.elementAt((int)n)).bonds;
                int n2 = 0;
                while (n2 < vector2.size()) {
                    vector.addElement(vector2.elementAt(n2));
                    ++n2;
                }
            }
            ++n;
        }
        if (this.zbuffer) {
            Zsort.Zsort(vector);
        }
        int n3 = 0;
        while (n3 < vector.size()) {
            Bond bond = (Bond)vector.elementAt(n3);
            this.xstart = (int)((bond.start[0] - this.centre[0]) * this.scale + (float)(this.size().width / 2));
            this.ystart = (int)((bond.start[1] - this.centre[1]) * this.scale + (float)(this.size().height / 2));
            this.xend = (int)((bond.end[0] - this.centre[0]) * this.scale + (float)(this.size().width / 2));
            this.yend = (int)((bond.end[1] - this.centre[1]) * this.scale + (float)(this.size().height / 2));
            this.xmid = (this.xend + this.xstart) / 2;
            this.ymid = (this.yend + this.ystart) / 2;
            if (this.depthcue && !this.bymolecule) {
                if (bond.start[2] < this.centre[2] - this.maxwidth / 6.0f) {
                    graphics.setColor(bond.startCol.darker().darker());
                    this.drawLine(graphics, this.xstart, this.ystart, this.xmid, this.ymid);
                    graphics.setColor(bond.endCol.darker().darker());
                    this.drawLine(graphics, this.xmid, this.ymid, this.xend, this.yend);
                } else if (bond.start[2] < this.centre[2] + this.maxwidth / 6.0f) {
                    graphics.setColor(bond.startCol.darker());
                    this.drawLine(graphics, this.xstart, this.ystart, this.xmid, this.ymid);
                    graphics.setColor(bond.endCol.darker());
                    this.drawLine(graphics, this.xmid, this.ymid, this.xend, this.yend);
                } else {
                    graphics.setColor(bond.startCol);
                    this.drawLine(graphics, this.xstart, this.ystart, this.xmid, this.ymid);
                    graphics.setColor(bond.endCol);
                    this.drawLine(graphics, this.xmid, this.ymid, this.xend, this.yend);
                }
            } else if (this.depthcue && this.bymolecule) {
                if (bond.start[2] < this.centre[2] - this.maxwidth / 6.0f) {
                    graphics.setColor(Color.green.darker().darker());
                    this.drawLine(graphics, this.xstart, this.ystart, this.xend, this.yend);
                } else if (bond.start[2] < this.centre[2] + this.maxwidth / 6.0f) {
                    graphics.setColor(Color.green.darker());
                    this.drawLine(graphics, this.xstart, this.ystart, this.xend, this.yend);
                } else {
                    graphics.setColor(Color.green);
                    this.drawLine(graphics, this.xstart, this.ystart, this.xend, this.yend);
                }
            } else if (!this.depthcue && !this.bymolecule) {
                graphics.setColor(bond.startCol);
                this.drawLine(graphics, this.xstart, this.ystart, this.xmid, this.ymid);
                graphics.setColor(bond.endCol);
                this.drawLine(graphics, this.xmid, this.ymid, this.xend, this.yend);
            } else {
                this.drawLine(graphics, this.xstart, this.ystart, this.xend, this.yend);
            }
            ++n3;
        }
    }

    public void drawLine(Graphics graphics, int n, int n2, int n3, int n4) {
        if (!this.wire) {
            if ((double)((float)Math.abs(n4 - n2) / (float)Math.abs(n3 - n)) < 0.5) {
                graphics.drawLine(n, n2, n3, n4);
                graphics.drawLine(n + 1, n2 + 1, n3 + 1, n4 + 1);
                graphics.drawLine(n, n2 - 1, n3, n4 - 1);
                return;
            }
            graphics.setColor(graphics.getColor().brighter());
            graphics.drawLine(n, n2, n3, n4);
            graphics.drawLine(n + 1, n2, n3 + 1, n4);
            graphics.drawLine(n - 1, n2, n3 - 1, n4);
            return;
        }
        graphics.drawLine(n, n2, n3, n4);
    }

    public Dimension minimumsize() {
        return this.prefsize;
    }

    public Dimension preferredsize() {
        return this.prefsize;
    }

    public boolean keyDown(Event event, int n) {
        if (n == 1004) {
            this.scale = (float)((double)this.scale * 1.1);
            this.redrawneeded = true;
            this.repaint();
        } else if (n == 1005) {
            this.scale = (float)((double)this.scale * 0.9);
            this.redrawneeded = true;
            this.repaint();
        } else if (n == 119) {
            this.wire = !this.wire;
            System.out.println("wireframe " + this.wire);
            this.redrawneeded = true;
            this.repaint();
        } else if (n == 100) {
            this.depthcue = !this.depthcue;
            System.out.println("Depth cueing is " + this.depthcue);
            this.redrawneeded = true;
            this.repaint();
        } else if (n == 109) {
            this.bymolecule = !this.bymolecule;
            System.out.println("Bymolecule is " + this.bymolecule);
            this.redrawneeded = true;
            this.repaint();
        } else if (n == 122) {
            this.zbuffer = !this.zbuffer;
            System.out.println("Z buffering is " + this.zbuffer);
            this.redrawneeded = true;
            this.repaint();
        } else if (n == 99) {
            this.bymolecule = false;
            this.pdb.setChainColours();
            System.out.println("Colouring by chain");
            this.redrawneeded = true;
            this.repaint();
        } else if (n == 104) {
            this.bymolecule = false;
            this.pdb.setHydrophobicityColours();
            System.out.println("Colouring by hydrophobicity");
            this.redrawneeded = true;
            this.repaint();
        } else if (n == 113) {
            this.bymolecule = false;
            this.pdb.setChargeColours();
            System.out.println("Colouring charges and cysteines");
            this.redrawneeded = true;
            this.repaint();
        } else {
            super.keyDown(event, n);
        }
        return true;
    }

    public boolean mouseDrag(Event event, int n, int n2) {
        this.mx = n;
        this.my = n2;
        Matrix matrix = new Matrix(3, 3);
        matrix.setIdentity();
        if ((event.modifiers & 4) != 0) {
            matrix.rotatez(this.mx - this.omx);
        } else {
            matrix.rotatex(this.my - this.omy);
            matrix.rotatey(this.omx - this.mx);
        }
        int n3 = 0;
        while (n3 < this.pdb.chains.size()) {
            Vector vector = ((PDBChain)this.pdb.chains.elementAt((int)n3)).bonds;
            int n4 = 0;
            while (n4 < vector.size()) {
                Bond bond = (Bond)vector.elementAt(n4);
                bond.translate(-this.centre[0], -this.centre[1], -this.centre[2]);
                bond.start = matrix.vectorMultiply(bond.start);
                bond.end = matrix.vectorMultiply(bond.end);
                bond.translate(this.centre[0], this.centre[1], this.centre[2]);
                ++n4;
            }
            ++n3;
        }
        matrix = null;
        this.omx = this.mx;
        this.omy = this.my;
        this.redrawneeded = true;
        this.paint(this.getGraphics());
        this.dragging = true;
        return true;
    }

    public boolean mouseUp(Event event, int n, int n2) {
        if (!this.dragging) {
            this.findAtom(n, n2);
        }
        this.drawLabels();
        return true;
    }

    public void drawLabels() {
        this.redrawneeded = true;
        this.paint(this.getGraphics());
        int n = 0;
        while (n < this.pdb.chains.size()) {
            PDBChain pDBChain = (PDBChain)this.pdb.chains.elementAt(n);
            if (pDBChain.isVisible) {
                Vector vector = ((PDBChain)this.pdb.chains.elementAt((int)n)).bonds;
                int n2 = 0;
                while (n2 < vector.size()) {
                    Bond bond = (Bond)vector.elementAt(n2);
                    if (bond.at1.isSelected) {
                        this.labelAtom(this.img.getGraphics(), bond, 1);
                    }
                    if (bond.at2.isSelected) {
                        this.labelAtom(this.img.getGraphics(), bond, 2);
                    }
                    ++n2;
                }
            }
            ++n;
        }
        this.getGraphics().drawImage(this.img, 0, 0, this);
        this.dragging = false;
    }

    public void labelAtom(Graphics graphics, Bond bond, int n) {
        int n2;
        int n3;
        graphics.setFont(this.font);
        if (n == 1) {
            n3 = (int)((bond.start[0] - this.centre[0]) * this.scale + (float)(this.size().width / 2));
            n2 = (int)((bond.start[1] - this.centre[1]) * this.scale + (float)(this.size().height / 2));
            graphics.setColor(Color.red);
            graphics.drawString(String.valueOf(bond.at1.resName) + "-" + bond.at1.resNumber, n3, n2);
        }
        if (n == 2) {
            n3 = (int)((bond.end[0] - this.centre[0]) * this.scale + (float)(this.size().width / 2));
            n2 = (int)((bond.end[1] - this.centre[1]) * this.scale + (float)(this.size().height / 2));
            graphics.setColor(Color.red);
            graphics.drawString(String.valueOf(bond.at2.resName) + "-" + bond.at2.resNumber, n3, n2);
        }
    }

    public boolean mouseDown(Event event, int n, int n2) {
        this.mx = n;
        this.my = n2;
        this.omx = this.mx;
        this.omy = this.my;
        this.dragging = false;
        return true;
    }

    public myAtom findAtom(int n, int n2) {
        myAtom myAtom2 = null;
        int n3 = -1;
        int n4 = 0;
        while (n4 < this.pdb.chains.size()) {
            int n5;
            PDBChain pDBChain = (PDBChain)this.pdb.chains.elementAt(n4);
            if (pDBChain.isVisible) {
                Vector vector = ((PDBChain)this.pdb.chains.elementAt((int)n4)).bonds;
                n5 = 0;
                while (n5 < vector.size()) {
                    int n6;
                    Bond bond = (Bond)vector.elementAt(n5);
                    int n7 = (int)((bond.start[0] - this.centre[0]) * this.scale + (float)(this.size().width / 2));
                    if (Math.abs(n7 - n) <= 2 && Math.abs((n6 = (int)((bond.start[1] - this.centre[1]) * this.scale + (float)(this.size().height / 2))) - n2) <= 2) {
                        System.out.println("Found match");
                        System.out.println(String.valueOf(n) + " " + n2);
                        System.out.println(String.valueOf(n7) + " " + n6);
                        System.out.println(String.valueOf(bond.start[0]) + " " + bond.start[1]);
                        System.out.println("Atom 1 = " + bond.at1.resName + " " + bond.at1.resNumber + " " + bond.at1.chain);
                        myAtom2 = bond.at1;
                        myAtom2.isSelected = !myAtom2.isSelected;
                        n3 = n4;
                    }
                    ++n5;
                }
            }
            if (myAtom2 != null && pDBChain.ds != null) {
                pDBChain = (PDBChain)this.pdb.chains.elementAt(n3);
                int n8 = pDBChain.ds.seqstart + myAtom2.resNumber - pDBChain.offset;
                n5 = pDBChain.ds.findIndex(n8);
                System.out.println("Found seq " + pDBChain.ds.name + " " + n8 + " " + n5);
            }
            ++n4;
        }
        return null;
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }
}

