/*
 * Decompiled with CFR 0.152.
 */
package org.linkedin.zookeeper.tracker;

import java.io.File;
import org.linkedin.util.annotations.Initializer;
import org.linkedin.zookeeper.tracker.NodeEventType;
import org.linkedin.zookeeper.tracker.TrackedNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeEvent<T> {
    private NodeEventType _eventType;
    private TrackedNode<T> _node;

    public NodeEvent() {
    }

    public NodeEvent(NodeEventType eventType, TrackedNode<T> node) {
        this._eventType = eventType;
        this._node = node;
    }

    public NodeEventType getEventType() {
        return this._eventType;
    }

    @Initializer(required=true)
    public void setEventType(NodeEventType eventType) {
        this._eventType = eventType;
    }

    public TrackedNode<T> getNode() {
        return this._node;
    }

    @Initializer(required=true)
    public void setNode(TrackedNode<T> node) {
        this._node = node;
    }

    public T getData() {
        return this._node.getData();
    }

    public String getPath() {
        return this._node.getPath();
    }

    public String getParentName() {
        return new File(this.getPath()).getParentFile().getName();
    }

    public String getName() {
        return new File(this.getPath()).getName();
    }

    public int getDepth() {
        return this._node.getDepth();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("NodeEvent ").append(this.getNode()).append(": ");
        sb.append((Object)this.getEventType());
        return sb.toString();
    }
}

