/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import java.util.concurrent.TimeUnit;
import org.apache.camel.Consumer;
import org.apache.camel.Exchange;
import org.apache.camel.Route;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.spi.RoutePolicy;
import org.apache.camel.support.LoggingExceptionHandler;
import org.apache.camel.support.ServiceSupport;
import org.apache.camel.util.ServiceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RoutePolicySupport
extends ServiceSupport
implements RoutePolicy {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private ExceptionHandler exceptionHandler;

    @Override
    public void onInit(Route route) {
        if (this.exceptionHandler == null) {
            this.exceptionHandler = new LoggingExceptionHandler(route.getRouteContext().getCamelContext(), this.getClass());
        }
    }

    @Override
    public void onRemove(Route route) {
    }

    @Override
    public void onStart(Route route) {
    }

    @Override
    public void onStop(Route route) {
    }

    @Override
    public void onSuspend(Route route) {
    }

    @Override
    public void onResume(Route route) {
    }

    @Override
    public void onExchangeBegin(Route route, Exchange exchange) {
    }

    @Override
    public void onExchangeDone(Route route, Exchange exchange) {
    }

    public boolean startConsumer(Consumer consumer) throws Exception {
        boolean resumed = ServiceHelper.resumeService(consumer);
        if (resumed) {
            this.log.debug("Resuming consumer {}", (Object)consumer);
        }
        return resumed;
    }

    public boolean stopConsumer(Consumer consumer) throws Exception {
        boolean suspended = ServiceHelper.suspendService(consumer);
        if (suspended) {
            this.log.debug("Suspended consumer {}", (Object)consumer);
        }
        return suspended;
    }

    public void startRoute(Route route) throws Exception {
        route.getRouteContext().getCamelContext().startRoute(route.getId());
    }

    public void resumeRoute(Route route) throws Exception {
        route.getRouteContext().getCamelContext().resumeRoute(route.getId());
    }

    public void suspendRoute(Route route) throws Exception {
        route.getRouteContext().getCamelContext().suspendRoute(route.getId());
    }

    public void suspendRoute(Route route, long timeout, TimeUnit timeUnit) throws Exception {
        route.getRouteContext().getCamelContext().suspendRoute(route.getId(), timeout, timeUnit);
    }

    public void stopRoute(Route route) throws Exception {
        route.getRouteContext().getCamelContext().stopRoute(route.getId());
    }

    public void stopRoute(Route route, long timeout, TimeUnit timeUnit) throws Exception {
        route.getRouteContext().getCamelContext().stopRoute(route.getId(), timeout, timeUnit);
    }

    protected void handleException(Throwable t) {
        if (this.exceptionHandler != null) {
            this.exceptionHandler.handleException(t);
        }
    }

    @Override
    protected void doStart() throws Exception {
    }

    @Override
    protected void doStop() throws Exception {
    }

    public ExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    public void setExceptionHandler(ExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }
}

