/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.d2j.dex.writer.item;

import com.googlecode.d2j.dex.writer.io.DataOut;

public abstract class BaseItem {
    public static final int NO_INDEX = -1;
    public int index;
    public int offset;

    protected static void addPadding(DataOut out, int alignment) {
        int x = out.offset() % alignment;
        if (x != 0) {
            out.skip("padding", alignment - x);
        }
    }

    public static void addPadding(DataOut out, int offset, int alignment) {
        int x = offset % alignment;
        if (x != 0) {
            out.skip("padding", alignment - x);
        }
    }

    public static int padding(int offset, int alignment) {
        int x = offset % alignment;
        if (x != 0) {
            offset += alignment - x;
        }
        return offset;
    }

    public static int lengthOfSleb128(int value) {
        int remaining = value >> 7;
        boolean hasMore = true;
        int end = (value & Integer.MIN_VALUE) == 0 ? 0 : -1;
        int count = 0;
        while (hasMore) {
            hasMore = remaining != end || (remaining & 1) != (value >> 6 & 1);
            ++count;
            value = remaining;
            remaining >>= 7;
        }
        return count;
    }

    public static int lengthOfUleb128(int s) {
        int length = 1;
        if (s > 127) {
            ++length;
            if (s > 16383) {
                ++length;
                if (s > 0x1FFFFF) {
                    ++length;
                    if (s > 0xFFFFFFF) {
                        ++length;
                    }
                }
            }
        }
        return length;
    }

    public abstract void write(DataOut var1);

    public abstract int place(int var1);
}

