/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Long
extends Number
implements Comparable<Long> {
    private static final long serialVersionUID = 4290774380558885855L;
    public static final long MIN_VALUE = -9223372036854775808L;
    public static final long MAX_VALUE = 0x7FFFFFFFFFFFFFFFL;
    public static final Class<Long> TYPE = VMClassLoader.getPrimitiveClass('J');
    public static final int SIZE = 64;
    private static final int MIN_CACHE = -128;
    private static final int MAX_CACHE = 127;
    private static final Long[] longCache = new Long[256];
    private final long value;

    static {
        int i = -128;
        while (i <= 127) {
            Long.longCache[i - -128] = new Long(i);
            ++i;
        }
    }

    public Long(long value) {
        this.value = value;
    }

    public Long(String s) {
        this.value = Long.parseLong(s, 10, false);
    }

    private static int stringSize(long num, int radix) {
        int exp = radix < 4 ? 1 : (radix < 8 ? 2 : (radix < 16 ? 3 : (radix < 32 ? 4 : 5)));
        int size = 0;
        do {
            ++size;
        } while ((num >>>= exp) != 0L);
        return size;
    }

    public static String toString(long num, int radix) {
        char[] buffer;
        int i;
        int size;
        boolean isNeg;
        if (radix < 2 || radix > 36) {
            radix = 10;
        }
        boolean bl = isNeg = num < 0L;
        if (!isNeg && num < (long)radix) {
            return new String(digits, (int)num, 1, true);
        }
        if (isNeg) {
            if ((num = -num) < 0L) {
                i = size = Long.stringSize(Long.MAX_VALUE, radix) + 2;
                buffer = new char[size];
                buffer[--i] = digits[(int)(-(num + (long)radix) % (long)radix)];
                num = -(num / (long)radix);
            } else {
                i = size = Long.stringSize(num, radix) + 1;
                buffer = new char[size];
            }
        } else {
            i = size = Long.stringSize(num, radix);
            buffer = new char[size];
        }
        do {
            buffer[--i] = digits[(int)(num % (long)radix)];
        } while ((num /= (long)radix) > 0L);
        if (isNeg) {
            buffer[--i] = 45;
        }
        return new String(buffer, i, size - i, true);
    }

    public static String toHexString(long l) {
        return Long.toUnsignedString(l, 4);
    }

    public static String toOctalString(long l) {
        return Long.toUnsignedString(l, 3);
    }

    public static String toBinaryString(long l) {
        return Long.toUnsignedString(l, 1);
    }

    public static String toString(long num) {
        return Long.toString(num, 10);
    }

    public static long parseLong(String str, int radix) {
        return Long.parseLong(str, radix, false);
    }

    public static long parseLong(String s) {
        return Long.parseLong(s, 10, false);
    }

    public static Long valueOf(String s, int radix) {
        return Long.parseLong(s, radix, false);
    }

    public static Long valueOf(String s) {
        return Long.parseLong(s, 10, false);
    }

    public static Long valueOf(long val) {
        if (val < -128L || val > 127L) {
            return new Long(val);
        }
        return longCache[(int)val - -128];
    }

    public static Long decode(String str) {
        return Long.parseLong(str, 10, true);
    }

    @Override
    public byte byteValue() {
        return (byte)this.value;
    }

    @Override
    public short shortValue() {
        return (short)this.value;
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    public String toString() {
        return Long.toString(this.value, 10);
    }

    public int hashCode() {
        return (int)(this.value ^ this.value >>> 32);
    }

    public boolean equals(Object obj) {
        return obj instanceof Long && this.value == ((Long)obj).value;
    }

    public static Long getLong(String nm) {
        return Long.getLong(nm, null);
    }

    public static Long getLong(String nm, long val) {
        Long result = Long.getLong(nm, null);
        return result == null ? Long.valueOf(val) : result;
    }

    public static Long getLong(String nm, Long def) {
        if (nm == null || "".equals(nm)) {
            return def;
        }
        if ((nm = System.getProperty(nm)) == null) {
            return def;
        }
        try {
            return Long.decode(nm);
        }
        catch (NumberFormatException numberFormatException) {
            return def;
        }
    }

    @Override
    public int compareTo(Long l) {
        if (this.value == l.value) {
            return 0;
        }
        return this.value > l.value ? 1 : -1;
    }

    public static int compare(long x, long y) {
        return Long.valueOf(x).compareTo(y);
    }

    public static int bitCount(long x) {
        x = (x >> 1 & 0x5555555555555555L) + (x & 0x5555555555555555L);
        x = (x >> 2 & 0x3333333333333333L) + (x & 0x3333333333333333L);
        int v = (int)((x >>> 32) + x);
        v = (v >> 4 & 0xF0F0F0F) + (v & 0xF0F0F0F);
        v = (v >> 8 & 0xFF00FF) + (v & 0xFF00FF);
        return (v >> 16 & 0xFFFF) + (v & 0xFFFF);
    }

    public static long rotateLeft(long x, int distance) {
        return x << distance | x >>> -distance;
    }

    public static long rotateRight(long x, int distance) {
        return x << -distance | x >>> distance;
    }

    public static long highestOneBit(long value) {
        value |= value >>> 1;
        value |= value >>> 2;
        value |= value >>> 4;
        value |= value >>> 8;
        value |= value >>> 16;
        value |= value >>> 32;
        return value ^ value >>> 1;
    }

    public static int numberOfLeadingZeros(long value) {
        value |= value >>> 1;
        value |= value >>> 2;
        value |= value >>> 4;
        value |= value >>> 8;
        value |= value >>> 16;
        value |= value >>> 32;
        return Long.bitCount(value ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public static long lowestOneBit(long value) {
        return value & -value;
    }

    public static int numberOfTrailingZeros(long value) {
        return Long.bitCount((value & -value) - 1L);
    }

    public static int signum(long x) {
        return (int)(x >> 63 | -x >>> 63);
    }

    public static long reverseBytes(long val) {
        int hi = Integer.reverseBytes((int)val);
        int lo = Integer.reverseBytes((int)(val >>> 32));
        return (long)hi << 32 | (long)lo;
    }

    public static long reverse(long val) {
        long hi = (long)Integer.reverse((int)val) & 0xFFFFFFFFL;
        long lo = (long)Integer.reverse((int)(val >>> 32)) & 0xFFFFFFFFL;
        return hi << 32 | lo;
    }

    private static String toUnsignedString(long num, int exp) {
        int size = 1;
        long copy = num >>> exp;
        while (copy != 0L) {
            ++size;
            copy >>>= exp;
        }
        if (size == 1) {
            return new String(digits, (int)num, 1, true);
        }
        int mask = (1 << exp) - 1;
        char[] buffer = new char[size];
        int i = size;
        do {
            buffer[--i] = digits[(int)num & mask];
        } while ((num >>>= exp) != 0L);
        return new String(buffer, i, size - i, true);
    }

    private static long parseLong(String str, int radix, boolean decode) {
        if (!decode && str == null) {
            throw new NumberFormatException();
        }
        int index = 0;
        int len = str.length();
        boolean isNeg = false;
        if (len == 0) {
            throw new NumberFormatException();
        }
        int ch = str.charAt(index);
        if (ch == 45) {
            if (len == 1) {
                throw new NumberFormatException();
            }
            isNeg = true;
            ch = str.charAt(++index);
        }
        if (decode) {
            if (ch == 48) {
                if (++index == len) {
                    return 0L;
                }
                if ((str.charAt(index) & 0xFFFFFFDF) == 88) {
                    radix = 16;
                    ++index;
                } else {
                    radix = 8;
                }
            } else if (ch == 35) {
                radix = 16;
                ++index;
            }
        }
        if (index == len) {
            throw new NumberFormatException();
        }
        long max = Long.MAX_VALUE / (long)radix;
        if (isNeg && Long.MAX_VALUE % (long)radix == (long)(radix - 1)) {
            ++max;
        }
        long val = 0L;
        while (index < len) {
            if (val < 0L || val > max) {
                throw new NumberFormatException();
            }
            ch = Character.digit(str.charAt(index++), radix);
            val = val * (long)radix + (long)ch;
            if (ch >= 0 && (val >= 0L || isNeg && val == Long.MIN_VALUE)) continue;
            throw new NumberFormatException();
        }
        return isNeg ? -val : val;
    }
}

