/*
 * Decompiled with CFR 0.152.
 */
package javax.sound.sampled;

import gnu.java.lang.CPStringBuilder;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AudioFormat {
    protected boolean bigEndian;
    protected int channels;
    protected Encoding encoding;
    protected float frameRate;
    protected int frameSize;
    protected float sampleRate;
    protected int sampleSizeInBits;
    private Map<String, Object> properties;

    public AudioFormat(Encoding encoding, float sampleRate, int sampleSizeInBits, int channels, int frameSize, float frameRate, boolean bigEndian) {
        this.encoding = encoding;
        this.sampleRate = sampleRate;
        this.sampleSizeInBits = sampleSizeInBits;
        this.channels = channels;
        this.frameSize = frameSize;
        this.frameRate = frameRate;
        this.bigEndian = bigEndian;
        this.properties = Collections.emptyMap();
    }

    public AudioFormat(Encoding encoding, float sampleRate, int sampleSizeInBits, int channels, int frameSize, float frameRate, boolean bigEndian, Map<String, Object> properties) {
        this.encoding = encoding;
        this.sampleRate = sampleRate;
        this.sampleSizeInBits = sampleSizeInBits;
        this.channels = channels;
        this.frameSize = frameSize;
        this.frameRate = frameRate;
        this.bigEndian = bigEndian;
        this.properties = Collections.unmodifiableMap(new HashMap<String, Object>(properties));
    }

    public AudioFormat(float sampleRate, int sampleSizeInBits, int channels, boolean signed, boolean bigEndian) {
        this.encoding = signed ? Encoding.PCM_SIGNED : Encoding.PCM_UNSIGNED;
        this.sampleRate = sampleRate;
        this.sampleSizeInBits = sampleSizeInBits;
        this.channels = channels;
        this.frameSize = sampleSizeInBits == -1 || channels == -1 ? -1 : (sampleSizeInBits + 7) / 8 * channels;
        this.frameRate = sampleRate;
        this.bigEndian = bigEndian;
        this.properties = Collections.emptyMap();
    }

    public int getChannels() {
        return this.channels;
    }

    public Encoding getEncoding() {
        return this.encoding;
    }

    public float getFrameRate() {
        return this.frameRate;
    }

    public int getFrameSize() {
        return this.frameSize;
    }

    public Object getProperty(String key) {
        return this.properties.get(key);
    }

    public float getSampleRate() {
        return this.sampleRate;
    }

    public int getSampleSizeInBits() {
        return this.sampleSizeInBits;
    }

    public boolean isBigEndian() {
        return this.bigEndian;
    }

    public boolean matches(AudioFormat fmt) {
        if (!this.encoding.equals(fmt.encoding) || this.channels != fmt.channels || this.sampleSizeInBits != fmt.sampleSizeInBits || this.frameSize != fmt.frameSize) {
            return false;
        }
        if (this.sampleRate != -1.0f && fmt.sampleRate != -1.0f && this.sampleRate != fmt.sampleRate) {
            return false;
        }
        if (this.frameRate != -1.0f && fmt.frameRate != -1.0f && this.frameRate != fmt.frameRate) {
            return false;
        }
        if (this.sampleSizeInBits > 8) {
            return this.bigEndian == fmt.bigEndian;
        }
        return true;
    }

    public Map<String, Object> properties() {
        return this.properties;
    }

    public String toString() {
        CPStringBuilder result = new CPStringBuilder();
        result.append(this.encoding);
        if (this.sampleRate != -1.0f) {
            result.append(" ");
            result.append(this.sampleRate);
            result.append(" Hz");
        }
        if (this.sampleSizeInBits != -1) {
            result.append(" ");
            result.append(this.sampleSizeInBits);
            result.append(" bits");
        }
        if (this.channels != -1) {
            result.append(" ");
            result.append(this.channels);
            result.append(" channel");
            if (this.channels > 1) {
                result.append("s");
            }
        }
        if (this.sampleSizeInBits > 8) {
            result.append(this.bigEndian ? " big endian" : " little endian");
        }
        return result.toString();
    }

    public static class Encoding {
        public static final Encoding ALAW = new Encoding("alaw");
        public static final Encoding PCM_SIGNED = new Encoding("pcm_signed");
        public static final Encoding PCM_UNSIGNED = new Encoding("pcm_unsigned");
        public static final Encoding ULAW = new Encoding("ulaw");
        private String name;

        public Encoding(String name) {
            this.name = name;
        }

        public final boolean equals(Object o) {
            return super.equals(o);
        }

        public final int hashCode() {
            return super.hashCode();
        }

        public final String toString() {
            return this.name;
        }
    }
}

