/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.util.Arrays;

public class SizeSequence {
    private int[] sizes;

    public SizeSequence() {
        this.sizes = new int[0];
    }

    public SizeSequence(int numEntries) {
        this(numEntries, 0);
    }

    public SizeSequence(int numEntries, int value) {
        this.sizes = new int[numEntries];
        Arrays.fill(this.sizes, value);
    }

    public SizeSequence(int[] sizes) {
        this.sizes = (int[])sizes.clone();
    }

    public void setSize(int index, int size) {
        if (index >= 0 && index < this.sizes.length) {
            this.sizes[index] = size;
        }
    }

    public int getIndex(int position) {
        int i = 0;
        int runningTotal = 0;
        while (i < this.sizes.length && position >= runningTotal + this.sizes[i]) {
            runningTotal += this.sizes[i];
            ++i;
        }
        return i;
    }

    public int getSize(int index) {
        if (index < 0 || index >= this.sizes.length) {
            return 0;
        }
        return this.sizes[index];
    }

    public void setSizes(int[] sizes) {
        this.sizes = (int[])sizes.clone();
    }

    public int[] getSizes() {
        return (int[])this.sizes.clone();
    }

    public int getPosition(int index) {
        int position = 0;
        int loop = 0;
        while (loop < index) {
            position += this.sizes[loop];
            ++loop;
        }
        return position;
    }

    public void insertEntries(int start, int length, int value) {
        int[] newSizes = new int[this.sizes.length + length];
        System.arraycopy(this.sizes, 0, newSizes, 0, start);
        int i = start;
        while (i < start + length) {
            newSizes[i] = value;
            ++i;
        }
        System.arraycopy(this.sizes, start, newSizes, start + length, this.sizes.length - start);
        this.sizes = newSizes;
    }

    public void removeEntries(int start, int length) {
        if (start + length > this.sizes.length) {
            throw new IllegalArgumentException("Specified start/length that is greater than available sizes");
        }
        int[] newSizes = new int[this.sizes.length - length];
        System.arraycopy(this.sizes, 0, newSizes, 0, start);
        System.arraycopy(this.sizes, start + length, newSizes, start, this.sizes.length - start - length);
        this.sizes = newSizes;
    }
}

