/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.table;

import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import javax.swing.event.SwingPropertyChangeSupport;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class TableColumn
implements Serializable {
    static final long serialVersionUID = -6113660025878112608L;
    public static final String COLUMN_WIDTH_PROPERTY = "columWidth";
    public static final String HEADER_VALUE_PROPERTY = "headerValue";
    public static final String HEADER_RENDERER_PROPERTY = "headerRenderer";
    public static final String CELL_RENDERER_PROPERTY = "cellRenderer";
    protected int modelIndex;
    protected Object identifier;
    protected int width;
    protected int minWidth = 15;
    private int preferredWidth;
    protected int maxWidth = Integer.MAX_VALUE;
    protected TableCellRenderer headerRenderer;
    protected Object headerValue;
    protected TableCellRenderer cellRenderer;
    protected TableCellEditor cellEditor;
    protected boolean isResizable = true;
    protected transient int resizedPostingDisableCount;
    private SwingPropertyChangeSupport changeSupport = new SwingPropertyChangeSupport(this);

    public TableColumn() {
        this(0, 75, null, null);
    }

    public TableColumn(int modelIndex) {
        this(modelIndex, 75, null, null);
    }

    public TableColumn(int modelIndex, int width) {
        this(modelIndex, width, null, null);
    }

    public TableColumn(int modelIndex, int width, TableCellRenderer cellRenderer, TableCellEditor cellEditor) {
        this.modelIndex = modelIndex;
        this.width = width;
        this.preferredWidth = width;
        this.cellRenderer = cellRenderer;
        this.cellEditor = cellEditor;
        this.headerValue = null;
        this.identifier = null;
    }

    public void setModelIndex(int modelIndex) {
        if (this.modelIndex != modelIndex) {
            int oldValue = this.modelIndex;
            this.modelIndex = modelIndex;
            this.changeSupport.firePropertyChange("modelIndex", oldValue, modelIndex);
        }
    }

    public int getModelIndex() {
        return this.modelIndex;
    }

    public void setIdentifier(Object identifier) {
        if (this.identifier != identifier) {
            Object oldValue = this.identifier;
            this.identifier = identifier;
            this.changeSupport.firePropertyChange("identifier", oldValue, identifier);
        }
    }

    public Object getIdentifier() {
        if (this.identifier == null) {
            return this.getHeaderValue();
        }
        return this.identifier;
    }

    public void setHeaderValue(Object headerValue) {
        if (this.headerValue == headerValue) {
            return;
        }
        Object oldValue = this.headerValue;
        this.headerValue = headerValue;
        this.changeSupport.firePropertyChange(HEADER_VALUE_PROPERTY, oldValue, headerValue);
    }

    public Object getHeaderValue() {
        return this.headerValue;
    }

    public void setHeaderRenderer(TableCellRenderer renderer) {
        if (this.headerRenderer == renderer) {
            return;
        }
        TableCellRenderer oldRenderer = this.headerRenderer;
        this.headerRenderer = renderer;
        this.changeSupport.firePropertyChange(HEADER_RENDERER_PROPERTY, oldRenderer, this.headerRenderer);
    }

    public TableCellRenderer getHeaderRenderer() {
        return this.headerRenderer;
    }

    public void setCellRenderer(TableCellRenderer renderer) {
        if (this.cellRenderer == renderer) {
            return;
        }
        TableCellRenderer oldRenderer = this.cellRenderer;
        this.cellRenderer = renderer;
        this.changeSupport.firePropertyChange(CELL_RENDERER_PROPERTY, oldRenderer, this.cellRenderer);
    }

    public TableCellRenderer getCellRenderer() {
        return this.cellRenderer;
    }

    public void setCellEditor(TableCellEditor cellEditor) {
        if (this.cellEditor != cellEditor) {
            TableCellEditor oldValue = this.cellEditor;
            this.cellEditor = cellEditor;
            this.changeSupport.firePropertyChange("cellEditor", oldValue, cellEditor);
        }
    }

    public TableCellEditor getCellEditor() {
        return this.cellEditor;
    }

    public void setWidth(int newWidth) {
        int oldWidth = this.width;
        this.width = newWidth < this.minWidth ? this.minWidth : (newWidth > this.maxWidth ? this.maxWidth : newWidth);
        if (this.width == oldWidth) {
            return;
        }
        this.changeSupport.firePropertyChange("width", oldWidth, this.width);
    }

    public int getWidth() {
        return this.width;
    }

    public void setPreferredWidth(int preferredWidth) {
        int oldPrefWidth = this.preferredWidth;
        this.preferredWidth = preferredWidth < this.minWidth ? this.minWidth : (preferredWidth > this.maxWidth ? this.maxWidth : preferredWidth);
        this.changeSupport.firePropertyChange("preferredWidth", oldPrefWidth, this.preferredWidth);
    }

    public int getPreferredWidth() {
        return this.preferredWidth;
    }

    public void setMinWidth(int minWidth) {
        if (minWidth < 0) {
            minWidth = 0;
        }
        if (this.minWidth != minWidth) {
            if (this.width < minWidth) {
                this.setWidth(minWidth);
            }
            if (this.preferredWidth < minWidth) {
                this.setPreferredWidth(minWidth);
            }
            int oldValue = this.minWidth;
            this.minWidth = minWidth;
            this.changeSupport.firePropertyChange("minWidth", oldValue, minWidth);
        }
    }

    public int getMinWidth() {
        return this.minWidth;
    }

    public void setMaxWidth(int maxWidth) {
        if (this.maxWidth != maxWidth) {
            if (this.width > maxWidth) {
                this.setWidth(maxWidth);
            }
            if (this.preferredWidth > maxWidth) {
                this.setPreferredWidth(maxWidth);
            }
            int oldValue = this.maxWidth;
            this.maxWidth = maxWidth;
            this.changeSupport.firePropertyChange("maxWidth", oldValue, maxWidth);
        }
    }

    public int getMaxWidth() {
        return this.maxWidth;
    }

    public void setResizable(boolean isResizable) {
        if (this.isResizable != isResizable) {
            this.isResizable = isResizable;
            this.changeSupport.firePropertyChange("isResizable", !this.isResizable, isResizable);
        }
    }

    public boolean getResizable() {
        return this.isResizable;
    }

    public void sizeWidthToFit() {
        if (this.headerRenderer == null) {
            return;
        }
        Component c = this.headerRenderer.getTableCellRendererComponent(null, this.getHeaderValue(), false, false, 0, 0);
        Dimension min = c.getMinimumSize();
        Dimension max = c.getMaximumSize();
        Dimension pref = c.getPreferredSize();
        this.setMinWidth(min.width);
        this.setMaxWidth(max.width);
        this.setPreferredWidth(pref.width);
        this.setWidth(pref.width);
    }

    public void disableResizedPosting() {
    }

    public void enableResizedPosting() {
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(listener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.removePropertyChangeListener(listener);
    }

    public PropertyChangeListener[] getPropertyChangeListeners() {
        return this.changeSupport.getPropertyChangeListeners();
    }

    protected TableCellRenderer createDefaultHeaderRenderer() {
        return new DefaultTableCellRenderer();
    }
}

