/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text.html;

import gnu.javax.swing.text.html.ImageViewIconFactory;
import gnu.javax.swing.text.html.css.Length;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.image.ImageObserver;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.View;
import javax.swing.text.html.CSS;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.StyleSheet;

public class ImageView
extends View {
    boolean loadOnDemand = false;
    Image image;
    byte imageState = 1;
    private boolean reloadImage = true;
    private boolean reloadProperties = true;
    private boolean haveWidth;
    private boolean haveHeight;
    private boolean loading;
    private int width;
    private int height;
    private ImageObserver observer;
    Length[] spans = new Length[2];
    private AttributeSet attributes;

    public ImageView(Element element) {
        super(element);
        this.observer = new Observer();
    }

    private void reloadImage() {
        this.loading = true;
        this.reloadImage = false;
        this.haveWidth = false;
        this.haveHeight = false;
        this.image = null;
        this.width = 0;
        this.height = 0;
        try {
            this.loadImage();
            this.updateSize();
        }
        finally {
            this.loading = false;
        }
    }

    public float getAlignment(int axis) {
        AttributeSet attrs = this.getAttributes();
        Object al = attrs.getAttribute(HTML.Attribute.ALIGN);
        if (al == null) {
            return 0.0f;
        }
        String align = al.toString();
        if (axis == 0) {
            if (align.equals("middle")) {
                return 0.5f;
            }
            if (align.equals("left")) {
                return 0.0f;
            }
            if (align.equals("right")) {
                return 1.0f;
            }
            return 0.0f;
        }
        if (axis == 1) {
            if (align.equals("middle")) {
                return 0.5f;
            }
            if (align.equals("top")) {
                return 0.0f;
            }
            if (align.equals("bottom")) {
                return 1.0f;
            }
            return 0.0f;
        }
        throw new IllegalArgumentException("axis " + axis);
    }

    public String getAltText() {
        Object rt = this.getAttributes().getAttribute(HTML.Attribute.ALT);
        if (rt != null) {
            return rt.toString();
        }
        URL u = this.getImageURL();
        if (u == null) {
            return "";
        }
        return u.getFile();
    }

    public AttributeSet getAttributes() {
        if (this.attributes == null) {
            this.attributes = this.getStyleSheet().getViewAttributes(this);
        }
        return this.attributes;
    }

    public Image getImage() {
        this.updateState();
        return this.image;
    }

    public URL getImageURL() {
        Element el = this.getElement();
        String src = (String)el.getAttributes().getAttribute(HTML.Attribute.SRC);
        URL url = null;
        if (src != null) {
            URL base = ((HTMLDocument)this.getDocument()).getBase();
            try {
                url = new URL(base, src);
            }
            catch (MalformedURLException malformedURLException) {}
        }
        return url;
    }

    public Icon getLoadingImageIcon() {
        return ImageViewIconFactory.getLoadingImageIcon();
    }

    public boolean getLoadsSynchronously() {
        return this.loadOnDemand;
    }

    public Icon getNoImageIcon() {
        return ImageViewIconFactory.getNoImageIcon();
    }

    public float getPreferredSpan(int axis) {
        Image image = this.getImage();
        if (axis == 0) {
            if (this.spans[axis] != null) {
                return this.spans[axis].getValue();
            }
            if (image != null) {
                return image.getWidth(this.getContainer());
            }
            return this.getNoImageIcon().getIconWidth();
        }
        if (axis == 1) {
            if (this.spans[axis] != null) {
                return this.spans[axis].getValue();
            }
            if (image != null) {
                return image.getHeight(this.getContainer());
            }
            return this.getNoImageIcon().getIconHeight();
        }
        throw new IllegalArgumentException("axis " + axis);
    }

    protected StyleSheet getStyleSheet() {
        HTMLDocument doc = (HTMLDocument)this.getDocument();
        return doc.getStyleSheet();
    }

    public String getToolTipText(float x, float y, Shape shape) {
        return this.getAltText();
    }

    public void paint(Graphics g, Shape bounds) {
        this.updateState();
        Rectangle r = bounds instanceof Rectangle ? (Rectangle)bounds : bounds.getBounds();
        Image image = this.getImage();
        if (image != null) {
            g.drawImage(image, r.x, r.y, r.width, r.height, this.observer);
        } else {
            Icon icon = this.getNoImageIcon();
            if (icon != null) {
                icon.paintIcon(this.getContainer(), g, r.x, r.y);
            }
        }
    }

    public void setLoadsSynchronously(boolean load_on_demand) {
        this.loadOnDemand = load_on_demand;
    }

    protected void setPropertiesFromAttributes() {
        AttributeSet atts = this.getAttributes();
        StyleSheet ss = this.getStyleSheet();
        float emBase = ss.getEMBase(atts);
        float exBase = ss.getEXBase(atts);
        this.spans[0] = (Length)atts.getAttribute(CSS.Attribute.WIDTH);
        if (this.spans[0] != null) {
            this.spans[0].setFontBases(emBase, exBase);
        }
        this.spans[1] = (Length)atts.getAttribute(CSS.Attribute.HEIGHT);
        if (this.spans[1] != null) {
            this.spans[1].setFontBases(emBase, exBase);
        }
    }

    public int viewToModel(float x, float y, Shape shape, Position.Bias[] bias) {
        return this.getStartOffset();
    }

    public Shape modelToView(int pos, Shape area, Position.Bias bias) throws BadLocationException {
        return area;
    }

    public void setSize(float width, float height) {
        this.updateState();
    }

    private void updateState() {
        if (this.reloadImage) {
            this.reloadImage();
        }
        if (this.reloadProperties) {
            this.setPropertiesFromAttributes();
        }
    }

    private void loadImage() {
        URL src = this.getImageURL();
        Image newImage = null;
        if (src != null) {
            Toolkit tk = Toolkit.getDefaultToolkit();
            newImage = tk.getImage(src);
            tk.prepareImage(newImage, -1, -1, this.observer);
            if (newImage != null && this.getLoadsSynchronously()) {
                MediaTracker tracker = new MediaTracker(this.getContainer());
                tracker.addImage(newImage, 0);
                try {
                    tracker.waitForID(0);
                }
                catch (InterruptedException interruptedException) {
                    Thread.interrupted();
                }
            }
        }
        this.image = newImage;
    }

    private void updateSize() {
        Image newIm = this.getImage();
        if (newIm != null) {
            Length l = this.spans[0];
            if (l != null) {
                int cfr_ignored_0 = (int)l.getValue();
                this.haveWidth = true;
            } else {
                newIm.getWidth(this.observer);
            }
            l = this.spans[1];
            if (l != null) {
                int cfr_ignored_1 = (int)l.getValue();
                this.haveHeight = true;
            } else {
                newIm.getWidth(this.observer);
            }
            Toolkit tk = Toolkit.getDefaultToolkit();
            if (this.haveWidth || this.haveHeight) {
                tk.prepareImage(newIm, this.width, this.height, this.observer);
            } else {
                tk.prepareImage(newIm, -1, -1, this.observer);
            }
        }
    }

    void safePreferenceChanged(final View v, final boolean width, final boolean height) {
        if (SwingUtilities.isEventDispatchThread()) {
            Document doc = this.getDocument();
            if (doc instanceof AbstractDocument) {
                ((AbstractDocument)doc).readLock();
            }
            try {
                this.preferenceChanged(v, width, height);
            }
            finally {
                if (doc instanceof AbstractDocument) {
                    ((AbstractDocument)doc).readUnlock();
                }
            }
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ImageView.this.safePreferenceChanged(v, width, height);
                }
            });
        }
    }

    class Observer
    implements ImageObserver {
        Observer() {
        }

        public boolean imageUpdate(Image image, int flags, int x, int y, int width, int height) {
            boolean widthChanged = false;
            if ((flags & 1) != 0 && ImageView.this.spans[0] == null) {
                widthChanged = true;
            }
            boolean heightChanged = false;
            if ((flags & 2) != 0 && ImageView.this.spans[1] == null) {
                heightChanged = true;
            }
            if (widthChanged || heightChanged) {
                ImageView.this.safePreferenceChanged(ImageView.this, widthChanged, heightChanged);
            }
            boolean ret = (flags & 0x20) != 0;
            return ret;
        }
    }
}

