/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.ant;

import com.intellij.compiler.CompilerConfiguration;
import com.intellij.compiler.CompilerEncodingService;
import com.intellij.compiler.ant.ChunkCustomCompilerExtension;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.EffectiveLanguageLevelUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.util.ArrayUtil;
import com.intellij.util.lang.JavaVersion;
import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JpsJavaSdkType;

public class ModuleChunk {
    private final Module[] myModules;
    private final ChunkCustomCompilerExtension[] myCustomCompilers;
    private Module myMainModule;
    private ModuleChunk[] myDependentChunks;
    private File myBaseDir = null;

    public ModuleChunk(Module[] modules) {
        this.myModules = modules;
        Arrays.sort(this.myModules, (o1, o2) -> o1.getName().compareToIgnoreCase(o2.getName()));
        this.myMainModule = this.myModules[0];
        this.myCustomCompilers = ChunkCustomCompilerExtension.getCustomCompile(this);
    }

    public String getName() {
        return this.myMainModule.getName();
    }

    public ChunkCustomCompilerExtension[] getCustomCompilers() {
        return this.myCustomCompilers;
    }

    public Module[] getModules() {
        return this.myModules;
    }

    @Nullable
    public String getOutputDirUrl() {
        CompilerModuleExtension extension = CompilerModuleExtension.getInstance((Module)this.myMainModule);
        return extension != null ? extension.getCompilerOutputUrl() : null;
    }

    @Nullable
    public String getTestsOutputDirUrl() {
        CompilerModuleExtension extension = CompilerModuleExtension.getInstance((Module)this.myMainModule);
        return extension != null ? extension.getCompilerOutputUrlForTests() : null;
    }

    public boolean isJdkInherited() {
        return ModuleRootManager.getInstance((Module)this.myMainModule).isSdkInherited();
    }

    @Nullable
    public Sdk getJdk() {
        return ModuleRootManager.getInstance((Module)this.myMainModule).getSdk();
    }

    public ModuleChunk[] getDependentChunks() {
        return this.myDependentChunks;
    }

    public void setDependentChunks(ModuleChunk[] dependentChunks) {
        this.myDependentChunks = dependentChunks;
    }

    public File getBaseDir() {
        return this.myBaseDir != null ? this.myBaseDir : new File(this.myMainModule.getModuleFilePath()).getParentFile();
    }

    public void setBaseDir(File baseDir) {
        this.myBaseDir = baseDir;
    }

    public void setMainModule(Module module) {
        this.myMainModule = module;
    }

    public Project getProject() {
        return this.myMainModule.getProject();
    }

    public String getChunkSpecificCompileOptions() {
        String bytecodeTarget;
        ArrayList<String> options = new ArrayList<String>();
        Charset encoding = CompilerEncodingService.getInstance(this.getProject()).getPreferredModuleEncoding(this.myMainModule);
        if (encoding != null) {
            options.add("-encoding");
            options.add(encoding.name());
        }
        LanguageLevel languageLevel = (LanguageLevel)ReadAction.compute(() -> EffectiveLanguageLevelUtil.getEffectiveLanguageLevel((Module)this.myMainModule));
        String sourceVersion = JpsJavaSdkType.complianceOption((JavaVersion)languageLevel.toJavaVersion());
        options.add("-source");
        options.add(sourceVersion);
        if (languageLevel.isPreview()) {
            options.add("--enable-preview");
        }
        if (StringUtil.isEmpty((String)(bytecodeTarget = CompilerConfiguration.getInstance(this.getProject()).getBytecodeTargetLevel(this.myMainModule)))) {
            bytecodeTarget = sourceVersion;
        }
        options.add("-target");
        options.add(bytecodeTarget);
        return StringUtil.join(options, (String)" ");
    }

    public boolean contains(Module module) {
        return ArrayUtil.contains((Object)module, (Object[])this.myModules);
    }
}

