/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.configurations;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.JavaExecutionUtil;
import com.intellij.execution.configurations.RunConfigurationModule;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.configurations.RuntimeConfigurationWarning;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import gnu.trove.THashSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaRunConfigurationModule
extends RunConfigurationModule {
    private final boolean myClassesInLibraries;

    public JavaRunConfigurationModule(@NotNull Project project, boolean classesInLibs) {
        if (project == null) {
            JavaRunConfigurationModule.$$$reportNull$$$0(0);
        }
        super(project);
        this.myClassesInLibraries = classesInLibs;
    }

    @Nullable
    public PsiClass findClass(String qualifiedName) {
        if (qualifiedName == null) {
            return null;
        }
        return JavaExecutionUtil.findMainClass(this.getProject(), qualifiedName, this.getSearchScope());
    }

    @NotNull
    public GlobalSearchScope getSearchScope() {
        Module module = this.getModule();
        if (module != null) {
            GlobalSearchScope globalSearchScope = this.myClassesInLibraries ? module.getModuleRuntimeScope(true) : GlobalSearchScope.moduleWithDependenciesScope((Module)module);
            if (globalSearchScope == null) {
                JavaRunConfigurationModule.$$$reportNull$$$0(1);
            }
            return globalSearchScope;
        }
        GlobalSearchScope globalSearchScope = this.myClassesInLibraries ? GlobalSearchScope.allScope((Project)this.getProject()) : GlobalSearchScope.projectScope((Project)this.getProject());
        if (globalSearchScope == null) {
            JavaRunConfigurationModule.$$$reportNull$$$0(2);
        }
        return globalSearchScope;
    }

    public static Collection<Module> getModulesForClass(@NotNull Project project, @Nullable String className) {
        if (project == null) {
            JavaRunConfigurationModule.$$$reportNull$$$0(3);
        }
        if (project.isDefault()) {
            return Arrays.asList(ModuleManager.getInstance((Project)project).getModules());
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        PsiClass[] possibleClasses = className == null ? PsiClass.EMPTY_ARRAY : JavaPsiFacade.getInstance((Project)project).findClasses(className, GlobalSearchScope.projectScope((Project)project));
        THashSet modules = new THashSet();
        for (PsiClass aClass : possibleClasses) {
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)aClass);
            if (module == null) continue;
            modules.add(module);
        }
        if (modules.isEmpty()) {
            return Arrays.asList(ModuleManager.getInstance((Project)project).getModules());
        }
        HashSet<Module> result = new HashSet<Module>();
        for (Module module : modules) {
            ModuleUtilCore.collectModulesDependsOn((Module)module, result);
        }
        return result;
    }

    public PsiClass findNotNullClass(String className) throws RuntimeConfigurationWarning {
        PsiClass psiClass = this.findClass(className);
        if (psiClass == null) {
            throw new RuntimeConfigurationWarning(ExecutionBundle.message((String)"class.not.found.in.module.error.message", (Object[])new Object[]{className, this.getModuleName()})){

                public boolean shouldShowInDumbMode() {
                    return false;
                }
            };
        }
        return psiClass;
    }

    public PsiClass checkModuleAndClassName(String className, String expectedClassMessage) throws RuntimeConfigurationException {
        this.checkForWarning();
        return this.checkClassName(className, expectedClassMessage);
    }

    public PsiClass checkClassName(String className, String errorMessage) throws RuntimeConfigurationException {
        if (className == null || className.length() == 0) {
            throw new RuntimeConfigurationError(errorMessage);
        }
        return this.findNotNullClass(className);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/configurations/JavaRunConfigurationModule";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/configurations/JavaRunConfigurationModule";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSearchScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getModulesForClass";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

