/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.compiler.CompilerManagerImpl;
import com.intellij.compiler.CompilerTestUtil;
import com.intellij.compiler.server.BuildManager;
import com.intellij.diagnostic.ThreadDumper;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.PathMacros;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompileStatusNotification;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.compiler.CompilerMessage;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.impl.stores.IComponentStore;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.impl.JavaAwareProjectJdkTableImpl;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.CompilerProjectExtension;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.project.ProjectKt;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.testFramework.EdtTestUtil;
import com.intellij.testFramework.PlatformTestUtil;
import com.intellij.testFramework.RunAll;
import com.intellij.testFramework.fixtures.IdeaProjectTestFixture;
import com.intellij.testFramework.fixtures.TempDirTestFixture;
import com.intellij.testFramework.fixtures.impl.TempDirTestFixtureImpl;
import com.intellij.util.Consumer;
import com.intellij.util.ExceptionUtilRt;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.io.FileTreePrinterKt;
import com.intellij.util.ui.UIUtil;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.cmdline.LogSetup;
import org.junit.Assert;

public class CompilerTester {
    private static final Logger LOG = Logger.getInstance(CompilerTester.class);
    private final Project myProject;
    private List<? extends Module> myModules;
    private TempDirTestFixture myMainOutput;

    public CompilerTester(@NotNull Module module) throws Exception {
        if (module == null) {
            CompilerTester.$$$reportNull$$$0(0);
        }
        this(module.getProject(), Collections.singletonList(module), null);
    }

    public CompilerTester(@NotNull IdeaProjectTestFixture fixture, @NotNull List<? extends Module> modules) throws Exception {
        if (fixture == null) {
            CompilerTester.$$$reportNull$$$0(1);
        }
        if (modules == null) {
            CompilerTester.$$$reportNull$$$0(2);
        }
        this(fixture.getProject(), modules, fixture.getTestRootDisposable());
    }

    public CompilerTester(@NotNull Project project, @NotNull List<? extends Module> modules, @Nullable Disposable disposable) throws Exception {
        if (project == null) {
            CompilerTester.$$$reportNull$$$0(3);
        }
        if (modules == null) {
            CompilerTester.$$$reportNull$$$0(4);
        }
        this.myProject = project;
        this.myModules = modules;
        this.myMainOutput = new TempDirTestFixtureImpl();
        this.myMainOutput.setUp();
        if (disposable != null) {
            Disposer.register((Disposable)disposable, (Disposable)new Disposable(){

                public void dispose() {
                    CompilerTester.this.tearDown();
                }
            });
        }
        CompilerTestUtil.enableExternalCompiler();
        WriteCommandAction.writeCommandAction((Project)this.getProject()).run(() -> {
            Objects.requireNonNull(CompilerProjectExtension.getInstance((Project)this.getProject())).setCompilerOutputUrl(this.myMainOutput.findOrCreateDir("out").getUrl());
            if (!this.myModules.isEmpty()) {
                JavaAwareProjectJdkTableImpl projectJdkTable = JavaAwareProjectJdkTableImpl.getInstanceEx();
                for (Module module : this.myModules) {
                    ModuleRootModificationUtil.setModuleSdk((Module)module, (Sdk)projectJdkTable.getInternalJdk());
                }
            }
        });
    }

    public void tearDown() {
        try {
            new RunAll(new ThrowableRunnable[]{() -> CompilerTestUtil.disableExternalCompiler(this.getProject()), () -> this.myMainOutput.tearDown()}).run();
        }
        finally {
            this.myMainOutput = null;
            this.myModules = null;
        }
    }

    private Project getProject() {
        return this.myProject;
    }

    public void deleteClassFile(@NotNull String className) throws IOException {
        if (className == null) {
            CompilerTester.$$$reportNull$$$0(5);
        }
        WriteAction.runAndWait(() -> {
            if (className == null) {
                CompilerTester.$$$reportNull$$$0(9);
            }
            this.touch(JavaPsiFacade.getInstance((Project)this.getProject()).findClass(className, GlobalSearchScope.allScope((Project)this.getProject())).getContainingFile().getVirtualFile());
        });
    }

    @Nullable
    public VirtualFile findClassFile(String className, Module module) {
        VirtualFile path = ((CompilerModuleExtension)ModuleRootManager.getInstance((Module)module).getModuleExtension(CompilerModuleExtension.class)).getCompilerOutputPath();
        assert (path != null);
        path.getChildren();
        path.refresh(false, true);
        return path.findFileByRelativePath(className.replace('.', '/') + ".class");
    }

    public void touch(VirtualFile file) throws IOException {
        WriteAction.runAndWait(() -> {
            file.setBinaryContent(file.contentsToByteArray(), -1L, file.getTimeStamp() + 1L);
            File ioFile = VfsUtilCore.virtualToIoFile((VirtualFile)file);
            assert (ioFile.setLastModified(ioFile.lastModified() - 100000L));
            file.refresh(false, false);
        });
    }

    public void setFileText(PsiFile file, String text) throws IOException {
        WriteAction.runAndWait(() -> {
            VirtualFile virtualFile = file.getVirtualFile();
            VfsUtil.saveText((VirtualFile)((VirtualFile)ObjectUtils.assertNotNull((Object)virtualFile)), (String)text);
        });
        this.touch(file.getVirtualFile());
    }

    public void setFileName(PsiFile file, String name) {
        WriteCommandAction.writeCommandAction((Project)this.getProject()).run(() -> file.setName(name));
    }

    public List<CompilerMessage> make() {
        return this.runCompiler((Consumer<? super CompileStatusNotification>)((Consumer)callback -> CompilerManager.getInstance(this.getProject()).make((CompileStatusNotification)callback)));
    }

    public List<CompilerMessage> rebuild() {
        return this.runCompiler((Consumer<? super CompileStatusNotification>)((Consumer)callback -> CompilerManager.getInstance(this.getProject()).rebuild((CompileStatusNotification)callback)));
    }

    public List<CompilerMessage> compileModule(Module module) {
        return this.runCompiler((Consumer<? super CompileStatusNotification>)((Consumer)callback -> CompilerManager.getInstance(this.getProject()).compile(module, (CompileStatusNotification)callback)));
    }

    public List<CompilerMessage> make(CompileScope scope) {
        return this.runCompiler((Consumer<? super CompileStatusNotification>)((Consumer)callback -> CompilerManager.getInstance(this.getProject()).make(scope, (CompileStatusNotification)callback)));
    }

    public List<CompilerMessage> compileFiles(VirtualFile ... files) {
        return this.runCompiler((Consumer<? super CompileStatusNotification>)((Consumer)callback -> CompilerManager.getInstance(this.getProject()).compile(files, (CompileStatusNotification)callback)));
    }

    @NotNull
    public List<CompilerMessage> runCompiler(@NotNull Consumer<? super CompileStatusNotification> runnable) {
        if (runnable == null) {
            CompilerTester.$$$reportNull$$$0(6);
        }
        Semaphore semaphore = new Semaphore();
        semaphore.down();
        ErrorReportingCallback callback = new ErrorReportingCallback(semaphore);
        EdtTestUtil.runInEdtAndWait(() -> {
            Path configDir;
            Path macroFilePath;
            PathMacros pathMacroManager;
            Map map;
            if (runnable == null) {
                CompilerTester.$$$reportNull$$$0(8);
            }
            CompilerTester.refreshVfs(this.getProject().getProjectFilePath());
            for (Module module : this.myModules) {
                CompilerTester.refreshVfs(module.getModuleFilePath());
            }
            PlatformTestUtil.saveProject((Project)this.getProject(), (boolean)false);
            CompilerTestUtil.saveApplicationSettings();
            if (!ProjectKt.isDirectoryBased((Project)this.myProject)) {
                for (Module module : this.myModules) {
                    Path ioFile = Paths.get(module.getModuleFilePath(), new String[0]);
                    if (Files.exists(ioFile, new LinkOption[0])) continue;
                    this.getProject().save();
                    assert (Files.exists(ioFile, new LinkOption[0])) : "File does not exist: " + ioFile.toString();
                }
            }
            if (!(map = (pathMacroManager = PathMacros.getInstance()).getUserMacros()).isEmpty() && !Files.exists(macroFilePath = (configDir = Paths.get(PathManager.getConfigPath(), new String[0])).resolve("options").resolve("path.macros.xml"), new LinkOption[0])) {
                String message = "File " + macroFilePath + " doesn't exist, but user macros defined: " + map + "\n\n File listing:" + FileTreePrinterKt.getDirectoryTree((Path)configDir);
                LOG.warn(message);
                String fakeMacroName = "__remove_me__";
                IComponentStore applicationStore = CompilerTestUtil.getApplicationStore();
                pathMacroManager.setMacro(fakeMacroName, fakeMacroName);
                applicationStore.saveApplicationComponent((PersistentStateComponent)pathMacroManager);
                pathMacroManager.removeMacro(fakeMacroName);
                applicationStore.saveApplicationComponent((PersistentStateComponent)pathMacroManager);
                if (!Files.exists(macroFilePath, new LinkOption[0])) {
                    throw new AssertionError((Object)message);
                }
            }
            CompilerTester.enableDebugLogging();
            runnable.consume((Object)callback);
        });
        while (!semaphore.waitFor(100L)) {
            if (!SwingUtilities.isEventDispatchThread()) continue;
            UIUtil.dispatchAllInvocationEvents();
        }
        CompilerTester.printBuildLog();
        callback.throwException();
        if (!((CompilerManagerImpl)CompilerManager.getInstance(this.getProject())).waitForExternalJavacToTerminate(1L, TimeUnit.MINUTES)) {
            throw new RuntimeException("External javac thread is still running. Thread dump:" + ThreadDumper.dumpThreadsToString());
        }
        List<CompilerMessage> list = callback.getMessages();
        if (list == null) {
            CompilerTester.$$$reportNull$$$0(7);
        }
        return list;
    }

    public static void printBuildLog() {
        File logDirectory = BuildManager.getBuildLogDirectory();
        File[] files = logDirectory.listFiles(file -> file.getName().endsWith(".log"));
        if (files == null || files.length == 0) {
            LOG.debug("No *.log files in " + logDirectory + " after build");
            return;
        }
        Arrays.sort(files, Comparator.comparing(File::getName));
        for (File file2 : files) {
            LOG.debug(file2.getName() + ":");
            try {
                List lines = FileUtil.loadLines((File)file2);
                for (String line : lines) {
                    LOG.debug(line);
                }
            }
            catch (IOException e) {
                LOG.debug("Failed to load contents: " + e.getMessage());
            }
        }
    }

    public static void enableDebugLogging() throws IOException {
        File logDirectory = BuildManager.getBuildLogDirectory();
        FileUtil.delete((File)logDirectory);
        FileUtil.createDirectory((File)logDirectory);
        Properties properties = new Properties();
        try (InputStream config = LogSetup.readDefaultLogConfig();){
            properties.load(config);
        }
        properties.setProperty("log4j.rootLogger", "debug, file");
        File logFile = new File(logDirectory, "build-log.properties");
        try (BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(logFile));){
            properties.store(output, null);
        }
    }

    private static void refreshVfs(String path) {
        VirtualFile vFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(new File(path));
        if (vFile != null) {
            vFile.refresh(false, false);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fixture";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modules";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/testFramework/CompilerTester";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/testFramework/CompilerTester";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "runCompiler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "deleteClassFile";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "runCompiler";
                break;
            }
            case 7: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "lambda$runCompiler$12";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "lambda$deleteClassFile$3";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ErrorReportingCallback
    implements CompileStatusNotification {
        private final Semaphore mySemaphore;
        private Throwable myError;
        private final List<CompilerMessage> myMessages;

        ErrorReportingCallback(@NotNull Semaphore semaphore) {
            if (semaphore == null) {
                ErrorReportingCallback.$$$reportNull$$$0(0);
            }
            this.myMessages = new ArrayList<CompilerMessage>();
            this.mySemaphore = semaphore;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void finished(boolean aborted, int errors, int warnings, @NotNull CompileContext compileContext) {
            if (compileContext == null) {
                ErrorReportingCallback.$$$reportNull$$$0(1);
            }
            try {
                for (CompilerMessageCategory category : CompilerMessageCategory.values()) {
                    CompilerMessage[] messages;
                    for (CompilerMessage message : messages = compileContext.getMessages(category)) {
                        String text = message.getMessage();
                        if (category == CompilerMessageCategory.INFORMATION && ErrorReportingCallback.isSpamMessage(text)) continue;
                        this.myMessages.add(message);
                    }
                }
                Assert.assertFalse((String)"Code did not compile!", (boolean)aborted);
            }
            catch (Throwable t) {
                this.myError = t;
            }
            finally {
                this.mySemaphore.up();
            }
        }

        private static boolean isSpamMessage(String text) {
            return text.contains("Compilation completed successfully") || text.contains("used to compile") || text.contains("illegal reflective") || text.contains("consider reporting this to the maintainers") || text.startsWith("Using Groovy-Eclipse");
        }

        void throwException() {
            if (this.myError != null) {
                ExceptionUtilRt.rethrow((Throwable)this.myError);
            }
        }

        @NotNull
        public List<CompilerMessage> getMessages() {
            List<CompilerMessage> list = this.myMessages;
            if (list == null) {
                ErrorReportingCallback.$$$reportNull$$$0(2);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "semaphore";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "compileContext";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/testFramework/CompilerTester$ErrorReportingCallback";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/testFramework/CompilerTester$ErrorReportingCallback";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMessages";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "finished";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

