/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.compiler;

import com.intellij.diagnostic.PluginException;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.compiler.CompilationStatusListener;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.compiler.CompilerMessage;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.KotlinFileType;

public class KotlinCompilerManager
extends AbstractProjectComponent {
    private static final Logger LOG = Logger.getInstance(KotlinCompilerManager.class);
    private static final String PREFIX_WITH_COMPILER_NAME = "Kotlin: [Internal Error] ";
    private static final Set<String> FILE_EXTS_WHICH_NEEDS_REFRESH = ContainerUtil.immutableSet((Object[])new String[]{".js", ".map"});

    public KotlinCompilerManager(Project project, CompilerManager manager) {
        super(project);
        manager.addCompilableFileType((FileType)KotlinFileType.INSTANCE);
        manager.addCompilationStatusListener(new CompilationStatusListener(){

            public void compilationFinished(boolean aborted, int errors, int warnings, CompileContext compileContext) {
                for (CompilerMessage error2 : compileContext.getMessages(CompilerMessageCategory.ERROR)) {
                    String message = error2.getMessage();
                    if (!message.startsWith("[Internal Error] ") && !message.startsWith(KotlinCompilerManager.PREFIX_WITH_COMPILER_NAME)) continue;
                    LOG.error((Throwable)((Object)new KotlinCompilerException(message)));
                }
            }

            public void fileGenerated(String outputRoot, String relativePath) {
                if (ApplicationManager.getApplication().isUnitTestMode()) {
                    return;
                }
                String ext = FileUtilRt.getExtension((String)relativePath).toLowerCase();
                if (FILE_EXTS_WHICH_NEEDS_REFRESH.contains(ext)) {
                    String outFile = outputRoot + "/" + relativePath;
                    VirtualFile virtualFile2 = LocalFileSystem.getInstance().findFileByPath(outFile);
                    assert (virtualFile2 != null) : "Virtual file not found for generated file path: " + outFile;
                    virtualFile2.refresh(false, false);
                }
            }
        }, (Disposable)project);
    }

    private static class KotlinCompilerException
    extends PluginException {
        private final String text;

        public KotlinCompilerException(String text2) {
            super("", PluginManagerCore.getPluginByClassName((String)KotlinCompilerManager.class.getName()));
            this.text = text2;
        }

        public void printStackTrace(PrintWriter s) {
            s.print(this.text);
        }

        public void printStackTrace(@NotNull PrintStream s) {
            if (s == null) {
                KotlinCompilerException.$$$reportNull$$$0(0);
            }
            s.print(this.text);
        }

        @NotNull
        public synchronized Throwable fillInStackTrace() {
            KotlinCompilerException kotlinCompilerException = this;
            if (kotlinCompilerException == null) {
                KotlinCompilerException.$$$reportNull$$$0(1);
            }
            return kotlinCompilerException;
        }

        public StackTraceElement[] getStackTrace() {
            LOG.error("Somebody called getStackTrace() on KotlinCompilerException");
            return new UnsupportedOperationException().getStackTrace();
        }

        public String getMessage() {
            return "<Exception from standalone Kotlin compiler>";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "s";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/kotlin/idea/compiler/KotlinCompilerManager$KotlinCompilerException";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/kotlin/idea/compiler/KotlinCompilerManager$KotlinCompilerException";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "fillInStackTrace";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "printStackTrace";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

