/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.configuration.ui.notifications;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.event.HyperlinkEvent;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.configuration.ConfigureKotlinInProjectUtilsKt;
import org.jetbrains.kotlin.idea.configuration.KotlinProjectConfigurator;
import org.jetbrains.kotlin.idea.configuration.ModuleSourceRootGroup;
import org.jetbrains.kotlin.idea.configuration.ui.notifications.ConfigureKotlinNotificationState;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0096\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0016R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/configuration/ui/notifications/ConfigureKotlinNotification;", "Lcom/intellij/notification/Notification;", "project", "Lcom/intellij/openapi/project/Project;", "excludeModules", "", "Lcom/intellij/openapi/module/Module;", "notificationState", "Lorg/jetbrains/kotlin/idea/configuration/ui/notifications/ConfigureKotlinNotificationState;", "(Lcom/intellij/openapi/project/Project;Ljava/util/List;Lorg/jetbrains/kotlin/idea/configuration/ui/notifications/ConfigureKotlinNotificationState;)V", "getNotificationState", "()Lorg/jetbrains/kotlin/idea/configuration/ui/notifications/ConfigureKotlinNotificationState;", "equals", "", "o", "", "hashCode", "", "Companion", "idea-jvm"})
public final class ConfigureKotlinNotification
extends Notification {
    @NotNull
    private final ConfigureKotlinNotificationState notificationState;
    public static final Companion Companion = new Companion(null);

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ConfigureKotlinNotification)) {
            return false;
        }
        return !(Intrinsics.areEqual((Object)this.getContent(), (Object)((ConfigureKotlinNotification)((Object)o)).getContent()) ^ true);
    }

    public int hashCode() {
        return this.getContent().hashCode();
    }

    @NotNull
    public final ConfigureKotlinNotificationState getNotificationState() {
        return this.notificationState;
    }

    public ConfigureKotlinNotification(final @NotNull Project project, final @NotNull List<? extends Module> excludeModules, @NotNull ConfigureKotlinNotificationState notificationState2) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull(excludeModules, (String)"excludeModules");
        Intrinsics.checkParameterIsNotNull((Object)notificationState2, (String)"notificationState");
        super("Configure Kotlin in Project", "Configure Kotlin", notificationState2.getNotificationString(), NotificationType.WARNING, new NotificationListener(){

            public final void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
                Intrinsics.checkParameterIsNotNull((Object)notification, (String)"notification");
                Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
                if (Intrinsics.areEqual((Object)event.getEventType(), (Object)HyperlinkEvent.EventType.ACTIVATED)) {
                    String string = event.getDescription();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"event.description");
                    KotlinProjectConfigurator kotlinProjectConfigurator = ConfigureKotlinInProjectUtilsKt.getConfiguratorByName(string);
                    if (kotlinProjectConfigurator == null) {
                        throw (Throwable)((Object)new AssertionError((Object)("Missed action: " + event.getDescription())));
                    }
                    KotlinProjectConfigurator configurator = kotlinProjectConfigurator;
                    notification.expire();
                    configurator.configure(project, excludeModules);
                }
            }
        });
        this.notificationState = notificationState2;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u001e\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/configuration/ui/notifications/ConfigureKotlinNotification$Companion;", "", "()V", "getLink", "", "configurator", "Lorg/jetbrains/kotlin/idea/configuration/KotlinProjectConfigurator;", "isOnlyOneModule", "", "getNotificationState", "Lorg/jetbrains/kotlin/idea/configuration/ui/notifications/ConfigureKotlinNotificationState;", "project", "Lcom/intellij/openapi/project/Project;", "excludeModules", "", "Lcom/intellij/openapi/module/Module;", "idea-jvm"})
    public static final class Companion {
        /*
         * WARNING - void declaration
         */
        @Nullable
        public final ConfigureKotlinNotificationState getNotificationState(@NotNull Project project, @NotNull Collection<? extends Module> excludeModules) {
            Collection<String> collection;
            void $receiver$iv$iv;
            void $receiver$iv;
            void configurableModules;
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull(excludeModules, (String)"excludeModules");
            Pair<Collection<ModuleSourceRootGroup>, Collection<KotlinProjectConfigurator>> pair = ConfigureKotlinInProjectUtilsKt.getConfigurationPossibilitiesForConfigureNotification(project, excludeModules);
            Collection collection2 = (Collection)pair.component1();
            Collection ableToRunConfigurators = (Collection)pair.component2();
            if (ableToRunConfigurators.isEmpty() || configurableModules.isEmpty()) {
                return null;
            }
            boolean isOnlyOneModule = configurableModules.size() == 1;
            String modulesString = isOnlyOneModule ? '\'' + ((ModuleSourceRootGroup)CollectionsKt.first((Iterable)((Iterable)configurableModules))).getBaseModule().getName() + "' module" : "modules";
            String links2 = CollectionsKt.joinToString$default((Iterable)ableToRunConfigurators, (CharSequence)"<br/>", null, null, (int)0, null, (Function1)((Function1)new Function1<KotlinProjectConfigurator, String>(isOnlyOneModule){
                final /* synthetic */ boolean $isOnlyOneModule;

                @NotNull
                public final String invoke(@NotNull KotlinProjectConfigurator configurator) {
                    Intrinsics.checkParameterIsNotNull((Object)configurator, (String)"configurator");
                    return org.jetbrains.kotlin.idea.configuration.ui.notifications.ConfigureKotlinNotification$Companion.access$getLink(ConfigureKotlinNotification.Companion, configurator, this.$isOnlyOneModule);
                }
                {
                    this.$isOnlyOneModule = bl;
                    super(1);
                }
            }), (int)30, null);
            String string = project.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"project.name");
            Iterable iterable = (Iterable)configurableModules;
            String string2 = "Configure " + modulesString + " in '" + project.getName() + "' project<br/> " + links2;
            String string3 = string;
            void var9_12 = $receiver$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                ModuleSourceRootGroup moduleSourceRootGroup = (ModuleSourceRootGroup)item$iv$iv;
                collection = destination$iv$iv;
                String string4 = it.getBaseModule().getName();
                collection.add(string4);
            }
            collection = (List)destination$iv$iv;
            Collection collection3 = collection;
            String string5 = string2;
            String string6 = string3;
            return new ConfigureKotlinNotificationState(string6, string5, collection3);
        }

        private final String getLink(KotlinProjectConfigurator configurator, boolean isOnlyOneModule) {
            return "<a href=\"" + configurator.getName() + "\">as Kotlin (" + configurator.getPresentableText() + ") module" + (!isOnlyOneModule ? "s" : "") + "</a>";
        }

        private Companion() {
        }

        @NotNull
        public static final /* synthetic */ String access$getLink(Companion $this, @NotNull KotlinProjectConfigurator configurator, boolean isOnlyOneModule) {
            return $this.getLink(configurator, isOnlyOneModule);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

