/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger;

import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.search.GlobalSearchScope;
import com.sun.jdi.Location;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.finder.JavaElementFinder;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.idea.KotlinFileTypeFactory;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.codeInsight.DescriptorToSourceUtilsIde;
import org.jetbrains.kotlin.idea.debugger.FileRankingCalculatorForIde;
import org.jetbrains.kotlin.idea.resolve.ResolutionFacade;
import org.jetbrains.kotlin.idea.stubindex.KotlinSourceFilterScope;
import org.jetbrains.kotlin.idea.stubindex.PackageIndexUtil;
import org.jetbrains.kotlin.idea.stubindex.StaticFacadeIndexUtil;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclarationEntry;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtForExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtTreeVisitorVoid;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.CompositeBindingContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.inline.InlineUtil;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedSimpleFunctionDescriptor;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;
import org.jetbrains.kotlin.utils.CollectionsKt;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JB\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\f2\u0006\u0010\r\u001a\u00020\u000e2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0004H\u0002J\u001c\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\b0\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u000eJ<\u0010\u0013\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\u00150\u00142\u0006\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u000e2\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\u0004J.\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0002J8\u0010$\u001a\u0004\u0018\u00010\u00162\u0006\u0010 \u001a\u00020!2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020#0\u00152\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\b\u0010&\u001a\u0004\u0018\u00010'J4\u0010(\u001a\u0004\u0018\u00010\u00162\u0006\u0010 \u001a\u00020!2\u0006\u0010)\u001a\u00020#2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\n\b\u0002\u0010&\u001a\u0004\u0018\u00010'J\u0010\u0010*\u001a\u00020\u000e2\u0006\u0010+\u001a\u00020,H\u0002J\u000e\u0010-\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\u001fJ@\u0010.\u001a\n\u0012\u0004\u0012\u0002H/\u0018\u00010\u0010\"\u0004\b\u0000\u00100\"\u0004\b\u0001\u0010/*\b\u0012\u0004\u0012\u0002H00\u00102\u0018\u00101\u001a\u0014\u0012\u0004\u0012\u0002H0\u0012\n\u0012\b\u0012\u0004\u0012\u0002H/0\u001002H\u0002\u00a8\u00063"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/DebuggerUtils;", "", "()V", "analyzeElementWithInline", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "resolutionFacade", "Lorg/jetbrains/kotlin/idea/resolve/ResolutionFacade;", "element", "Lorg/jetbrains/kotlin/psi/KtElement;", "deep", "", "analyzedElements", "", "analyzeInlineFunctions", "", "fullResolveContext", "", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "analyzeInlinedFunctions", "Lkotlin/Pair;", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "resolutionFacadeForFile", "file", "analyzeOnlyReifiedInlineFunctions", "bindingContext", "findFilesByNameInPackage", "className", "Lorg/jetbrains/kotlin/resolve/jvm/JvmClassName;", "fileName", "", "project", "Lcom/intellij/openapi/project/Project;", "searchScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "findSourceFileForClass", "scopes", "location", "Lcom/sun/jdi/Location;", "findSourceFileForClassIncludeLibrarySources", "scope", "hasReifiedTypeParameters", "descriptor", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "isKotlinSourceFile", "findFirstNotEmpty", "R", "T", "predicate", "Lkotlin/Function1;", "idea-jvm"})
public final class DebuggerUtils {
    public static final DebuggerUtils INSTANCE;

    @Nullable
    public final KtFile findSourceFileForClassIncludeLibrarySources(@NotNull Project project, @NotNull GlobalSearchScope scope, @NotNull JvmClassName className, @NotNull String fileName, @Nullable Location location2) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)scope, (String)"scope");
        Intrinsics.checkParameterIsNotNull((Object)className, (String)"className");
        Intrinsics.checkParameterIsNotNull((Object)fileName, (String)"fileName");
        return (KtFile)ApplicationUtilsKt.runReadAction((Function0)((Function0)new Function0<KtFile>(project, scope, className, fileName, location2){
            final /* synthetic */ Project $project;
            final /* synthetic */ GlobalSearchScope $scope;
            final /* synthetic */ JvmClassName $className;
            final /* synthetic */ String $fileName;
            final /* synthetic */ Location $location;

            @Nullable
            public final KtFile invoke() {
                Object[] objectArray = new GlobalSearchScope[2];
                objectArray[0] = this.$scope;
                GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope((Project)this.$project);
                Intrinsics.checkExpressionValueIsNotNull((Object)globalSearchScope, (String)"GlobalSearchScope.allScope(project)");
                objectArray[1] = KotlinSourceFilterScope.Companion.librarySources(globalSearchScope, this.$project);
                return DebuggerUtils.INSTANCE.findSourceFileForClass(this.$project, kotlin.collections.CollectionsKt.listOf((Object[])objectArray), this.$className, this.$fileName, this.$location);
            }
            {
                this.$project = project;
                this.$scope = globalSearchScope;
                this.$className = jvmClassName;
                this.$fileName = string;
                this.$location = location2;
                super(0);
            }
        }));
    }

    @Nullable
    public static /* synthetic */ KtFile findSourceFileForClassIncludeLibrarySources$default(DebuggerUtils debuggerUtils, Project project, GlobalSearchScope globalSearchScope, JvmClassName jvmClassName, String string, Location location2, int n, Object object) {
        if ((n & 0x10) != 0) {
            location2 = null;
        }
        return debuggerUtils.findSourceFileForClassIncludeLibrarySources(project, globalSearchScope, jvmClassName, string, location2);
    }

    @Nullable
    public final KtFile findSourceFileForClass(@NotNull Project project, @NotNull List<? extends GlobalSearchScope> scopes, @NotNull JvmClassName className, @NotNull String fileName, @Nullable Location location2) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull(scopes, (String)"scopes");
        Intrinsics.checkParameterIsNotNull((Object)className, (String)"className");
        Intrinsics.checkParameterIsNotNull((Object)fileName, (String)"fileName");
        if (!this.isKotlinSourceFile(fileName)) {
            return null;
        }
        DumbService dumbService = DumbService.getInstance((Project)project);
        Intrinsics.checkExpressionValueIsNotNull((Object)dumbService, (String)"DumbService.getInstance(project)");
        if (dumbService.isDumb()) {
            return null;
        }
        Collection collection = this.findFirstNotEmpty((Collection)scopes, (Function1)new Function1<GlobalSearchScope, List<? extends KtFile>>(className, fileName, project){
            final /* synthetic */ JvmClassName $className;
            final /* synthetic */ String $fileName;
            final /* synthetic */ Project $project;

            @NotNull
            public final List<KtFile> invoke(@NotNull GlobalSearchScope it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return DebuggerUtils.access$findFilesByNameInPackage(DebuggerUtils.INSTANCE, this.$className, this.$fileName, this.$project, it);
            }
            {
                this.$className = jvmClassName;
                this.$fileName = string;
                this.$project = project;
                super(1);
            }
        });
        if (collection == null) {
            return null;
        }
        Collection filesWithExactName2 = collection;
        if (filesWithExactName2.isEmpty()) {
            return null;
        }
        if (filesWithExactName2.size() == 1) {
            return (KtFile)kotlin.collections.CollectionsKt.single((Iterable)filesWithExactName2);
        }
        FqName fqName = className.getFqNameForClassNameWithoutDollars();
        Intrinsics.checkExpressionValueIsNotNull((Object)fqName, (String)"className.fqNameForClassNameWithoutDollars");
        FqName partFqName = fqName;
        Collection collection2 = this.findFirstNotEmpty((Collection)scopes, (Function1)new Function1<GlobalSearchScope, Collection<? extends KtFile>>(partFqName, project){
            final /* synthetic */ FqName $partFqName;
            final /* synthetic */ Project $project;

            @NotNull
            public final Collection<KtFile> invoke(@NotNull GlobalSearchScope it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return StaticFacadeIndexUtil.findFilesForFilePart((FqName)this.$partFqName, (GlobalSearchScope)it, (Project)this.$project);
            }
            {
                this.$partFqName = fqName;
                this.$project = project;
                super(1);
            }
        });
        if (collection2 == null) {
            return null;
        }
        Collection filesForPart2 = collection2;
        if (!filesForPart2.isEmpty()) {
            for (KtFile file2 : filesForPart2) {
                if (!Intrinsics.areEqual((Object)file2.getName(), (Object)fileName)) continue;
                return file2;
            }
            return null;
        }
        if (location2 != null) {
            return FileRankingCalculatorForIde.INSTANCE.findMostAppropriateSource(filesWithExactName2, location2);
        }
        return (KtFile)kotlin.collections.CollectionsKt.first((Iterable)filesWithExactName2);
    }

    private final <T, R> Collection<R> findFirstNotEmpty(@NotNull Collection<? extends T> $receiver, Function1<? super T, ? extends Collection<? extends R>> predicate) {
        T e;
        Collection collection;
        Collection result2 = kotlin.collections.CollectionsKt.emptyList();
        Iterator<T> iterator = $receiver.iterator();
        while (iterator.hasNext() && !(!(collection = (result2 = (Collection)predicate.invoke(e = iterator.next()))).isEmpty())) {
        }
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    private final List<KtFile> findFilesByNameInPackage(JvmClassName className, String fileName, Project project, GlobalSearchScope searchScope) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        FqName fqName = className.getPackageFqName();
        Intrinsics.checkExpressionValueIsNotNull((Object)fqName, (String)"className.packageFqName");
        Iterable iterable = $receiver$iv = (Iterable)PackageIndexUtil.findFilesWithExactPackage((FqName)fqName, (GlobalSearchScope)searchScope, (Project)project);
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            KtFile it = (KtFile)element$iv$iv;
            if (!Intrinsics.areEqual((Object)it.getName(), (Object)fileName)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List files = (List)destination$iv$iv;
        return kotlin.collections.CollectionsKt.sortedWith((Iterable)files, (Comparator)JavaElementFinder.Companion.byClasspathComparator(searchScope));
    }

    @NotNull
    public final Pair<BindingContext, List<KtFile>> analyzeInlinedFunctions(@NotNull ResolutionFacade resolutionFacadeForFile, @NotNull KtFile file2, boolean analyzeOnlyReifiedInlineFunctions, @Nullable BindingContext bindingContext2) {
        Intrinsics.checkParameterIsNotNull((Object)resolutionFacadeForFile, (String)"resolutionFacadeForFile");
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        HashSet analyzedElements = new HashSet();
        BindingContext context = this.analyzeElementWithInline(resolutionFacadeForFile, (KtElement)file2, 1, analyzedElements, !analyzeOnlyReifiedInlineFunctions, bindingContext2);
        LinkedHashSet<KtFile> toProcess = new LinkedHashSet<KtFile>();
        toProcess.add(file2);
        Iterator iterator = analyzedElements.iterator();
        while (iterator.hasNext()) {
            KtFile containingFile;
            KtElement collectedElement;
            KtElement ktElement = collectedElement = (KtElement)iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)ktElement, (String)"collectedElement");
            Intrinsics.checkExpressionValueIsNotNull((Object)ktElement.getContainingKtFile(), (String)"collectedElement.containingKtFile");
            toProcess.add(containingFile);
        }
        return new Pair((Object)context, new ArrayList(toProcess));
    }

    @NotNull
    public static /* synthetic */ Pair analyzeInlinedFunctions$default(DebuggerUtils debuggerUtils, ResolutionFacade resolutionFacade, KtFile ktFile, boolean bl, BindingContext bindingContext2, int n, Object object) {
        if ((n & 8) != 0) {
            bindingContext2 = null;
        }
        return debuggerUtils.analyzeInlinedFunctions(resolutionFacade, ktFile, bl, bindingContext2);
    }

    @NotNull
    public final Collection<KtElement> analyzeElementWithInline(@NotNull KtNamedFunction function, boolean analyzeInlineFunctions) {
        Intrinsics.checkParameterIsNotNull((Object)function, (String)"function");
        HashSet analyzedElements = new HashSet();
        DebuggerUtils.analyzeElementWithInline$default(this, ResolutionUtils.getResolutionFacade((KtElement)((KtElement)function)), (KtElement)function, 1, analyzedElements, !analyzeInlineFunctions, null, 32, null);
        return analyzedElements;
    }

    public final boolean isKotlinSourceFile(@NotNull String fileName) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)fileName, (String)"fileName");
        String string2 = FileUtilRt.getExtension((String)fileName);
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"FileUtilRt.getExtension(fileName)");
        String string3 = string = string2;
        if (string3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string4 = string3.toLowerCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).toLowerCase()");
        String extension = string4;
        Intrinsics.checkExpressionValueIsNotNull((Object)KotlinFileTypeFactory.KOTLIN_EXTENSIONS, (String)"KotlinFileTypeFactory.KOTLIN_EXTENSIONS");
        return ArraysKt.contains((Object[])KotlinFileTypeFactory.KOTLIN_EXTENSIONS, (Object)extension);
    }

    private final BindingContext analyzeElementWithInline(ResolutionFacade resolutionFacade, KtElement element, int deep, Set<KtElement> analyzedElements, boolean analyzeInlineFunctions, BindingContext fullResolveContext) {
        Project project = element.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"element.project");
        Project project2 = project;
        HashSet inlineFunctions = new HashSet();
        ArrayList<BindingContext> innerContexts = new ArrayList<BindingContext>();
        CollectionsKt.addIfNotNull((Collection)innerContexts, (Object)fullResolveContext);
        element.accept((PsiElementVisitor)new KtTreeVisitorVoid(resolutionFacade, innerContexts, analyzeInlineFunctions, project2, analyzedElements, inlineFunctions){
            final /* synthetic */ ResolutionFacade $resolutionFacade;
            final /* synthetic */ ArrayList $innerContexts;
            final /* synthetic */ boolean $analyzeInlineFunctions;
            final /* synthetic */ Project $project;
            final /* synthetic */ Set $analyzedElements;
            final /* synthetic */ HashSet $inlineFunctions;

            public void visitExpression(@NotNull KtExpression expression) {
                Intrinsics.checkParameterIsNotNull((Object)expression, (String)"expression");
                super.visitExpression(expression);
                BindingContext bindingContext2 = ResolutionFacade.DefaultImpls.analyze$default((ResolutionFacade)this.$resolutionFacade, (KtElement)((KtElement)expression), null, (int)2, null);
                this.$innerContexts.add(bindingContext2);
                Call call = (Call)bindingContext2.get((ReadOnlySlice)BindingContext.CALL, (Object)expression);
                if (call == null) {
                    return;
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)call, (String)"bindingContext.get(Bindi\u2026LL, expression) ?: return");
                Call call2 = call;
                ResolvedCall resolvedCall = (ResolvedCall)bindingContext2.get((ReadOnlySlice)BindingContext.RESOLVED_CALL, (Object)call2);
                this.checkResolveCall(resolvedCall);
            }

            public void visitDestructuringDeclaration(@NotNull KtDestructuringDeclaration destructuringDeclaration) {
                Intrinsics.checkParameterIsNotNull((Object)destructuringDeclaration, (String)"destructuringDeclaration");
                super.visitDestructuringDeclaration(destructuringDeclaration);
                BindingContext bindingContext2 = ResolutionFacade.DefaultImpls.analyze$default((ResolutionFacade)this.$resolutionFacade, (KtElement)((KtElement)destructuringDeclaration), null, (int)2, null);
                this.$innerContexts.add(bindingContext2);
                for (KtDestructuringDeclarationEntry entry : destructuringDeclaration.getEntries()) {
                    ResolvedCall resolvedCall = (ResolvedCall)bindingContext2.get((ReadOnlySlice)BindingContext.COMPONENT_RESOLVED_CALL, (Object)entry);
                    this.checkResolveCall(resolvedCall);
                }
            }

            public void visitForExpression(@NotNull KtForExpression expression) {
                Intrinsics.checkParameterIsNotNull((Object)expression, (String)"expression");
                super.visitForExpression(expression);
                BindingContext bindingContext2 = ResolutionFacade.DefaultImpls.analyze$default((ResolutionFacade)this.$resolutionFacade, (KtElement)((KtElement)expression), null, (int)2, null);
                this.$innerContexts.add(bindingContext2);
                this.checkResolveCall((ResolvedCall)bindingContext2.get((ReadOnlySlice)BindingContext.LOOP_RANGE_ITERATOR_RESOLVED_CALL, (Object)expression.getLoopRange()));
                this.checkResolveCall((ResolvedCall)bindingContext2.get((ReadOnlySlice)BindingContext.LOOP_RANGE_HAS_NEXT_RESOLVED_CALL, (Object)expression.getLoopRange()));
                this.checkResolveCall((ResolvedCall)bindingContext2.get((ReadOnlySlice)BindingContext.LOOP_RANGE_NEXT_RESOLVED_CALL, (Object)expression.getLoopRange()));
            }

            private final void checkResolveCall(ResolvedCall<?> resolvedCall) {
                block6: {
                    CallableDescriptor descriptor2;
                    block7: {
                        if (resolvedCall == null) {
                            return;
                        }
                        descriptor2 = resolvedCall.getResultingDescriptor();
                        if (descriptor2 instanceof DeserializedSimpleFunctionDescriptor) {
                            return;
                        }
                        if (!InlineUtil.isInline((DeclarationDescriptor)((DeclarationDescriptor)descriptor2))) break block6;
                        if (this.$analyzeInlineFunctions) break block7;
                        CallableDescriptor callableDescriptor = descriptor2;
                        Intrinsics.checkExpressionValueIsNotNull((Object)callableDescriptor, (String)"descriptor");
                        if (!DebuggerUtils.access$hasReifiedTypeParameters(DebuggerUtils.INSTANCE, callableDescriptor)) break block6;
                    }
                    CallableDescriptor callableDescriptor = descriptor2;
                    Intrinsics.checkExpressionValueIsNotNull((Object)callableDescriptor, (String)"descriptor");
                    PsiElement declaration2 = DescriptorToSourceUtilsIde.INSTANCE.getAnyDeclaration(this.$project, (DeclarationDescriptor)callableDescriptor);
                    if (declaration2 != null && declaration2 instanceof KtNamedFunction && !this.$analyzedElements.contains(declaration2)) {
                        this.$inlineFunctions.add(declaration2);
                    }
                }
            }
            {
                this.$resolutionFacade = $captured_local_variable$0;
                this.$innerContexts = $captured_local_variable$1;
                this.$analyzeInlineFunctions = $captured_local_variable$2;
                this.$project = $captured_local_variable$3;
                this.$analyzedElements = $captured_local_variable$4;
                this.$inlineFunctions = $captured_local_variable$5;
            }
        });
        analyzedElements.add(element);
        if (!inlineFunctions.isEmpty() && deep < 10) {
            Iterator iterator = inlineFunctions.iterator();
            while (iterator.hasNext()) {
                KtNamedFunction inlineFunction;
                KtNamedFunction ktNamedFunction = inlineFunction = (KtNamedFunction)iterator.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)ktNamedFunction, (String)"inlineFunction");
                KtExpression body = ktNamedFunction.getBodyExpression();
                if (body == null) continue;
                innerContexts.add(DebuggerUtils.analyzeElementWithInline$default(this, resolutionFacade, (KtElement)inlineFunction, deep + 1, analyzedElements, analyzeInlineFunctions, null, 32, null));
            }
            analyzedElements.addAll(inlineFunctions);
        }
        return CompositeBindingContext.Companion.create((List)innerContexts);
    }

    static /* synthetic */ BindingContext analyzeElementWithInline$default(DebuggerUtils debuggerUtils, ResolutionFacade resolutionFacade, KtElement ktElement, int n, Set set, boolean bl, BindingContext bindingContext2, int n2, Object object) {
        if ((n2 & 0x20) != 0) {
            bindingContext2 = null;
        }
        return debuggerUtils.analyzeElementWithInline(resolutionFacade, ktElement, n, set, bl, bindingContext2);
    }

    private final boolean hasReifiedTypeParameters(CallableDescriptor descriptor2) {
        boolean bl;
        block3: {
            List list2 = descriptor2.getTypeParameters();
            Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"descriptor.typeParameters");
            Iterable $receiver$iv = list2;
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $receiver$iv) {
                    TypeParameterDescriptor it;
                    TypeParameterDescriptor typeParameterDescriptor = it = (TypeParameterDescriptor)element$iv;
                    Intrinsics.checkExpressionValueIsNotNull((Object)typeParameterDescriptor, (String)"it");
                    if (!typeParameterDescriptor.isReified()) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private DebuggerUtils() {
    }

    static {
        DebuggerUtils debuggerUtils;
        INSTANCE = debuggerUtils = new DebuggerUtils();
    }

    @NotNull
    public static final /* synthetic */ List access$findFilesByNameInPackage(DebuggerUtils $this, @NotNull JvmClassName className, @NotNull String fileName, @NotNull Project project, @NotNull GlobalSearchScope searchScope) {
        return $this.findFilesByNameInPackage(className, fileName, project, searchScope);
    }

    public static final /* synthetic */ boolean access$hasReifiedTypeParameters(DebuggerUtils $this, @NotNull CallableDescriptor descriptor2) {
        return $this.hasReifiedTypeParameters(descriptor2);
    }
}

