/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.sequence.psi.collections;

import com.intellij.debugger.streams.trace.impl.handler.type.ArrayType;
import com.intellij.debugger.streams.trace.impl.handler.type.GenericType;
import com.intellij.openapi.diagnostic.Logger;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.sequence.psi.CallTypeExtractor;
import org.jetbrains.kotlin.idea.debugger.sequence.psi.KotlinPsiUtil;
import org.jetbrains.kotlin.idea.debugger.sequence.trace.dsl.KotlinSequenceTypes;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0012\u0010\u0007\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0014J\u0010\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0014J\u0012\u0010\n\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/sequence/psi/collections/KotlinCollectionsTypeExtractor;", "Lorg/jetbrains/kotlin/idea/debugger/sequence/psi/CallTypeExtractor$Base;", "()V", "defaultType", "Lcom/intellij/debugger/streams/trace/impl/handler/type/GenericType;", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "extractItemsType", "getAny", "getResultType", "tryToFindElementType", "Companion", "idea-jvm"})
public final class KotlinCollectionsTypeExtractor
extends CallTypeExtractor.Base {
    @NotNull
    private static final Logger LOG;
    private static final Companion Companion;

    @Override
    @NotNull
    protected GenericType extractItemsType(@Nullable KotlinType type) {
        if (type == null) {
            return KotlinSequenceTypes.INSTANCE.getNULLABLE_ANY();
        }
        GenericType genericType = this.tryToFindElementType(type);
        if (genericType == null) {
            genericType = this.defaultType(type);
        }
        return genericType;
    }

    @Override
    @NotNull
    protected GenericType getResultType(@NotNull KotlinType type) {
        GenericType genericType;
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        String typeName = KotlinPsiUtil.INSTANCE.getTypeWithoutTypeParameters(type);
        GenericType genericType2 = KotlinSequenceTypes.INSTANCE.primitiveTypeByName(typeName);
        if (genericType2 == null) {
            genericType2 = genericType = (GenericType)KotlinSequenceTypes.INSTANCE.primitiveArrayByName(typeName);
        }
        if (genericType2 == null) {
            genericType = this.getAny(type);
        }
        return genericType;
    }

    private final GenericType tryToFindElementType(KotlinType type) {
        String typeName = KotlinPsiUtil.INSTANCE.getTypeWithoutTypeParameters(type);
        if (Intrinsics.areEqual((Object)typeName, (Object)"kotlin.collections.Iterable") || Intrinsics.areEqual((Object)typeName, (Object)"kotlin.Array")) {
            if (type.getArguments().isEmpty()) {
                return KotlinSequenceTypes.INSTANCE.getNULLABLE_ANY();
            }
            KotlinType kotlinType = ((TypeProjection)CollectionsKt.first((List)type.getArguments())).getType();
            Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"type.arguments.first().type");
            KotlinType itemsType = kotlinType;
            if (itemsType.isMarkedNullable()) {
                return KotlinSequenceTypes.INSTANCE.getNULLABLE_ANY();
            }
            GenericType primitiveType = KotlinSequenceTypes.INSTANCE.primitiveTypeByName(KotlinPsiUtil.INSTANCE.getTypeWithoutTypeParameters(itemsType));
            GenericType genericType = primitiveType;
            if (genericType == null) {
                genericType = KotlinSequenceTypes.INSTANCE.getANY();
            }
            return genericType;
        }
        if (Intrinsics.areEqual((Object)typeName, (Object)"kotlin.String") || Intrinsics.areEqual((Object)typeName, (Object)"kotlin.CharSequence")) {
            return KotlinSequenceTypes.INSTANCE.getCHAR();
        }
        ArrayType primitiveArray = KotlinSequenceTypes.INSTANCE.primitiveArrayByName(typeName);
        if (primitiveArray != null) {
            return primitiveArray.getElementType();
        }
        return (GenericType)SequencesKt.firstOrNull((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)TypeUtilsKt.supertypes((KotlinType)type)), (Function1)((Function1)new Function1<KotlinType, GenericType>(this){

            @Nullable
            public final GenericType invoke(@NotNull KotlinType p1) {
                Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                return KotlinCollectionsTypeExtractor.access$tryToFindElementType((KotlinCollectionsTypeExtractor)this.receiver, p1);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(KotlinCollectionsTypeExtractor.class);
            }

            public final String getName() {
                return "tryToFindElementType";
            }

            public final String getSignature() {
                return "tryToFindElementType(Lorg/jetbrains/kotlin/types/KotlinType;)Lcom/intellij/debugger/streams/trace/impl/handler/type/GenericType;";
            }
        })));
    }

    private final GenericType defaultType(KotlinType type) {
        LOG.warn("Could not find type of items for type " + KotlinPsiUtil.INSTANCE.getTypeName(type));
        return this.getAny(type);
    }

    private final GenericType getAny(KotlinType type) {
        return type.isMarkedNullable() ? KotlinSequenceTypes.INSTANCE.getNULLABLE_ANY() : KotlinSequenceTypes.INSTANCE.getANY();
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(KotlinCollectionsTypeExtractor.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(Kotli\u2026ypeExtractor::class.java)");
        LOG = logger;
    }

    @Nullable
    public static final /* synthetic */ GenericType access$tryToFindElementType(KotlinCollectionsTypeExtractor $this, @NotNull KotlinType type) {
        return $this.tryToFindElementType(type);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/sequence/psi/collections/KotlinCollectionsTypeExtractor$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "idea-jvm"})
    private static final class Companion {
        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

