/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.scratch.actions;

import com.intellij.icons.AllIcons;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileStatusNotification;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.scratch.ScratchExecutor;
import org.jetbrains.kotlin.idea.scratch.ScratchFile;
import org.jetbrains.kotlin.idea.scratch.ScratchFileLanguageProvider;
import org.jetbrains.kotlin.idea.scratch.ScratchUtilsKt;
import org.jetbrains.kotlin.idea.scratch.actions.RunScratchAction;
import org.jetbrains.kotlin.idea.scratch.actions.ScratchAction;
import org.jetbrains.kotlin.idea.scratch.output.ScratchOutputHandler;
import org.jetbrains.kotlin.idea.scratch.output.ScratchOutputHandlerAdapter;
import org.jetbrains.kotlin.idea.scratch.ui.ScratchTopPanel;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/scratch/actions/RunScratchAction;", "Lorg/jetbrains/kotlin/idea/scratch/actions/ScratchAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "idea-jvm"})
public final class RunScratchAction
extends ScratchAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"e.project ?: return");
        Project project2 = project;
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        if (editor == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)editor, (String)"e.getData(CommonDataKeys.EDITOR) ?: return");
        Editor editor2 = editor;
        ScratchTopPanel scratchTopPanel = this.getScratchPanel(editor2);
        if (scratchTopPanel == null) {
            return;
        }
        ScratchTopPanel scratchPanel = scratchTopPanel;
        ScratchFile scratchFile = scratchPanel.getScratchFile();
        PsiFile psiFile = scratchFile.getPsiFile();
        if (psiFile == null) {
            return;
        }
        PsiFile psiFile2 = psiFile;
        boolean isMakeBeforeRun = scratchPanel.isMakeBeforeRun();
        boolean isRepl = scratchPanel.isRepl();
        Language language = psiFile2.getLanguage();
        Intrinsics.checkExpressionValueIsNotNull((Object)language, (String)"psiFile.language");
        ScratchFileLanguageProvider scratchFileLanguageProvider = ScratchFileLanguageProvider.Companion.get(language);
        if (scratchFileLanguageProvider == null) {
            return;
        }
        ScratchFileLanguageProvider provider = scratchFileLanguageProvider;
        ScratchOutputHandler handler = provider.getOutputHandler();
        handler.onStart(scratchFile);
        ScratchUtilsKt.printDebugMessage(ScratchUtilsKt.getLOG(), "Run Action: isMakeBeforeRun = " + isMakeBeforeRun + ", isRepl = " + isRepl);
        Module module = scratchPanel.getModule();
        if (module == null) {
            handler.error(scratchFile, "Module should be selected");
            handler.onFinish(scratchFile);
            return;
        }
        Function0<Unit> executeScratch$ = new Function0<Unit>(isRepl, provider, scratchFile, handler, psiFile2, e){
            final /* synthetic */ boolean $isRepl;
            final /* synthetic */ ScratchFileLanguageProvider $provider;
            final /* synthetic */ ScratchFile $scratchFile;
            final /* synthetic */ ScratchOutputHandler $handler;
            final /* synthetic */ PsiFile $psiFile;
            final /* synthetic */ AnActionEvent $e;

            public final void invoke() {
                ScratchExecutor executor;
                ScratchExecutor scratchExecutor = executor = this.$isRepl ? this.$provider.createReplExecutor(this.$scratchFile) : this.$provider.createCompilingExecutor(this.$scratchFile);
                if (executor == null) {
                    this.$handler.error(this.$scratchFile, "Couldn't run " + this.$psiFile.getName());
                    this.$handler.onFinish(this.$scratchFile);
                    return;
                }
                Presentation presentation = this.$e.getPresentation();
                Intrinsics.checkExpressionValueIsNotNull((Object)presentation, (String)"e.presentation");
                presentation.setEnabled(false);
                executor.addOutputHandler(this.$handler);
                executor.addOutputHandler(new ScratchOutputHandlerAdapter(this){
                    final /* synthetic */ actionPerformed.1 this$0;

                    public void onFinish(@NotNull ScratchFile file2) {
                        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
                        Presentation presentation = this.this$0.$e.getPresentation();
                        Intrinsics.checkExpressionValueIsNotNull((Object)presentation, (String)"e.presentation");
                        presentation.setEnabled(true);
                    }
                    {
                        this.this$0 = $outer;
                    }
                });
                try {
                    executor.execute();
                }
                catch (Throwable ex) {
                    this.$handler.error(this.$scratchFile, "Exception occurs during Run Scratch Action");
                    this.$handler.onFinish(this.$scratchFile);
                    Presentation presentation2 = this.$e.getPresentation();
                    Intrinsics.checkExpressionValueIsNotNull((Object)presentation2, (String)"e.presentation");
                    presentation2.setEnabled(true);
                    ScratchUtilsKt.getLOG().error(ex);
                }
            }
            {
                this.$isRepl = bl;
                this.$provider = scratchFileLanguageProvider;
                this.$scratchFile = scratchFile;
                this.$handler = scratchOutputHandler;
                this.$psiFile = psiFile;
                this.$e = anActionEvent;
                super(0);
            }
        };
        if (isMakeBeforeRun) {
            CompilerManager.getInstance((Project)project2).make(module, new CompileStatusNotification(handler, scratchFile, module, project2, executeScratch$){
                final /* synthetic */ ScratchOutputHandler $handler;
                final /* synthetic */ ScratchFile $scratchFile;
                final /* synthetic */ Module $module;
                final /* synthetic */ Project $project;
                final /* synthetic */ actionPerformed.1 $executeScratch$1;

                public final void finished(boolean aborted, int errors, int $noName_2, @NotNull CompileContext $noName_3) {
                    Intrinsics.checkParameterIsNotNull((Object)$noName_3, (String)"<anonymous parameter 3>");
                    if (aborted || errors > 0) {
                        this.$handler.error(this.$scratchFile, "There were compilation errors in module " + this.$module.getName());
                    }
                    if (DumbService.isDumb((Project)this.$project)) {
                        DumbService.getInstance((Project)this.$project).smartInvokeLater(new Runnable(this){
                            final /* synthetic */ actionPerformed.2 this$0;

                            public final void run() {
                                this.this$0.$executeScratch$1.invoke();
                            }
                            {
                                this.this$0 = var1_1;
                            }
                        });
                    } else {
                        this.$executeScratch$1.invoke();
                    }
                }
                {
                    this.$handler = scratchOutputHandler;
                    this.$scratchFile = scratchFile;
                    this.$module = module;
                    this.$project = project;
                    this.$executeScratch$1 = var5_5;
                }
            });
        } else {
            executeScratch$.invoke();
        }
    }

    public RunScratchAction() {
        block0: {
            Shortcut shortcut;
            String string = KotlinBundle.message((String)"scratch.run.button", (Object[])new Object[0]);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"KotlinBundle.message(\"scratch.run.button\")");
            Icon icon = AllIcons.Actions.Execute;
            Intrinsics.checkExpressionValueIsNotNull((Object)icon, (String)"AllIcons.Actions.Execute");
            super(string, icon);
            KeymapManager keymapManager = KeymapManager.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)keymapManager, (String)"KeymapManager.getInstance()");
            Object[] objectArray = keymapManager.getActiveKeymap().getShortcuts("Kotlin.RunScratch");
            Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"KeymapManager.getInstanc\u2026cuts(\"Kotlin.RunScratch\")");
            Shortcut shortcut2 = (Shortcut)ArraysKt.firstOrNull((Object[])objectArray);
            if (shortcut2 == null) break block0;
            Shortcut it = shortcut = shortcut2;
            Presentation presentation = this.getTemplatePresentation();
            Intrinsics.checkExpressionValueIsNotNull((Object)presentation, (String)"templatePresentation");
            presentation.setText(presentation.getText() + " (" + KeymapUtil.getShortcutText((Shortcut)it) + ')');
        }
    }
}

