/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.job;

import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.i18n.I18N;
import com.oracle.javafx.scenebuilder.kit.editor.job.BatchSelectionJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.InsertAsSubComponentJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.Job;
import com.oracle.javafx.scenebuilder.kit.editor.job.SetDocumentRootJob;
import com.oracle.javafx.scenebuilder.kit.editor.selection.AbstractSelectionGroup;
import com.oracle.javafx.scenebuilder.kit.editor.selection.ObjectSelectionGroup;
import com.oracle.javafx.scenebuilder.kit.editor.selection.Selection;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMDocument;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMNodes;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import com.oracle.javafx.scenebuilder.kit.metadata.util.DesignHierarchyMask;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class ImportFileJob
extends BatchSelectionJob {
    private final File file;
    private FXOMObject newObject;
    private FXOMObject targetObject;

    public ImportFileJob(File file, EditorController editorController) {
        super(editorController);
        assert (file != null);
        this.file = file;
    }

    public FXOMObject getTargetObject() {
        return this.targetObject;
    }

    @Override
    protected List<Job> makeSubJobs() {
        ArrayList<Job> result = new ArrayList<Job>();
        FXOMDocument targetDocument = this.getEditorController().getFxomDocument();
        try {
            this.newObject = FXOMNodes.newObject(targetDocument, this.file);
            if (this.newObject != null) {
                FXOMObject rootObject = targetDocument.getFxomRoot();
                if (rootObject == null) {
                    result.add(new SetDocumentRootJob(this.newObject, this.getEditorController()));
                } else {
                    Selection selection = this.getEditorController().getSelection();
                    this.targetObject = selection.isEmpty() || selection.isSelected(rootObject) ? rootObject : selection.getAncestor();
                    DesignHierarchyMask targetMask = new DesignHierarchyMask(this.targetObject);
                    if (targetMask.isAcceptingSubComponent(this.newObject)) {
                        result.add(new InsertAsSubComponentJob(this.newObject, this.targetObject, targetMask.getSubComponentCount(), this.getEditorController()));
                    }
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    @Override
    protected String makeDescription() {
        return I18N.getString("import.from.file", this.file.getName());
    }

    @Override
    protected AbstractSelectionGroup getNewSelectionGroup() {
        ArrayList<FXOMObject> fxomObjects = new ArrayList<FXOMObject>();
        fxomObjects.add(this.newObject);
        return new ObjectSelectionGroup(fxomObjects, this.newObject, null);
    }
}

