/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.job;

import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.job.BatchSelectionJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.Job;
import com.oracle.javafx.scenebuilder.kit.editor.job.PrunePropertiesJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.atomic.AddPropertyJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.atomic.AddPropertyValueJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.atomic.RemovePropertyJob;
import com.oracle.javafx.scenebuilder.kit.editor.selection.AbstractSelectionGroup;
import com.oracle.javafx.scenebuilder.kit.editor.selection.ObjectSelectionGroup;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMCollection;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMDocument;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMInstance;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMProperty;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMPropertyC;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMPropertyT;
import com.oracle.javafx.scenebuilder.kit.metadata.util.DesignHierarchyMask;
import com.oracle.javafx.scenebuilder.kit.metadata.util.PropertyName;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public class InsertAsSubComponentJob
extends BatchSelectionJob {
    private final FXOMObject newObject;
    private final FXOMObject targetObject;
    private final int targetIndex;

    public InsertAsSubComponentJob(FXOMObject newObject, FXOMObject targetObject, int targetIndex, EditorController editorController) {
        super(editorController);
        assert (newObject != null);
        assert (targetObject != null);
        assert (targetIndex >= -1);
        assert (newObject.getFxomDocument() == this.getEditorController().getFxomDocument());
        assert (targetObject.getFxomDocument() == this.getEditorController().getFxomDocument());
        this.newObject = newObject;
        this.targetObject = targetObject;
        this.targetIndex = targetIndex;
    }

    @Override
    protected List<Job> makeSubJobs() {
        List<Job> result;
        boolean executable;
        if (this.targetObject instanceof FXOMInstance) {
            DesignHierarchyMask mask = new DesignHierarchyMask(this.targetObject);
            executable = mask.isAcceptingSubComponent(this.newObject);
        } else {
            executable = false;
        }
        if (executable) {
            PrunePropertiesJob pruneJob;
            FXOMDocument fxomDocument = this.targetObject.getFxomDocument();
            FXOMInstance targetInstance = (FXOMInstance)this.targetObject;
            DesignHierarchyMask mask = new DesignHierarchyMask(this.targetObject);
            PropertyName subComponentName = mask.getSubComponentPropertyName();
            assert (subComponentName != null);
            FXOMProperty currentProperty = targetInstance.getProperties().get(subComponentName);
            FXOMPropertyC targetProperty = currentProperty instanceof FXOMPropertyC ? (FXOMPropertyC)currentProperty : new FXOMPropertyC(fxomDocument, subComponentName);
            result = new ArrayList<Job>();
            if (currentProperty instanceof FXOMPropertyT) {
                result.add(new RemovePropertyJob(currentProperty, this.getEditorController()));
            }
            AddPropertyValueJob addValueJob = new AddPropertyValueJob(this.newObject, targetProperty, this.targetIndex, this.getEditorController());
            result.add(addValueJob);
            if (targetProperty.getParentInstance() == null) {
                assert (this.targetObject instanceof FXOMInstance);
                AddPropertyJob addPropertyJob = new AddPropertyJob(targetProperty, targetInstance, -1, this.getEditorController());
                result.add(addPropertyJob);
            }
            if (((Job)(pruneJob = new PrunePropertiesJob(this.newObject, this.targetObject, this.getEditorController()))).isExecutable()) {
                result.add(0, pruneJob);
            }
        } else {
            result = Collections.emptyList();
        }
        return result;
    }

    @Override
    protected String makeDescription() {
        StringBuilder sb = new StringBuilder();
        sb.append("Insert ");
        if (this.newObject instanceof FXOMInstance) {
            Object sceneGraphObject = this.newObject.getSceneGraphObject();
            if (sceneGraphObject != null) {
                sb.append(sceneGraphObject.getClass().getSimpleName());
            } else {
                sb.append("Unresolved Object");
            }
        } else if (this.newObject instanceof FXOMCollection) {
            sb.append("Collection");
        } else {
            assert (false);
            sb.append(this.newObject.getClass().getSimpleName());
        }
        return sb.toString();
    }

    @Override
    protected AbstractSelectionGroup getNewSelectionGroup() {
        HashSet<FXOMObject> newObjects = new HashSet<FXOMObject>();
        newObjects.add(this.newObject);
        return new ObjectSelectionGroup(newObjects, this.newObject, null);
    }
}

