/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.job;

import com.oracle.javafx.scenebuilder.kit.fxom.FXOMDocument;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMInstance;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMProperty;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMPropertyC;
import com.oracle.javafx.scenebuilder.kit.metadata.Metadata;
import com.oracle.javafx.scenebuilder.kit.metadata.klass.ComponentClassMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.property.PropertyMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.property.value.BooleanPropertyMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.property.value.DoublePropertyMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.property.value.EnumerationPropertyMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.util.PropertyName;

public class JobUtils {
    public static void addColumnConstraints(FXOMDocument fxomDocument, FXOMInstance gridPane, FXOMInstance constraints, int index) {
        PropertyName propertyName = new PropertyName("columnConstraints");
        FXOMProperty property = gridPane.getProperties().get(propertyName);
        if (property == null) {
            property = new FXOMPropertyC(fxomDocument, propertyName);
        }
        if (property.getParentInstance() == null) {
            property.addToParentInstance(-1, gridPane);
        }
        assert (property instanceof FXOMPropertyC);
        constraints.addToParentProperty(index, (FXOMPropertyC)property);
    }

    public static void addRowConstraints(FXOMDocument fxomDocument, FXOMInstance gridPane, FXOMInstance constraints, int index) {
        PropertyName propertyName = new PropertyName("rowConstraints");
        FXOMProperty property = gridPane.getProperties().get(propertyName);
        if (property == null) {
            property = new FXOMPropertyC(fxomDocument, propertyName);
        }
        if (property.getParentInstance() == null) {
            property.addToParentInstance(-1, gridPane);
        }
        assert (property instanceof FXOMPropertyC);
        constraints.addToParentProperty(index, (FXOMPropertyC)property);
    }

    public static boolean getFillHeight(FXOMInstance instance, Class<?> clazz) {
        assert (instance != null && clazz != null);
        assert (clazz.isAssignableFrom(instance.getDeclaredClass()));
        PropertyMetadata propertyMeta = JobUtils.getPropertyMetadata(clazz, "fillHeight");
        assert (propertyMeta instanceof BooleanPropertyMetadata);
        return (Boolean)((BooleanPropertyMetadata)propertyMeta).getValue(instance);
    }

    public static void setFillHeight(FXOMInstance instance, Class<?> clazz, boolean value) {
        assert (instance != null && clazz != null);
        assert (clazz.isAssignableFrom(instance.getDeclaredClass()));
        PropertyMetadata propertyMeta = JobUtils.getPropertyMetadata(clazz, "fillHeight");
        assert (propertyMeta instanceof BooleanPropertyMetadata);
        ((BooleanPropertyMetadata)propertyMeta).setValue(instance, value);
    }

    public static boolean getFillWidth(FXOMInstance instance, Class<?> clazz) {
        assert (instance != null && clazz != null);
        assert (clazz.isAssignableFrom(instance.getDeclaredClass()));
        PropertyMetadata propertyMeta = JobUtils.getPropertyMetadata(clazz, "fillWidth");
        assert (propertyMeta instanceof BooleanPropertyMetadata);
        return (Boolean)((BooleanPropertyMetadata)propertyMeta).getValue(instance);
    }

    public static void setFillWidth(FXOMInstance instance, Class<?> clazz, boolean value) {
        assert (instance != null && clazz != null);
        assert (clazz.isAssignableFrom(instance.getDeclaredClass()));
        PropertyMetadata propertyMeta = JobUtils.getPropertyMetadata(clazz, "fillWidth");
        assert (propertyMeta instanceof BooleanPropertyMetadata);
        ((BooleanPropertyMetadata)propertyMeta).setValue(instance, value);
    }

    public static String getHAlignment(FXOMInstance instance, Class<?> clazz) {
        assert (instance != null && clazz != null);
        assert (clazz.isAssignableFrom(instance.getDeclaredClass()));
        PropertyName propertyName = new PropertyName("halignment");
        FXOMProperty property = instance.getProperties().get(propertyName);
        if (property == null) {
            return null;
        }
        PropertyMetadata propertyMeta = JobUtils.getPropertyMetadata(clazz, "halignment");
        assert (propertyMeta instanceof EnumerationPropertyMetadata);
        return ((EnumerationPropertyMetadata)propertyMeta).getValue(instance);
    }

    public static void setHAlignment(FXOMInstance instance, Class<?> clazz, String value) {
        assert (instance != null && clazz != null);
        assert (clazz.isAssignableFrom(instance.getDeclaredClass()));
        PropertyMetadata propertyMeta = JobUtils.getPropertyMetadata(clazz, "halignment");
        assert (propertyMeta instanceof EnumerationPropertyMetadata);
        if (value != null) {
            ((EnumerationPropertyMetadata)propertyMeta).setValue(instance, value);
        }
    }

    public static String getHGrow(FXOMInstance instance, Class<?> clazz) {
        assert (instance != null && clazz != null);
        assert (clazz.isAssignableFrom(instance.getDeclaredClass()));
        PropertyName propertyName = new PropertyName("hgrow");
        FXOMProperty property = instance.getProperties().get(propertyName);
        if (property == null) {
            return null;
        }
        PropertyMetadata propertyMeta = JobUtils.getPropertyMetadata(clazz, "hgrow");
        assert (propertyMeta instanceof EnumerationPropertyMetadata);
        return ((EnumerationPropertyMetadata)propertyMeta).getValue(instance);
    }

    public static void setHGrow(FXOMInstance instance, Class<?> clazz, String value) {
        assert (instance != null && clazz != null);
        assert (clazz.isAssignableFrom(instance.getDeclaredClass()));
        PropertyMetadata propertyMeta = JobUtils.getPropertyMetadata(clazz, "hgrow");
        assert (propertyMeta instanceof EnumerationPropertyMetadata);
        if (value != null) {
            ((EnumerationPropertyMetadata)propertyMeta).setValue(instance, value);
        }
    }

    public static void setLayoutX(FXOMInstance instance, Class<?> clazz, double value) {
        assert (instance != null && clazz != null);
        assert (clazz.isAssignableFrom(instance.getDeclaredClass()));
        PropertyMetadata propertyMeta = JobUtils.getPropertyMetadata(clazz, "layoutX");
        assert (propertyMeta instanceof DoublePropertyMetadata);
        ((DoublePropertyMetadata)propertyMeta).setValue(instance, value);
    }

    public static void setLayoutY(FXOMInstance instance, Class<?> clazz, double value) {
        assert (instance != null && clazz != null);
        assert (clazz.isAssignableFrom(instance.getDeclaredClass()));
        PropertyMetadata propertyMeta = JobUtils.getPropertyMetadata(clazz, "layoutY");
        assert (propertyMeta instanceof DoublePropertyMetadata);
        ((DoublePropertyMetadata)propertyMeta).setValue(instance, value);
    }

    public static double getMaxHeight(FXOMInstance instance, Class<?> clazz) {
        assert (instance != null && clazz != null);
        assert (clazz.isAssignableFrom(instance.getDeclaredClass()));
        PropertyMetadata propertyMeta = JobUtils.getPropertyMetadata(clazz, "maxHeight");
        assert (propertyMeta instanceof DoublePropertyMetadata);
        return (Double)((DoublePropertyMetadata)propertyMeta).getValue(instance);
    }

    public static void setMaxHeight(FXOMInstance instance, Class<?> clazz, double value) {
        assert (instance != null && clazz != null);
        assert (clazz.isAssignableFrom(instance.getDeclaredClass()));
        PropertyMetadata propertyMeta = JobUtils.getPropertyMetadata(clazz, "maxHeight");
        assert (propertyMeta instanceof DoublePropertyMetadata);
        ((DoublePropertyMetadata)propertyMeta).setValue(instance, value);
    }

    public static double getMaxWidth(FXOMInstance instance, Class<?> clazz) {
        assert (instance != null && clazz != null);
        assert (clazz.isAssignableFrom(instance.getDeclaredClass()));
        PropertyMetadata propertyMeta = JobUtils.getPropertyMetadata(clazz, "maxWidth");
        assert (propertyMeta instanceof DoublePropertyMetadata);
        return (Double)((DoublePropertyMetadata)propertyMeta).getValue(instance);
    }

    public static void setMaxWidth(FXOMInstance instance, Class<?> clazz, double value) {
        assert (instance != null && clazz != null);
        assert (clazz.isAssignableFrom(instance.getDeclaredClass()));
        PropertyMetadata propertyMeta = JobUtils.getPropertyMetadata(clazz, "maxWidth");
        assert (propertyMeta instanceof DoublePropertyMetadata);
        ((DoublePropertyMetadata)propertyMeta).setValue(instance, value);
    }

    public static double getMinHeight(FXOMInstance instance, Class<?> clazz) {
        assert (instance != null && clazz != null);
        assert (clazz.isAssignableFrom(instance.getDeclaredClass()));
        PropertyMetadata propertyMeta = JobUtils.getPropertyMetadata(clazz, "minHeight");
        assert (propertyMeta instanceof DoublePropertyMetadata);
        return (Double)((DoublePropertyMetadata)propertyMeta).getValue(instance);
    }

    public static void setMinHeight(FXOMInstance instance, Class<?> clazz, double value) {
        assert (instance != null && clazz != null);
        assert (clazz.isAssignableFrom(instance.getDeclaredClass()));
        PropertyMetadata propertyMeta = JobUtils.getPropertyMetadata(clazz, "minHeight");
        assert (propertyMeta instanceof DoublePropertyMetadata);
        ((DoublePropertyMetadata)propertyMeta).setValue(instance, value);
    }

    public static double getMinWidth(FXOMInstance instance, Class<?> clazz) {
        assert (instance != null && clazz != null);
        assert (clazz.isAssignableFrom(instance.getDeclaredClass()));
        PropertyMetadata propertyMeta = JobUtils.getPropertyMetadata(clazz, "minWidth");
        assert (propertyMeta instanceof DoublePropertyMetadata);
        return (Double)((DoublePropertyMetadata)propertyMeta).getValue(instance);
    }

    public static void setMinWidth(FXOMInstance instance, Class<?> clazz, double value) {
        assert (instance != null && clazz != null);
        assert (clazz.isAssignableFrom(instance.getDeclaredClass()));
        PropertyMetadata propertyMeta = JobUtils.getPropertyMetadata(clazz, "minWidth");
        assert (propertyMeta instanceof DoublePropertyMetadata);
        ((DoublePropertyMetadata)propertyMeta).setValue(instance, value);
    }

    public static void setOrientation(FXOMInstance instance, Class<?> clazz, String value) {
        assert (instance != null && clazz != null);
        assert (clazz.isAssignableFrom(instance.getDeclaredClass()));
        PropertyMetadata propertyMeta = JobUtils.getPropertyMetadata(clazz, "orientation");
        assert (propertyMeta instanceof EnumerationPropertyMetadata);
        if (value != null) {
            ((EnumerationPropertyMetadata)propertyMeta).setValue(instance, value);
        }
    }

    public static double getPercentHeight(FXOMInstance instance, Class<?> clazz) {
        assert (instance != null && clazz != null);
        assert (clazz.isAssignableFrom(instance.getDeclaredClass()));
        PropertyMetadata propertyMeta = JobUtils.getPropertyMetadata(clazz, "percentHeight");
        assert (propertyMeta instanceof DoublePropertyMetadata);
        return (Double)((DoublePropertyMetadata)propertyMeta).getValue(instance);
    }

    public static void setPercentHeight(FXOMInstance instance, Class<?> clazz, double value) {
        assert (instance != null && clazz != null);
        assert (clazz.isAssignableFrom(instance.getDeclaredClass()));
        PropertyMetadata propertyMeta = JobUtils.getPropertyMetadata(clazz, "percentHeight");
        assert (propertyMeta instanceof DoublePropertyMetadata);
        ((DoublePropertyMetadata)propertyMeta).setValue(instance, value);
    }

    public static double getPercentWidth(FXOMInstance instance, Class<?> clazz) {
        assert (instance != null && clazz != null);
        assert (clazz.isAssignableFrom(instance.getDeclaredClass()));
        PropertyMetadata propertyMeta = JobUtils.getPropertyMetadata(clazz, "percentWidth");
        assert (propertyMeta instanceof DoublePropertyMetadata);
        return (Double)((DoublePropertyMetadata)propertyMeta).getValue(instance);
    }

    public static void setPercentWidth(FXOMInstance instance, Class<?> clazz, double value) {
        assert (instance != null && clazz != null);
        assert (clazz.isAssignableFrom(instance.getDeclaredClass()));
        PropertyMetadata propertyMeta = JobUtils.getPropertyMetadata(clazz, "percentWidth");
        assert (propertyMeta instanceof DoublePropertyMetadata);
        ((DoublePropertyMetadata)propertyMeta).setValue(instance, value);
    }

    public static double getPrefHeight(FXOMInstance instance, Class<?> clazz) {
        assert (instance != null && clazz != null);
        assert (clazz.isAssignableFrom(instance.getDeclaredClass()));
        PropertyMetadata propertyMeta = JobUtils.getPropertyMetadata(clazz, "prefHeight");
        assert (propertyMeta instanceof DoublePropertyMetadata);
        return (Double)((DoublePropertyMetadata)propertyMeta).getValue(instance);
    }

    public static void setPrefHeight(FXOMInstance instance, Class<?> clazz, double value) {
        assert (instance != null && clazz != null);
        assert (clazz.isAssignableFrom(instance.getDeclaredClass()));
        PropertyMetadata propertyMeta = JobUtils.getPropertyMetadata(clazz, "prefHeight");
        assert (propertyMeta instanceof DoublePropertyMetadata);
        ((DoublePropertyMetadata)propertyMeta).setValue(instance, value);
    }

    public static void setPrefViewportHeight(FXOMInstance instance, Class<?> clazz, double value) {
        assert (instance != null && clazz != null);
        assert (clazz.isAssignableFrom(instance.getDeclaredClass()));
        PropertyMetadata propertyMeta = JobUtils.getPropertyMetadata(clazz, "prefViewportHeight");
        assert (propertyMeta instanceof DoublePropertyMetadata);
        ((DoublePropertyMetadata)propertyMeta).setValue(instance, value);
    }

    public static void setPrefViewportWidth(FXOMInstance instance, Class<?> clazz, double value) {
        assert (instance != null && clazz != null);
        assert (clazz.isAssignableFrom(instance.getDeclaredClass()));
        PropertyMetadata propertyMeta = JobUtils.getPropertyMetadata(clazz, "prefViewportWidth");
        assert (propertyMeta instanceof DoublePropertyMetadata);
        ((DoublePropertyMetadata)propertyMeta).setValue(instance, value);
    }

    public static double getPrefWidth(FXOMInstance instance, Class<?> clazz) {
        assert (instance != null && clazz != null);
        assert (clazz.isAssignableFrom(instance.getDeclaredClass()));
        PropertyMetadata propertyMeta = JobUtils.getPropertyMetadata(clazz, "prefWidth");
        assert (propertyMeta instanceof DoublePropertyMetadata);
        return (Double)((DoublePropertyMetadata)propertyMeta).getValue(instance);
    }

    public static void setPrefWidth(FXOMInstance instance, Class<?> clazz, double value) {
        assert (instance != null && clazz != null);
        assert (clazz.isAssignableFrom(instance.getDeclaredClass()));
        PropertyMetadata propertyMeta = JobUtils.getPropertyMetadata(clazz, "prefWidth");
        assert (propertyMeta instanceof DoublePropertyMetadata);
        ((DoublePropertyMetadata)propertyMeta).setValue(instance, value);
    }

    public static String getVAlignment(FXOMInstance instance, Class<?> clazz) {
        assert (instance != null && clazz != null);
        assert (clazz.isAssignableFrom(instance.getDeclaredClass()));
        PropertyName propertyName = new PropertyName("valignment");
        FXOMProperty property = instance.getProperties().get(propertyName);
        if (property == null) {
            return null;
        }
        PropertyMetadata propertyMeta = JobUtils.getPropertyMetadata(clazz, "valignment");
        assert (propertyMeta instanceof EnumerationPropertyMetadata);
        return ((EnumerationPropertyMetadata)propertyMeta).getValue(instance);
    }

    public static void setVAlignment(FXOMInstance instance, Class<?> clazz, String value) {
        assert (instance != null && clazz != null);
        assert (clazz.isAssignableFrom(instance.getDeclaredClass()));
        PropertyMetadata propertyMeta = JobUtils.getPropertyMetadata(clazz, "valignment");
        assert (propertyMeta instanceof EnumerationPropertyMetadata);
        if (value != null) {
            ((EnumerationPropertyMetadata)propertyMeta).setValue(instance, value);
        }
    }

    public static String getVGrow(FXOMInstance instance, Class<?> clazz) {
        assert (instance != null && clazz != null);
        assert (clazz.isAssignableFrom(instance.getDeclaredClass()));
        PropertyName propertyName = new PropertyName("vgrow");
        FXOMProperty property = instance.getProperties().get(propertyName);
        if (property == null) {
            return null;
        }
        PropertyMetadata propertyMeta = JobUtils.getPropertyMetadata(clazz, "vgrow");
        assert (propertyMeta instanceof EnumerationPropertyMetadata);
        return ((EnumerationPropertyMetadata)propertyMeta).getValue(instance);
    }

    public static void setVGrow(FXOMInstance instance, Class<?> clazz, String value) {
        assert (instance != null && clazz != null);
        assert (clazz.isAssignableFrom(instance.getDeclaredClass()));
        PropertyMetadata propertyMeta = JobUtils.getPropertyMetadata(clazz, "vgrow");
        assert (propertyMeta instanceof EnumerationPropertyMetadata);
        if (value != null) {
            ((EnumerationPropertyMetadata)propertyMeta).setValue(instance, value);
        }
    }

    public static String getStringFromDouble(double value) {
        String res = Double.toString(value);
        if (res.endsWith(".0")) {
            res = Integer.toString((int)value);
        }
        return res;
    }

    private static PropertyMetadata getPropertyMetadata(Class<?> componentClass, String name) {
        ComponentClassMetadata componentClassMetadata = Metadata.getMetadata().queryComponentMetadata(componentClass);
        PropertyName propertyName = new PropertyName(name);
        return componentClassMetadata.lookupProperty(propertyName);
    }
}

