/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.job.atomic;

import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.job.Job;
import com.oracle.javafx.scenebuilder.kit.editor.job.atomic.RemovePropertyJob;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMPropertyC;

public class RemovePropertyValueJob
extends Job {
    private final FXOMObject targetValue;
    private FXOMPropertyC parentProperty;
    private int indexInParentProperty;
    private RemovePropertyJob removePropertyJob;

    public RemovePropertyValueJob(FXOMObject value, EditorController editorController) {
        super(editorController);
        this.targetValue = value;
    }

    @Override
    public boolean isExecutable() {
        return this.targetValue.getParentProperty() != null;
    }

    @Override
    public void execute() {
        assert (this.parentProperty == null);
        assert (this.isExecutable());
        this.parentProperty = this.targetValue.getParentProperty();
        this.indexInParentProperty = this.targetValue.getIndexInParentProperty();
        if (this.parentProperty.getValues().size() == 1 && this.parentProperty.getParentInstance() != null) {
            this.removePropertyJob = new RemovePropertyJob(this.parentProperty, this.getEditorController());
        }
        this.getEditorController().getFxomDocument().beginUpdate();
        if (this.removePropertyJob != null) {
            this.removePropertyJob.execute();
        }
        this.targetValue.removeFromParentProperty();
        this.getEditorController().getFxomDocument().endUpdate();
    }

    @Override
    public void undo() {
        assert (this.targetValue.getParentProperty() == null);
        this.getEditorController().getFxomDocument().beginUpdate();
        this.targetValue.addToParentProperty(this.indexInParentProperty, this.parentProperty);
        if (this.removePropertyJob != null) {
            this.removePropertyJob.undo();
        }
        this.getEditorController().getFxomDocument().endUpdate();
        assert (this.targetValue.getParentProperty() == this.parentProperty);
        assert (this.targetValue.getIndexInParentProperty() == this.indexInParentProperty);
    }

    @Override
    public void redo() {
        assert (this.targetValue.getParentProperty() == this.parentProperty);
        assert (this.targetValue.getIndexInParentProperty() == this.indexInParentProperty);
        this.getEditorController().getFxomDocument().beginUpdate();
        if (this.removePropertyJob != null) {
            this.removePropertyJob.redo();
        }
        this.targetValue.removeFromParentProperty();
        this.getEditorController().getFxomDocument().endUpdate();
        assert (this.targetValue.getParentProperty() == null);
    }

    @Override
    public String getDescription() {
        return this.getClass().getSimpleName() + "[" + this.targetValue.getGlueElement().getTagName() + "]";
    }
}

