/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.pring;

import com.oracle.javafx.scenebuilder.kit.editor.panel.content.ContentPanelController;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.pring.AbstractPring;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import javafx.collections.ObservableList;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.paint.Paint;
import javafx.scene.shape.ClosePath;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;

public abstract class AbstractGenericPring<T>
extends AbstractPring<T> {
    protected final Path ringPath = new Path();
    private final MoveTo moveTo0 = new MoveTo();
    private final LineTo lineTo1 = new LineTo();
    private final LineTo lineTo2 = new LineTo();
    private final LineTo lineTo3 = new LineTo();

    public AbstractGenericPring(ContentPanelController contentPanelController, FXOMObject fxomObject, Class<T> sceneGraphClass) {
        super(contentPanelController, fxomObject, sceneGraphClass);
        ObservableList ringElements = this.ringPath.getElements();
        ringElements.add(this.moveTo0);
        ringElements.add(this.lineTo1);
        ringElements.add(this.lineTo2);
        ringElements.add(this.lineTo3);
        ringElements.add(new ClosePath());
        this.ringPath.getStyleClass().add((Object)"parent-ring");
        this.getRootNode().getChildren().add((Object)this.ringPath);
        this.attachPring((Node)this.ringPath);
    }

    @Override
    protected void layoutDecoration() {
        Bounds b = this.getSceneGraphObjectBounds();
        boolean snapToPixel = true;
        Point2D p0 = this.sceneGraphObjectToDecoration(b.getMinX(), b.getMinY(), true);
        Point2D p1 = this.sceneGraphObjectToDecoration(b.getMaxX(), b.getMinY(), true);
        Point2D p2 = this.sceneGraphObjectToDecoration(b.getMaxX(), b.getMaxY(), true);
        Point2D p3 = this.sceneGraphObjectToDecoration(b.getMinX(), b.getMaxY(), true);
        this.moveTo0.setX(p0.getX());
        this.moveTo0.setY(p0.getY());
        this.lineTo1.setX(p1.getX());
        this.lineTo1.setY(p1.getY());
        this.lineTo2.setX(p2.getX());
        this.lineTo2.setY(p2.getY());
        this.lineTo3.setX(p3.getX());
        this.lineTo3.setY(p3.getY());
    }

    @Override
    public void changeStroke(Paint stroke) {
        this.ringPath.setStroke(stroke);
    }

    private void attachPring(Node node) {
        AbstractGenericPring.attachPring(node, this);
    }
}

