/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.resizer;

import com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.resizer.AbstractResizer;
import com.oracle.javafx.scenebuilder.kit.metadata.util.PropertyName;
import com.oracle.javafx.scenebuilder.kit.util.MathUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.geometry.BoundingBox;
import javafx.geometry.Bounds;
import javafx.scene.image.ImageView;

public class ImageViewResizer
extends AbstractResizer<ImageView> {
    private final double originalFitWidth;
    private final double originalFitHeight;
    private final PropertyName fitWidthName = new PropertyName("fitWidth");
    private final PropertyName fitHeightName = new PropertyName("fitHeight");
    private final List<PropertyName> propertyNames = new ArrayList<PropertyName>();

    public ImageViewResizer(ImageView sceneGraphObject) {
        super(sceneGraphObject);
        this.originalFitWidth = sceneGraphObject.getFitWidth();
        this.originalFitHeight = sceneGraphObject.getFitHeight();
        this.propertyNames.add(this.fitWidthName);
        this.propertyNames.add(this.fitHeightName);
    }

    @Override
    public final Bounds computeBounds(double width, double height) {
        double minX = ((ImageView)this.sceneGraphObject).getX();
        double minY = ((ImageView)this.sceneGraphObject).getY();
        double actualWidth = width > 0.0 ? width : 1.0;
        double actualHeight = height > 0.0 ? height : 1.0;
        return new BoundingBox(minX, minY, (double)Math.round(actualWidth), (double)Math.round(actualHeight));
    }

    @Override
    public AbstractResizer.Feature getFeature() {
        return AbstractResizer.Feature.FREE;
    }

    @Override
    public void changeWidth(double width) {
        ((ImageView)this.sceneGraphObject).setFitWidth((double)Math.round(width));
    }

    @Override
    public void changeHeight(double height) {
        ((ImageView)this.sceneGraphObject).setFitHeight((double)Math.round(height));
    }

    @Override
    public void revertToOriginalSize() {
        ((ImageView)this.sceneGraphObject).setFitWidth(this.originalFitWidth);
        ((ImageView)this.sceneGraphObject).setFitHeight(this.originalFitHeight);
    }

    @Override
    public List<PropertyName> getPropertyNames() {
        return this.propertyNames;
    }

    @Override
    public Object getValue(PropertyName propertyName) {
        assert (propertyName != null);
        assert (this.propertyNames.contains(propertyName));
        Double result = propertyName.equals(this.fitWidthName) ? Double.valueOf(((ImageView)this.sceneGraphObject).getFitWidth()) : (propertyName.equals(this.fitHeightName) ? Double.valueOf(((ImageView)this.sceneGraphObject).getFitHeight()) : null);
        return result;
    }

    @Override
    public Map<PropertyName, Object> getChangeMap() {
        HashMap<PropertyName, Object> result = new HashMap<PropertyName, Object>();
        if (!MathUtils.equals(((ImageView)this.sceneGraphObject).getFitWidth(), this.originalFitWidth)) {
            result.put(this.fitWidthName, ((ImageView)this.sceneGraphObject).getFitWidth());
        }
        if (!MathUtils.equals(((ImageView)this.sceneGraphObject).getFitHeight(), this.originalFitHeight)) {
            result.put(this.fitHeightName, ((ImageView)this.sceneGraphObject).getFitHeight());
        }
        return result;
    }
}

