/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.resizer.shape;

import com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.resizer.AbstractResizer;
import com.oracle.javafx.scenebuilder.kit.metadata.util.PropertyName;
import com.oracle.javafx.scenebuilder.kit.util.MathUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.geometry.BoundingBox;
import javafx.geometry.Bounds;
import javafx.scene.text.Text;

public class TextResizer
extends AbstractResizer<Text> {
    private final double originalWrappingWidth;
    private final PropertyName wrappingWidthName = new PropertyName("wrappingWidth");
    private final List<PropertyName> propertyNames = new ArrayList<PropertyName>();

    public TextResizer(Text sceneGraphObject) {
        super(sceneGraphObject);
        this.originalWrappingWidth = sceneGraphObject.getWrappingWidth();
        this.propertyNames.add(this.wrappingWidthName);
    }

    @Override
    public final Bounds computeBounds(double width, double height) {
        double minX = ((Text)this.sceneGraphObject).getX();
        double minY = ((Text)this.sceneGraphObject).getY();
        return new BoundingBox(minX, minY, width, height);
    }

    @Override
    public AbstractResizer.Feature getFeature() {
        return AbstractResizer.Feature.WIDTH_ONLY;
    }

    @Override
    public void changeWidth(double width) {
        ((Text)this.sceneGraphObject).setWrappingWidth(Math.max(1.0, width));
    }

    @Override
    public void changeHeight(double height) {
    }

    @Override
    public void revertToOriginalSize() {
        ((Text)this.sceneGraphObject).setWrappingWidth(this.originalWrappingWidth);
    }

    @Override
    public List<PropertyName> getPropertyNames() {
        return this.propertyNames;
    }

    @Override
    public Object getValue(PropertyName propertyName) {
        assert (propertyName != null);
        assert (this.propertyNames.contains(propertyName));
        Double result = propertyName.equals(this.wrappingWidthName) ? Double.valueOf(((Text)this.sceneGraphObject).getWrappingWidth()) : null;
        return result;
    }

    @Override
    public Map<PropertyName, Object> getChangeMap() {
        HashMap<PropertyName, Object> result = new HashMap<PropertyName, Object>();
        if (!MathUtils.equals(((Text)this.sceneGraphObject).getWrappingWidth(), this.originalWrappingWidth)) {
            result.put(this.wrappingWidthName, ((Text)this.sceneGraphObject).getWrappingWidth());
        }
        return result;
    }
}

