/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.content.gesture.mouse;

import com.oracle.javafx.scenebuilder.kit.editor.panel.content.ContentPanelController;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.AbstractDriver;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.pring.AbstractPring;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.gesture.mouse.AbstractMouseGesture;
import com.oracle.javafx.scenebuilder.kit.editor.selection.Selection;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMDocument;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import com.oracle.javafx.scenebuilder.kit.metadata.util.DesignHierarchyMask;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javafx.geometry.BoundingBox;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.scene.Group;
import javafx.scene.input.KeyEvent;
import javafx.scene.shape.Rectangle;

public class SelectWithMarqueeGesture
extends AbstractMouseGesture {
    private FXOMObject hitObject;
    private FXOMObject scopeObject;
    private AbstractPring<?> scopeHilit;
    private final Set<FXOMObject> candidates = new HashSet<FXOMObject>();
    private final Rectangle marqueeRect = new Rectangle();

    public SelectWithMarqueeGesture(ContentPanelController contentPanelController) {
        super(contentPanelController);
    }

    public void setup(FXOMObject hitObject, FXOMObject scopeObject) {
        assert (hitObject == null || !hitObject.isDescendantOf(scopeObject));
        this.hitObject = hitObject;
        this.scopeObject = scopeObject;
        this.marqueeRect.getStyleClass().add((Object)"marquee");
    }

    public FXOMObject getHitObject() {
        return this.hitObject;
    }

    @Override
    protected void mousePressed() {
    }

    @Override
    protected void mouseDragStarted() {
        this.contentPanelController.getEditorController().getSelection().clear();
        this.collectCandidates();
        this.showScopeHilit();
        this.showMarqueeRect();
    }

    @Override
    protected void mouseDragged() {
        this.updateMarqueeRect();
        this.updateSelection();
    }

    @Override
    protected void mouseDragEnded() {
        this.candidates.clear();
        this.hideScopeHilit();
        this.hideMarqueeRect();
    }

    @Override
    protected void mouseReleased() {
        if (!this.isMouseDidDrag()) {
            Selection selection = this.contentPanelController.getEditorController().getSelection();
            if (this.hitObject != null) {
                selection.select(this.hitObject);
            } else {
                selection.clear();
            }
        }
    }

    @Override
    protected void keyEvent(KeyEvent e) {
    }

    @Override
    protected void userDidCancel() {
    }

    private void showScopeHilit() {
        if (this.scopeObject != null) {
            AbstractDriver driver = this.contentPanelController.lookupDriver(this.scopeObject);
            Group rudderLayer = this.contentPanelController.getRudderLayer();
            assert (driver != null);
            this.scopeHilit = driver.makePring(this.scopeObject);
            this.scopeHilit.changeStroke(this.contentPanelController.getPringColor());
            rudderLayer.getChildren().add((Object)this.scopeHilit.getRootNode());
        }
    }

    private void hideScopeHilit() {
        if (this.scopeHilit != null) {
            Group rudderLayer = this.contentPanelController.getRudderLayer();
            assert (rudderLayer.getChildren().contains((Object)this.scopeHilit.getRootNode()));
            rudderLayer.getChildren().remove((Object)this.scopeHilit.getRootNode());
            this.scopeHilit = null;
        }
    }

    private void showMarqueeRect() {
        Group rudderLayer = this.contentPanelController.getRudderLayer();
        rudderLayer.getChildren().add((Object)this.marqueeRect);
        this.updateMarqueeRect();
    }

    private void updateMarqueeRect() {
        double xPressed = this.getMousePressedEvent().getSceneX();
        double yPressed = this.getMousePressedEvent().getSceneY();
        double xCurrent = this.getLastMouseEvent().getSceneX();
        double yCurrent = this.getLastMouseEvent().getSceneY();
        double xMin = Math.min(xPressed, xCurrent);
        double yMin = Math.min(yPressed, yCurrent);
        double xMax = Math.max(xPressed, xCurrent);
        double yMax = Math.max(yPressed, yCurrent);
        Group rudderLayer = this.contentPanelController.getRudderLayer();
        Point2D p0 = rudderLayer.sceneToLocal(xMin, yMin, true);
        Point2D p1 = rudderLayer.sceneToLocal(xMax, yMax, true);
        this.marqueeRect.setX(p0.getX());
        this.marqueeRect.setY(p0.getY());
        this.marqueeRect.setWidth(p1.getX() - p0.getX());
        this.marqueeRect.setHeight(p1.getY() - p0.getY());
    }

    private void hideMarqueeRect() {
        Group rudderLayer = this.contentPanelController.getRudderLayer();
        rudderLayer.getChildren().remove((Object)this.marqueeRect);
    }

    private void updateSelection() {
        double xPressed = this.getMousePressedEvent().getSceneX();
        double yPressed = this.getMousePressedEvent().getSceneY();
        double xCurrent = this.getLastMouseEvent().getSceneX();
        double yCurrent = this.getLastMouseEvent().getSceneY();
        double xMin = Math.min(xPressed, xCurrent);
        double yMin = Math.min(yPressed, yCurrent);
        double xMax = Math.max(xPressed, xCurrent);
        double yMax = Math.max(yPressed, yCurrent);
        BoundingBox marqueeBounds = new BoundingBox(xMin, yMin, xMax - xMin, yMax - yMin);
        HashSet<FXOMObject> winners = new HashSet<FXOMObject>();
        for (FXOMObject candidate : this.candidates) {
            AbstractDriver driver = this.contentPanelController.lookupDriver(candidate);
            if (driver == null || !driver.intersectsBounds(candidate, (Bounds)marqueeBounds)) continue;
            winners.add(candidate);
        }
        Selection selection = this.contentPanelController.getEditorController().getSelection();
        selection.select(winners);
    }

    private void collectCandidates() {
        block5: {
            block4: {
                if (this.scopeObject != null) break block4;
                FXOMDocument fxomDocument = this.contentPanelController.getEditorController().getFxomDocument();
                if (fxomDocument == null || fxomDocument.getFxomRoot() == null) break block5;
                this.candidates.add(fxomDocument.getFxomRoot());
                break block5;
            }
            DesignHierarchyMask m = new DesignHierarchyMask(this.scopeObject);
            if (m.isAcceptingSubComponent()) {
                int count = m.getSubComponentCount();
                for (int i = 0; i < count; ++i) {
                    this.candidates.add(m.getSubComponentAtIndex(i));
                }
            } else {
                List<DesignHierarchyMask.Accessory> accessories = Arrays.asList(DesignHierarchyMask.Accessory.CONTENT, DesignHierarchyMask.Accessory.CENTER, DesignHierarchyMask.Accessory.BOTTOM, DesignHierarchyMask.Accessory.TOP, DesignHierarchyMask.Accessory.LEFT, DesignHierarchyMask.Accessory.RIGHT, DesignHierarchyMask.Accessory.XAXIS, DesignHierarchyMask.Accessory.YAXIS);
                for (DesignHierarchyMask.Accessory accessory : accessories) {
                    FXOMObject fxomObject;
                    if (!m.isAcceptingAccessory(accessory) || (fxomObject = m.getAccessory(accessory)) == null) continue;
                    this.candidates.add(fxomObject);
                }
            }
        }
    }
}

