/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.popupeditors;

import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.popupeditors.PopupEditor;
import com.oracle.javafx.scenebuilder.kit.metadata.property.ValuePropertyMetadata;
import com.oracle.javafx.scenebuilder.kit.util.control.effectpicker.EffectPicker;
import com.oracle.javafx.scenebuilder.kit.util.control.effectpicker.Utils;
import com.oracle.javafx.scenebuilder.kit.util.control.paintpicker.PaintPicker;
import java.util.List;
import java.util.Set;
import javafx.beans.value.ChangeListener;
import javafx.scene.Node;
import javafx.scene.control.MenuItem;
import javafx.scene.effect.Effect;

public class EffectPopupEditor
extends PopupEditor {
    private EffectPicker effectPicker;
    private List<MenuItem> effectMenuItems;
    private EditorController editorController;
    private final ChangeListener<Number> effectRevisionChangeListener = (ov, t, t1) -> {
        Effect rootEffect = this.effectPicker.getRootEffectProperty();
        Effect rootEffectClone = Utils.clone(rootEffect);
        if (this.effectPicker.isLiveUpdate()) {
            this.userUpdateTransientValueProperty(rootEffectClone);
        } else {
            this.commitValue(rootEffectClone);
            this.updateMenuButton(rootEffectClone);
        }
    };
    private final ChangeListener<Boolean> liveUpdateListener = (ov, oldValue, newValue) -> {
        if (!this.effectPicker.isLiveUpdate()) {
            Effect rootEffect = this.effectPicker.getRootEffectProperty();
            Effect rootEffectClone = Utils.clone(rootEffect);
            this.commitValue(rootEffectClone);
            this.updateMenuButton(rootEffectClone);
        }
    };

    public EffectPopupEditor(ValuePropertyMetadata propMeta, Set<Class<?>> selectedClasses, EditorController editorController) {
        super(propMeta, selectedClasses);
        this.initialize(editorController);
    }

    private void initialize(EditorController editorController) {
        this.editorController = editorController;
    }

    @Override
    public void setPopupContentValue(Object value) {
        assert (value == null || value instanceof Effect);
        this.effectPicker.revisionProperty().removeListener(this.effectRevisionChangeListener);
        this.effectPicker.liveUpdateProperty().removeListener(this.liveUpdateListener);
        Effect rootEffectClone = Utils.clone((Effect)value);
        this.effectPicker.setRootEffectProperty(rootEffectClone);
        this.updateMenuButton(rootEffectClone);
        this.effectPicker.revisionProperty().addListener(this.effectRevisionChangeListener);
        this.effectPicker.liveUpdateProperty().addListener(this.liveUpdateListener);
    }

    @Override
    public void initializePopupContent() {
        EffectPicker.Delegate epd = (warningKey, arguments) -> this.editorController.getMessageLog().logWarningMessage(warningKey, arguments);
        PaintPicker.Delegate ppd = (warningKey, arguments) -> this.editorController.getMessageLog().logWarningMessage(warningKey, arguments);
        this.effectPicker = new EffectPicker(epd, ppd);
        this.effectMenuItems = this.effectPicker.getMenuItems();
    }

    @Override
    public String getPreviewString(Object value) {
        if (value == null) {
            return "+";
        }
        assert (value instanceof Effect);
        Effect effect = (Effect)value;
        StringBuilder sb = new StringBuilder();
        while (effect != null) {
            sb.append(effect.getClass().getSimpleName());
            if ((effect = Utils.getDefaultInput(effect)) == null) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    @Override
    public Node getPopupContentNode() {
        return this.effectPicker;
    }

    private void updateMenuButton(Effect value) {
        if (value != null) {
            if (!this.popupMb.getItems().contains((Object)this.popupMenuItem)) {
                this.popupMb.getItems().removeAll(this.effectMenuItems);
                this.popupMb.getItems().add((Object)this.popupMenuItem);
            }
        } else if (this.popupMb.getItems().contains((Object)this.popupMenuItem)) {
            this.popupMb.getItems().addAll(this.effectMenuItems);
            this.popupMb.getItems().remove((Object)this.popupMenuItem);
        }
    }
}

