/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.popupeditors;

import com.oracle.javafx.scenebuilder.kit.editor.i18n.I18N;
import com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.editors.DoubleField;
import com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.editors.EditorUtils;
import com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.popupeditors.PopupEditor;
import com.oracle.javafx.scenebuilder.kit.metadata.property.ValuePropertyMetadata;
import java.util.Set;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Control;

public class Rectangle2DPopupEditor
extends PopupEditor {
    @FXML
    DoubleField minXDf;
    @FXML
    DoubleField minYDf;
    @FXML
    DoubleField widthDf;
    @FXML
    DoubleField heightDf;
    DoubleField[] doubleFields = new DoubleField[4];
    private Parent root;
    private Rectangle2D rectangle2D;

    public Rectangle2DPopupEditor(ValuePropertyMetadata propMeta, Set<Class<?>> selectedClasses) {
        super(propMeta, selectedClasses);
    }

    @Override
    public Object getValue() {
        Double[] values = new Double[4];
        int index = 0;
        for (DoubleField doubleField : this.doubleFields) {
            String val = doubleField.getText();
            if (val == null || val.isEmpty()) {
                val = "0";
            } else {
                try {
                    Double.parseDouble(val);
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
            values[index] = Double.valueOf(val);
            ++index;
        }
        this.rectangle2D = new Rectangle2D(values[0].doubleValue(), values[1].doubleValue(), values[2].doubleValue(), values[3].doubleValue());
        return this.rectangle2D;
    }

    @Override
    public void initializePopupContent() {
        this.root = EditorUtils.loadPopupFxml("Rectangle2DPopupEditor.fxml", this);
        this.doubleFields[0] = this.minXDf;
        this.doubleFields[1] = this.minYDf;
        this.doubleFields[2] = this.widthDf;
        this.doubleFields[3] = this.heightDf;
        for (DoubleField doubleField : this.doubleFields) {
            EventHandler valueListener = event -> this.commitValue(this.getValue());
            this.setNumericEditorBehavior(this, (Control)doubleField, (EventHandler<ActionEvent>)valueListener, false);
        }
    }

    @Override
    public String getPreviewString(Object value) {
        if (value == null) {
            return I18N.getString("inspector.rectangle2D.not.defined");
        }
        assert (value instanceof Rectangle2D);
        Rectangle2D rectangle2DVal = (Rectangle2D)value;
        String valueAsString = this.isIndeterminate() ? "-" : EditorUtils.valAsStr(rectangle2DVal.getMinX()) + "," + EditorUtils.valAsStr(rectangle2DVal.getMinY()) + "  " + EditorUtils.valAsStr(rectangle2DVal.getWidth()) + "x" + EditorUtils.valAsStr(rectangle2DVal.getHeight());
        return valueAsString;
    }

    @Override
    public void setPopupContentValue(Object value) {
        if (value == null) {
            this.rectangle2D = null;
            for (DoubleField doubleField : this.doubleFields) {
                doubleField.setText("");
            }
        } else {
            assert (value instanceof Rectangle2D);
            this.rectangle2D = (Rectangle2D)value;
            this.minXDf.setText(EditorUtils.valAsStr(this.rectangle2D.getMinX()));
            this.minYDf.setText(EditorUtils.valAsStr(this.rectangle2D.getMinY()));
            this.widthDf.setText(EditorUtils.valAsStr(this.rectangle2D.getWidth()));
            this.heightDf.setText(EditorUtils.valAsStr(this.rectangle2D.getHeight()));
        }
    }

    @Override
    public Node getPopupContentNode() {
        return this.root;
    }
}

