/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.library.maven.search;

import com.oracle.javafx.scenebuilder.kit.editor.panel.library.maven.search.Search;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonReader;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.HttpClients;
import org.eclipse.aether.artifact.DefaultArtifact;

public class MavenSearch
implements Search {
    private static final String URL_PREFIX = "http://search.maven.org/solrsearch/select?q=";
    private static final String URL_SUFFIX = "&rows=200&wt=json";
    private static final String URL_PREFIX_FULLCLASS = "http://search.maven.org/solrsearch/select?q=fc:%22";
    private static final String URL_SUFFIX_FULLCLASS = "%22&rows=200&wt=json";
    private final HttpClient client = HttpClients.createDefault();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<DefaultArtifact> getCoordinates(String query) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("Repository", "Maven Central");
        try {
            HttpGet request = new HttpGet(URL_PREFIX + query + URL_SUFFIX);
            HttpResponse response = this.client.execute((HttpUriRequest)request);
            try (JsonReader rdr = Json.createReader((InputStream)response.getEntity().getContent());){
                JsonObject obj = rdr.readObject();
                if (obj == null) return null;
                if (obj.isEmpty()) return null;
                if (!obj.containsKey((Object)"response")) return null;
                JsonObject jsonResponse = obj.getJsonObject("response");
                if (jsonResponse == null) return null;
                if (jsonResponse.isEmpty()) return null;
                if (!jsonResponse.containsKey((Object)"docs")) return null;
                JsonArray docResults = jsonResponse.getJsonArray("docs");
                List<DefaultArtifact> list = docResults.getValuesAs(JsonObject.class).stream().map(doc -> doc.getString("id", "") + ":" + "[0,)").distinct().map(gav -> new DefaultArtifact(gav, map)).collect(Collectors.toList());
                return list;
            }
        }
        catch (IOException ex) {
            Logger.getLogger(MavenSearch.class.getName()).log(Level.SEVERE, null, ex);
        }
        return null;
    }
}

