/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.util;

import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMDocument;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.value.ChangeListener;
import javafx.collections.ObservableList;
import javafx.scene.Parent;

public abstract class AbstractPanelController {
    private static final Logger LOG = Logger.getLogger(AbstractPanelController.class.getName());
    private final EditorController editorController;
    private Parent panelRoot;
    private final ChangeListener<Number> fxomDocumentRevisionListener = (observable, oldValue, newValue) -> {
        try {
            this.sceneGraphRevisionDidChange();
        }
        catch (RuntimeException x) {
            LOG.log(Level.SEVERE, "Bug", x);
        }
    };
    private final ChangeListener<Number> cssRevisionListener = (observable, oldValue, newValue) -> {
        try {
            this.cssRevisionDidChange();
        }
        catch (RuntimeException x) {
            LOG.log(Level.SEVERE, "Bug", x);
        }
    };
    private final ChangeListener<Number> jobManagerRevisionListener = (observable, oldValue, newValue) -> {
        try {
            this.jobManagerRevisionDidChange();
        }
        catch (RuntimeException x) {
            LOG.log(Level.SEVERE, "Bug", x);
        }
    };
    private final ChangeListener<Number> editorSelectionListener = (observable, oldValue, newValue) -> {
        try {
            this.editorSelectionDidChange();
        }
        catch (RuntimeException x) {
            LOG.log(Level.SEVERE, "Bug", x);
        }
    };

    protected AbstractPanelController(EditorController c) {
        assert (c != null);
        this.editorController = c;
        this.startListeningToEditorSelection();
        this.startListeningToJobManagerRevision();
        this.editorController.fxomDocumentProperty().addListener((ov, od, nd) -> {
            assert (this.editorController.getFxomDocument() == nd);
            if (od != null) {
                od.sceneGraphRevisionProperty().removeListener(this.fxomDocumentRevisionListener);
                od.cssRevisionProperty().removeListener(this.cssRevisionListener);
            }
            try {
                this.fxomDocumentDidChange((FXOMDocument)od);
            }
            catch (RuntimeException x) {
                LOG.log(Level.SEVERE, "Bug", x);
            }
            if (nd != null) {
                nd.sceneGraphRevisionProperty().addListener(this.fxomDocumentRevisionListener);
                nd.cssRevisionProperty().addListener(this.cssRevisionListener);
            }
        });
        if (this.editorController.getFxomDocument() != null) {
            this.editorController.getFxomDocument().sceneGraphRevisionProperty().addListener(this.fxomDocumentRevisionListener);
            this.editorController.getFxomDocument().cssRevisionProperty().addListener(this.cssRevisionListener);
        }
        this.editorController.toolStylesheetProperty().addListener((ov, od, nd) -> this.toolStylesheetDidChange((String)od));
    }

    public EditorController getEditorController() {
        return this.editorController;
    }

    public Parent getPanelRoot() {
        if (this.panelRoot == null) {
            this.makePanel();
            assert (this.panelRoot != null);
            ObservableList stylesheets = this.panelRoot.getStylesheets();
            if (stylesheets.contains(EditorController.getBuiltinToolStylesheet())) {
                this.toolStylesheetDidChange(EditorController.getBuiltinToolStylesheet());
            } else {
                this.toolStylesheetDidChange(null);
            }
        }
        return this.panelRoot;
    }

    protected abstract void makePanel();

    protected abstract void fxomDocumentDidChange(FXOMDocument var1);

    protected abstract void sceneGraphRevisionDidChange();

    protected abstract void cssRevisionDidChange();

    protected abstract void jobManagerRevisionDidChange();

    protected abstract void editorSelectionDidChange();

    protected final void setPanelRoot(Parent panelRoot) {
        assert (panelRoot != null);
        this.panelRoot = panelRoot;
    }

    protected final void startListeningToEditorSelection() {
        this.editorController.getSelection().revisionProperty().addListener(this.editorSelectionListener);
    }

    protected final void stopListeningToEditorSelection() {
        this.editorController.getSelection().revisionProperty().removeListener(this.editorSelectionListener);
    }

    protected final void startListeningToJobManagerRevision() {
        this.editorController.getJobManager().revisionProperty().addListener(this.jobManagerRevisionListener);
    }

    protected final void stopListeningToJobManagerRevision() {
        this.editorController.getJobManager().revisionProperty().removeListener(this.jobManagerRevisionListener);
    }

    protected void toolStylesheetDidChange(String oldStylesheet) {
        if (this.panelRoot != null) {
            ObservableList stylesheets = this.panelRoot.getStylesheets();
            if (oldStylesheet != null) {
                stylesheets.remove(oldStylesheet);
            }
            stylesheets.add(this.editorController.getToolStylesheet());
        }
    }
}

