/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.fxom;

import com.oracle.javafx.scenebuilder.kit.fxom.FXOMDocument;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import com.oracle.javafx.scenebuilder.kit.fxom.glue.GlueAuxiliary;
import com.oracle.javafx.scenebuilder.kit.fxom.glue.GlueDocument;
import com.oracle.javafx.scenebuilder.kit.fxom.glue.GlueInstruction;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javafx.fxml.FXMLLoader;

class FXOMSaver {
    private static final String NAME_SPACE_FX = "http://javafx.com/javafx/" + FXMLLoader.JAVAFX_VERSION;
    private static final String NAME_SPACE_FXML = "http://javafx.com/fxml/1";

    FXOMSaver() {
    }

    public String save(FXOMDocument fxomDocument) {
        assert (fxomDocument != null);
        assert (fxomDocument.getGlue() != null);
        if (fxomDocument.getFxomRoot() != null) {
            this.updateNameSpace(fxomDocument);
            this.updateImportInstructions(fxomDocument);
        }
        return fxomDocument.getGlue().toString();
    }

    private void updateNameSpace(FXOMDocument fxomDocument) {
        assert (fxomDocument.getFxomRoot() != null);
        FXOMObject fxomRoot = fxomDocument.getFxomRoot();
        String currentNameSpaceFX = fxomRoot.getNameSpaceFX();
        String currentNameSpaceFXML = fxomRoot.getNameSpaceFXML();
        if (currentNameSpaceFX == null || !currentNameSpaceFX.equals(NAME_SPACE_FX)) {
            fxomRoot.setNameSpaceFX(NAME_SPACE_FX);
        }
        if (currentNameSpaceFXML == null || !currentNameSpaceFXML.equals(NAME_SPACE_FXML)) {
            fxomRoot.setNameSpaceFXML(NAME_SPACE_FXML);
        }
    }

    private void updateImportInstructions(FXOMDocument fxomDocument) {
        assert (fxomDocument.getFxomRoot() != null);
        List<GlueInstruction> importList = this.getHeaderIncludes(fxomDocument);
        this.synchronizeHeader(fxomDocument.getGlue(), importList);
    }

    private List<GlueInstruction> getHeaderIncludes(FXOMDocument fxomDocument) {
        TreeSet<String> imports = new TreeSet<String>();
        fxomDocument.getFxomRoot().collectDeclaredClasses().forEach(dc -> imports.add(dc.getCanonicalName()));
        FXOMObject root = fxomDocument.getFxomRoot();
        Set foundClasses = root.getChildObjects().stream().map(fxomObject -> fxomObject.collectPropertiesT()).flatMap(list -> list.stream()).map(property -> property.getName()).filter(prop -> prop.getResidenceClass() != null).map(prop -> prop.getResidenceClass().getName()).collect(Collectors.toSet());
        foundClasses.addAll(root.collectPropertiesT().stream().map(p -> p.getName()).filter(prop -> prop.getResidenceClass() != null).map(prop -> prop.getResidenceClass().getName()).collect(Collectors.toSet()));
        imports.addAll(foundClasses);
        return this.createGlueInstructionsForImports(fxomDocument, imports);
    }

    private List<GlueInstruction> createGlueInstructionsForImports(FXOMDocument fxomDocument, Set<String> imports) {
        ArrayList<GlueInstruction> importsList = new ArrayList<GlueInstruction>();
        imports.forEach(className -> {
            GlueInstruction instruction = new GlueInstruction(fxomDocument.getGlue(), "import", (String)className);
            importsList.add(instruction);
        });
        return importsList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void synchronizeHeader(GlueDocument glue, List<GlueInstruction> importList) {
        FXOMSaver fXOMSaver = this;
        synchronized (fXOMSaver) {
            int firstImportIndex;
            List<GlueInstruction> existingImports = glue.collectInstructions("import");
            if (existingImports.isEmpty()) {
                firstImportIndex = 0;
            } else {
                GlueInstruction firstImport = existingImports.get(0);
                firstImportIndex = glue.getHeader().indexOf(firstImport);
            }
            Iterator<GlueAuxiliary> it = glue.getHeader().iterator();
            while (it.hasNext()) {
                GlueAuxiliary glueAuxiliary = it.next();
                if (!(glueAuxiliary instanceof GlueInstruction) || !"import".equals(((GlueInstruction)glueAuxiliary).getTarget())) continue;
                it.remove();
            }
            glue.getHeader().addAll(firstImportIndex, importList);
        }
    }
}

