/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.metadata.property.value;

import com.oracle.javafx.scenebuilder.kit.fxom.FXOMDocument;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMInstance;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMProperty;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMPropertyT;
import com.oracle.javafx.scenebuilder.kit.metadata.property.value.TextEncodablePropertyMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.util.InspectorPath;
import com.oracle.javafx.scenebuilder.kit.metadata.util.PrefixedValue;
import com.oracle.javafx.scenebuilder.kit.metadata.util.PropertyName;
import com.oracle.javafx.scenebuilder.kit.util.URLUtils;
import java.net.URISyntaxException;
import java.net.URL;

public class StringPropertyMetadata
extends TextEncodablePropertyMetadata<String> {
    private static final PropertyName valueName = new PropertyName("value");
    private final boolean detectFileURL;

    public StringPropertyMetadata(PropertyName name, boolean readWrite, String defaultValue, InspectorPath inspectorPath, boolean detectFileURL) {
        super(name, String.class, readWrite, defaultValue, inspectorPath);
        this.detectFileURL = detectFileURL;
    }

    public StringPropertyMetadata(PropertyName name, boolean readWrite, String defaultValue, InspectorPath inspectorPath) {
        this(name, readWrite, defaultValue, inspectorPath, false);
    }

    @Override
    public String makeValueFromFxomInstance(FXOMInstance valueFxomInstance) {
        String result;
        Class<?> valueClass = valueFxomInstance.getDeclaredClass();
        if (valueClass == URL.class) {
            FXOMProperty p = valueFxomInstance.getProperties().get(valueName);
            if (p instanceof FXOMPropertyT) {
                result = ((FXOMPropertyT)p).getValue();
            } else {
                assert (false);
                result = (String)this.getDefaultValue();
            }
        } else {
            result = valueFxomInstance.getFxValue();
        }
        return result;
    }

    @Override
    public boolean canMakeStringFromValue(String value) {
        return true;
    }

    @Override
    public String makeValueFromString(String string) {
        return string;
    }

    @Override
    public FXOMInstance makeFxomInstanceFromValue(String value, FXOMDocument fxomDocument) {
        FXOMInstance result;
        boolean shouldEncodeAsURL;
        PrefixedValue pv = new PrefixedValue(value);
        if (pv.isClassLoaderRelativePath() || pv.isDocumentRelativePath()) {
            shouldEncodeAsURL = true;
        } else if (pv.isPlainString() && this.detectFileURL) {
            try {
                shouldEncodeAsURL = URLUtils.getFile(value) != null;
            }
            catch (URISyntaxException x) {
                shouldEncodeAsURL = false;
            }
        } else {
            shouldEncodeAsURL = false;
        }
        if (shouldEncodeAsURL) {
            FXOMPropertyT newProperty = new FXOMPropertyT(fxomDocument, valueName, value);
            result = new FXOMInstance(fxomDocument, URL.class);
            newProperty.addToParentInstance(-1, result);
        } else {
            result = new FXOMInstance(fxomDocument, String.class);
            result.setFxValue(value);
        }
        return result;
    }
}

