/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.util.control.effectpicker.editors;

import com.oracle.javafx.scenebuilder.kit.editor.EditorPlatform;
import com.oracle.javafx.scenebuilder.kit.editor.i18n.I18N;
import com.oracle.javafx.scenebuilder.kit.util.Deprecation;
import com.oracle.javafx.scenebuilder.kit.util.control.effectpicker.EffectPickerController;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.image.Image;
import javafx.scene.layout.GridPane;
import javafx.stage.FileChooser;

public class ImageControl
extends GridPane {
    @FXML
    private Button editor_button;
    @FXML
    private Label editor_label;
    @FXML
    private TextField editor_textfield;
    private final ObjectProperty<Image> value = new SimpleObjectProperty();
    private final EffectPickerController effectPickerController;

    public ImageControl(EffectPickerController effectPickerController, String labelString, Image initVal) {
        this.effectPickerController = effectPickerController;
        this.initialize(labelString, initVal);
        if (EditorPlatform.IS_MAC) {
            this.editor_button.setManaged(false);
            this.editor_button.setVisible(false);
        }
    }

    public ObjectProperty<Image> valueProperty() {
        return this.value;
    }

    public Image getValue() {
        return (Image)this.value.get();
    }

    public void setValue(Image image) {
        this.value.set((Object)image);
    }

    public Button getButton() {
        return this.editor_button;
    }

    public TextField getTextField() {
        return this.editor_textfield;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FXML
    void textfieldOnAction(ActionEvent e) {
        String location = this.editor_textfield.getText();
        try {
            URI uri = new URI(location);
            File file = new File(uri);
            if (file.exists()) {
                Image image = new Image(uri.toURL().toExternalForm());
                this.setValue(image);
                this.effectPickerController.incrementRevision();
            } else {
                this.effectPickerController.getEffectPickerDelegate().handleError("log.warning.image.location.does.not.exist", location);
            }
            this.editor_textfield.selectAll();
        }
        catch (MalformedURLException | URISyntaxException ex) {
            this.effectPickerController.getEffectPickerDelegate().handleError("log.warning.image.location.does.not.exist", location);
        }
        finally {
            e.consume();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FXML
    void buttonOnAction(ActionEvent e) {
        try {
            String[] extensions = new String[]{"*.jpg", "*.jpeg", "*.png", "*.gif"};
            FileChooser fileChooser = new FileChooser();
            fileChooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter(I18N.getString("inspector.select.image"), Arrays.asList(extensions)));
            File file = fileChooser.showOpenDialog(this.getScene().getWindow());
            if (file == null) {
                return;
            }
            String url = file.toURI().toURL().toExternalForm();
            Image image = new Image(url);
            this.setValue(image);
            this.effectPickerController.incrementRevision();
        }
        catch (MalformedURLException ex) {
            Logger.getLogger(ImageControl.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            e.consume();
        }
    }

    private void initialize(String labelString, Image initVal) {
        URL layoutURL = ImageControl.class.getResource("ImageControl.fxml");
        try (InputStream is = layoutURL.openStream();){
            FXMLLoader loader = new FXMLLoader();
            loader.setController((Object)this);
            loader.setRoot((Object)this);
            loader.setLocation(layoutURL);
            Parent p = (Parent)loader.load(is);
            assert (p == this);
        }
        catch (IOException x) {
            throw new RuntimeException(x);
        }
        this.editor_label.setText(labelString);
        this.editor_textfield.setText(initVal == null ? "" : Deprecation.getUrl(initVal));
        this.setValue(initVal);
    }
}

