/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.protocol;

import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.gradle.api.logging.LogLevel;
import org.gradle.configuration.GradleLauncherMetaData;
import org.gradle.initialization.BuildClientMetaData;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.classpath.DefaultClassPath;
import org.gradle.internal.invocation.BuildAction;
import org.gradle.internal.logging.events.LogEvent;
import org.gradle.internal.logging.events.LogLevelChangeEvent;
import org.gradle.internal.logging.events.OutputEvent;
import org.gradle.internal.logging.events.ProgressCompleteEvent;
import org.gradle.internal.logging.events.ProgressEvent;
import org.gradle.internal.logging.events.ProgressStartEvent;
import org.gradle.internal.logging.events.StyledTextOutputEvent;
import org.gradle.internal.logging.events.UserInputRequestEvent;
import org.gradle.internal.logging.events.UserInputResumeEvent;
import org.gradle.internal.logging.serializer.LogEventSerializer;
import org.gradle.internal.logging.serializer.LogLevelChangeEventSerializer;
import org.gradle.internal.logging.serializer.ProgressCompleteEventSerializer;
import org.gradle.internal.logging.serializer.ProgressEventSerializer;
import org.gradle.internal.logging.serializer.ProgressStartEventSerializer;
import org.gradle.internal.logging.serializer.SpanSerializer;
import org.gradle.internal.logging.serializer.StyledTextOutputEventSerializer;
import org.gradle.internal.logging.serializer.UserInputRequestEventSerializer;
import org.gradle.internal.logging.serializer.UserInputResumeEventSerializer;
import org.gradle.internal.logging.text.StyledTextOutput;
import org.gradle.internal.serialize.BaseSerializerFactory;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.DefaultSerializer;
import org.gradle.internal.serialize.DefaultSerializerRegistry;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.ListSerializer;
import org.gradle.internal.serialize.Serializer;
import org.gradle.launcher.daemon.diagnostics.DaemonDiagnostics;
import org.gradle.launcher.daemon.protocol.Build;
import org.gradle.launcher.daemon.protocol.BuildEvent;
import org.gradle.launcher.daemon.protocol.BuildStarted;
import org.gradle.launcher.daemon.protocol.Cancel;
import org.gradle.launcher.daemon.protocol.CloseInput;
import org.gradle.launcher.daemon.protocol.DaemonUnavailable;
import org.gradle.launcher.daemon.protocol.Failure;
import org.gradle.launcher.daemon.protocol.Finished;
import org.gradle.launcher.daemon.protocol.ForwardInput;
import org.gradle.launcher.daemon.protocol.Message;
import org.gradle.launcher.daemon.protocol.OutputMessage;
import org.gradle.launcher.daemon.protocol.Success;
import org.gradle.launcher.exec.BuildActionParameters;
import org.gradle.launcher.exec.DefaultBuildActionParameters;

public class DaemonMessageSerializer {
    public static Serializer<Message> create(Serializer<BuildAction> buildActionSerializer) {
        BaseSerializerFactory factory = new BaseSerializerFactory();
        Serializer logLevelSerializer = factory.getSerializerFor(LogLevel.class);
        Serializer throwableSerializer = factory.getSerializerFor(Throwable.class);
        DefaultSerializerRegistry registry = new DefaultSerializerRegistry();
        registry.register(Build.class, (Serializer)new BuildSerializer(buildActionSerializer));
        registry.register(Cancel.class, (Serializer)new CancelSerializer());
        registry.register(DaemonUnavailable.class, (Serializer)new DaemonUnavailableSerializer());
        registry.register(BuildStarted.class, (Serializer)new BuildStartedSerializer());
        registry.register(Failure.class, (Serializer)new FailureSerializer((Serializer<Throwable>)throwableSerializer));
        registry.register(Success.class, (Serializer)new SuccessSerializer());
        registry.register(Finished.class, (Serializer)new FinishedSerializer());
        registry.register(BuildEvent.class, (Serializer)new BuildEventSerializer());
        registry.register(ForwardInput.class, (Serializer)new ForwardInputSerializer());
        registry.register(CloseInput.class, (Serializer)new CloseInputSerializer());
        registry.register(LogEvent.class, (Serializer)new LogEventSerializer(logLevelSerializer, throwableSerializer));
        registry.register(UserInputRequestEvent.class, (Serializer)new UserInputRequestEventSerializer());
        registry.register(UserInputResumeEvent.class, (Serializer)new UserInputResumeEventSerializer());
        registry.register(StyledTextOutputEvent.class, (Serializer)new StyledTextOutputEventSerializer(logLevelSerializer, (Serializer)new ListSerializer((Serializer)new SpanSerializer(factory.getSerializerFor(StyledTextOutput.Style.class)))));
        registry.register(ProgressStartEvent.class, (Serializer)new ProgressStartEventSerializer());
        registry.register(ProgressCompleteEvent.class, (Serializer)new ProgressCompleteEventSerializer());
        registry.register(ProgressEvent.class, (Serializer)new ProgressEventSerializer());
        registry.register(LogLevelChangeEvent.class, (Serializer)new LogLevelChangeEventSerializer(logLevelSerializer));
        registry.register(OutputMessage.class, (Serializer)new OutputMessageSerializer((Serializer<OutputEvent>)registry.build(OutputEvent.class)));
        registry.useJavaSerialization(Message.class);
        return registry.build(Message.class);
    }

    private static class FinishedSerializer
    implements Serializer<Finished> {
        private FinishedSerializer() {
        }

        public Finished read(Decoder decoder) {
            return new Finished();
        }

        public void write(Encoder encoder, Finished value) {
        }
    }

    private static class BuildStartedSerializer
    implements Serializer<BuildStarted> {
        private BuildStartedSerializer() {
        }

        public void write(Encoder encoder, BuildStarted buildStarted) throws Exception {
            BaseSerializerFactory.FILE_SERIALIZER.write(encoder, (Object)buildStarted.getDiagnostics().getDaemonLog());
            if (buildStarted.getDiagnostics().getPid() == null) {
                encoder.writeBoolean(false);
            } else {
                encoder.writeBoolean(true);
                encoder.writeLong(buildStarted.getDiagnostics().getPid().longValue());
            }
        }

        public BuildStarted read(Decoder decoder) throws Exception {
            File log = (File)BaseSerializerFactory.FILE_SERIALIZER.read(decoder);
            boolean nonNull = decoder.readBoolean();
            Long pid = null;
            if (nonNull) {
                pid = decoder.readLong();
            }
            return new BuildStarted(new DaemonDiagnostics(log, pid));
        }
    }

    private static class CancelSerializer
    implements Serializer<Cancel> {
        private CancelSerializer() {
        }

        public void write(Encoder encoder, Cancel value) {
        }

        public Cancel read(Decoder decoder) {
            return new Cancel();
        }
    }

    private static class DaemonUnavailableSerializer
    implements Serializer<DaemonUnavailable> {
        private DaemonUnavailableSerializer() {
        }

        public void write(Encoder encoder, DaemonUnavailable value) throws Exception {
            encoder.writeNullableString((CharSequence)value.getReason());
        }

        public DaemonUnavailable read(Decoder decoder) throws Exception {
            return new DaemonUnavailable(decoder.readNullableString());
        }
    }

    private static class BuildActionParametersSerializer
    implements Serializer<BuildActionParameters> {
        private final Serializer<LogLevel> logLevelSerializer = new BaseSerializerFactory().getSerializerFor(LogLevel.class);
        private final Serializer<List<File>> classPathSerializer = new ListSerializer(BaseSerializerFactory.FILE_SERIALIZER);

        BuildActionParametersSerializer() {
        }

        public void write(Encoder encoder, BuildActionParameters parameters) throws Exception {
            BaseSerializerFactory.FILE_SERIALIZER.write(encoder, (Object)parameters.getCurrentDir());
            BaseSerializerFactory.NO_NULL_STRING_MAP_SERIALIZER.write(encoder, parameters.getSystemProperties());
            BaseSerializerFactory.NO_NULL_STRING_MAP_SERIALIZER.write(encoder, parameters.getEnvVariables());
            this.logLevelSerializer.write(encoder, (Object)parameters.getLogLevel());
            encoder.writeBoolean(parameters.isUseDaemon());
            encoder.writeBoolean(parameters.isContinuous());
            encoder.writeBoolean(parameters.isInteractive());
            this.classPathSerializer.write(encoder, (Object)parameters.getInjectedPluginClasspath().getAsFiles());
        }

        public BuildActionParameters read(Decoder decoder) throws Exception {
            File currentDir = (File)BaseSerializerFactory.FILE_SERIALIZER.read(decoder);
            Map sysProperties = (Map)BaseSerializerFactory.NO_NULL_STRING_MAP_SERIALIZER.read(decoder);
            Map envVariables = (Map)BaseSerializerFactory.NO_NULL_STRING_MAP_SERIALIZER.read(decoder);
            LogLevel logLevel = (LogLevel)this.logLevelSerializer.read(decoder);
            boolean useDaemon = decoder.readBoolean();
            boolean continuous = decoder.readBoolean();
            boolean interactive = decoder.readBoolean();
            ClassPath classPath = DefaultClassPath.of((Collection)((Collection)this.classPathSerializer.read(decoder)));
            return new DefaultBuildActionParameters(sysProperties, envVariables, currentDir, logLevel, useDaemon, continuous, interactive, classPath);
        }
    }

    private static class BuildSerializer
    implements Serializer<Build> {
        private final Serializer<BuildAction> buildActionSerializer;
        private final Serializer<BuildActionParameters> buildActionParametersSerializer = new BuildActionParametersSerializer();

        private BuildSerializer(Serializer<BuildAction> buildActionSerializer) {
            this.buildActionSerializer = buildActionSerializer;
        }

        public void write(Encoder encoder, Build build) throws Exception {
            encoder.writeLong(build.getIdentifier().getMostSignificantBits());
            encoder.writeLong(build.getIdentifier().getLeastSignificantBits());
            encoder.writeBinary(build.getToken());
            encoder.writeLong(build.getStartTime());
            this.buildActionSerializer.write(encoder, (Object)build.getAction());
            GradleLauncherMetaData metaData = (GradleLauncherMetaData)build.getBuildClientMetaData();
            encoder.writeString((CharSequence)metaData.getAppName());
            this.buildActionParametersSerializer.write(encoder, (Object)build.getParameters());
        }

        public Build read(Decoder decoder) throws Exception {
            UUID uuid = new UUID(decoder.readLong(), decoder.readLong());
            byte[] token = decoder.readBinary();
            long timestamp = decoder.readLong();
            BuildAction buildAction = (BuildAction)this.buildActionSerializer.read(decoder);
            GradleLauncherMetaData metaData = new GradleLauncherMetaData(decoder.readString());
            BuildActionParameters buildActionParameters = (BuildActionParameters)this.buildActionParametersSerializer.read(decoder);
            return new Build(uuid, token, buildAction, (BuildClientMetaData)metaData, timestamp, buildActionParameters);
        }
    }

    private static class OutputMessageSerializer
    implements Serializer<OutputMessage> {
        private final Serializer<OutputEvent> eventSerializer;

        OutputMessageSerializer(Serializer<OutputEvent> eventSerializer) {
            this.eventSerializer = eventSerializer;
        }

        public void write(Encoder encoder, OutputMessage message) throws Exception {
            this.eventSerializer.write(encoder, (Object)message.getEvent());
        }

        public OutputMessage read(Decoder decoder) throws Exception {
            return new OutputMessage((OutputEvent)this.eventSerializer.read(decoder));
        }
    }

    private static class CloseInputSerializer
    implements Serializer<CloseInput> {
        private CloseInputSerializer() {
        }

        public void write(Encoder encoder, CloseInput value) {
        }

        public CloseInput read(Decoder decoder) {
            return new CloseInput();
        }
    }

    private static class ForwardInputSerializer
    implements Serializer<ForwardInput> {
        private ForwardInputSerializer() {
        }

        public void write(Encoder encoder, ForwardInput message) throws Exception {
            encoder.writeBinary(message.getBytes());
        }

        public ForwardInput read(Decoder decoder) throws Exception {
            return new ForwardInput(decoder.readBinary());
        }
    }

    private static class BuildEventSerializer
    implements Serializer<BuildEvent> {
        private final Serializer<Object> payloadSerializer = new DefaultSerializer();

        private BuildEventSerializer() {
        }

        public void write(Encoder encoder, BuildEvent buildEvent) throws Exception {
            this.payloadSerializer.write(encoder, buildEvent.getPayload());
        }

        public BuildEvent read(Decoder decoder) throws Exception {
            return new BuildEvent(this.payloadSerializer.read(decoder));
        }
    }

    private static class FailureSerializer
    implements Serializer<Failure> {
        private final Serializer<Throwable> throwableSerializer;

        FailureSerializer(Serializer<Throwable> throwableSerializer) {
            this.throwableSerializer = throwableSerializer;
        }

        public void write(Encoder encoder, Failure failure) throws Exception {
            this.throwableSerializer.write(encoder, failure.getValue());
        }

        public Failure read(Decoder decoder) throws Exception {
            return new Failure((Throwable)this.throwableSerializer.read(decoder));
        }
    }

    private static class SuccessSerializer
    implements Serializer<Success> {
        private final Serializer<Object> payloadSerializer = new DefaultSerializer();

        private SuccessSerializer() {
        }

        public void write(Encoder encoder, Success success) throws Exception {
            if (success.getValue() == null) {
                encoder.writeBoolean(false);
            } else {
                encoder.writeBoolean(true);
                this.payloadSerializer.write(encoder, success.getValue());
            }
        }

        public Success read(Decoder decoder) throws Exception {
            boolean notNull = decoder.readBoolean();
            if (notNull) {
                return new Success(this.payloadSerializer.read(decoder));
            }
            return new Success((Object)null);
        }
    }
}

