/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.server.health.gc;

import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.util.List;
import java.util.Map;
import org.gradle.api.specs.Spec;
import org.gradle.launcher.daemon.server.health.gc.GarbageCollectionEvent;
import org.gradle.launcher.daemon.server.health.gc.SlidingWindow;
import org.gradle.util.CollectionUtils;

public class GarbageCollectionCheck
implements Runnable {
    final Map<String, SlidingWindow<GarbageCollectionEvent>> events;
    final List<String> memoryPools;
    final String garbageCollector;

    public GarbageCollectionCheck(Map<String, SlidingWindow<GarbageCollectionEvent>> events, List<String> memoryPools, String garbageCollector) {
        this.events = events;
        this.memoryPools = memoryPools;
        this.garbageCollector = garbageCollector;
    }

    @Override
    public void run() {
        List<GarbageCollectorMXBean> garbageCollectorMXBeans = ManagementFactory.getGarbageCollectorMXBeans();
        GarbageCollectorMXBean garbageCollectorMXBean = (GarbageCollectorMXBean)CollectionUtils.findFirst(garbageCollectorMXBeans, (Spec)new Spec<GarbageCollectorMXBean>(){

            public boolean isSatisfiedBy(GarbageCollectorMXBean mbean) {
                return mbean.getName().equals(GarbageCollectionCheck.this.garbageCollector);
            }
        });
        List<MemoryPoolMXBean> memoryPoolMXBeans = ManagementFactory.getMemoryPoolMXBeans();
        for (MemoryPoolMXBean memoryPoolMXBean : memoryPoolMXBeans) {
            String pool = memoryPoolMXBean.getName();
            if (!this.memoryPools.contains(pool)) continue;
            GarbageCollectionEvent event = new GarbageCollectionEvent(System.currentTimeMillis(), memoryPoolMXBean.getCollectionUsage(), garbageCollectorMXBean.getCollectionCount());
            this.events.get(pool).slideAndInsert(event);
        }
    }
}

