/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.provider.serialization;

import java.io.Closeable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Map;
import net.jcip.annotations.ThreadSafe;
import org.gradle.internal.IoActions;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.io.StreamByteBuffer;
import org.gradle.tooling.internal.provider.serialization.ClassLoaderDetails;
import org.gradle.tooling.internal.provider.serialization.DeserializeMap;
import org.gradle.tooling.internal.provider.serialization.PayloadClassLoaderRegistry;
import org.gradle.tooling.internal.provider.serialization.PayloadSerializerObjectInputStream;
import org.gradle.tooling.internal.provider.serialization.PayloadSerializerObjectOutputStream;
import org.gradle.tooling.internal.provider.serialization.SerializeMap;
import org.gradle.tooling.internal.provider.serialization.SerializedPayload;

@ThreadSafe
public class PayloadSerializer {
    private final PayloadClassLoaderRegistry classLoaderRegistry;

    public PayloadSerializer(PayloadClassLoaderRegistry registry) {
        this.classLoaderRegistry = registry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SerializedPayload serialize(Object payload) {
        SerializeMap map = this.classLoaderRegistry.newSerializeSession();
        try {
            StreamByteBuffer buffer = new StreamByteBuffer();
            PayloadSerializerObjectOutputStream objectStream = new PayloadSerializerObjectOutputStream(buffer.getOutputStream(), map);
            try {
                ((ObjectOutputStream)((Object)objectStream)).writeObject(payload);
            }
            finally {
                IoActions.closeQuietly((Closeable)((Object)objectStream));
            }
            HashMap<Short, ClassLoaderDetails> classLoaders = new HashMap<Short, ClassLoaderDetails>();
            map.collectClassLoaderDefinitions(classLoaders);
            return new SerializedPayload(classLoaders, buffer.readAsListOfByteArrays());
        }
        catch (IOException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
    }

    public Object deserialize(SerializedPayload payload) {
        DeserializeMap map = this.classLoaderRegistry.newDeserializeSession();
        try {
            Map classLoaderDetails = (Map)payload.getHeader();
            StreamByteBuffer buffer = StreamByteBuffer.of(payload.getSerializedModel());
            PayloadSerializerObjectInputStream objectStream = new PayloadSerializerObjectInputStream(buffer.getInputStream(), this.getClass().getClassLoader(), classLoaderDetails, map);
            return ((ObjectInputStream)((Object)objectStream)).readObject();
        }
        catch (Exception e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
    }
}

