/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.execution;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.execution.MavenExecutor;
import org.jetbrains.idea.maven.execution.MavenExternalExecutor;
import org.jetbrains.idea.maven.execution.MavenRunnerParameters;
import org.jetbrains.idea.maven.execution.MavenRunnerSettings;
import org.jetbrains.idea.maven.execution.SoutMavenConsole;
import org.jetbrains.idea.maven.project.MavenConsole;
import org.jetbrains.idea.maven.project.MavenConsoleImpl;
import org.jetbrains.idea.maven.project.MavenGeneralSettings;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.utils.MavenLog;

@State(name="MavenRunner", storages={@Storage(value="$WORKSPACE_FILE$")})
public class MavenRunner
implements PersistentStateComponent<MavenRunnerSettings> {
    private static final Logger LOG = Logger.getInstance(MavenRunner.class);
    private MavenRunnerSettings mySettings = new MavenRunnerSettings();
    private final Project myProject;

    public static MavenRunner getInstance(Project project) {
        return (MavenRunner)ServiceManager.getService((Project)project, MavenRunner.class);
    }

    public MavenRunner(Project project) {
        this.myProject = project;
    }

    public MavenRunnerSettings getSettings() {
        return this.mySettings;
    }

    @NotNull
    public MavenRunnerSettings getState() {
        MavenRunnerSettings mavenRunnerSettings = this.mySettings;
        if (mavenRunnerSettings == null) {
            MavenRunner.$$$reportNull$$$0(0);
        }
        return mavenRunnerSettings;
    }

    public void loadState(@NotNull MavenRunnerSettings settings) {
        if (settings == null) {
            MavenRunner.$$$reportNull$$$0(1);
        }
        this.mySettings = settings;
    }

    public void run(MavenRunnerParameters parameters, final MavenRunnerSettings settings, final Runnable onComplete) {
        FileDocumentManager.getInstance().saveAllDocuments();
        final MavenConsole console = this.createConsole();
        try {
            final MavenExecutor executor = this.createExecutor(parameters, null, settings, console);
            ProgressManager.getInstance().run((Task)new Task.Backgroundable(this.myProject, executor.getCaption(), true){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    try {
                        try {
                            if (executor.execute(indicator) && onComplete != null) {
                                onComplete.run();
                            }
                        }
                        catch (ProcessCanceledException processCanceledException) {
                            // empty catch block
                        }
                        MavenRunner.this.updateTargetFolders();
                    }
                    finally {
                        console.finish();
                    }
                }

                @Nullable
                public Task.NotificationInfo getNotificationInfo() {
                    return new Task.NotificationInfo("Maven", "Maven Task Finished", "");
                }

                public boolean shouldStartInBackground() {
                    return settings.isRunMavenInBackground();
                }

                public void processSentToBackground() {
                    settings.setRunMavenInBackground(true);
                }

                public void processRestoredToForeground() {
                    settings.setRunMavenInBackground(false);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/idea/maven/execution/MavenRunner$1", "run"));
                }
            });
        }
        catch (Exception e) {
            console.printException(e);
            console.finish();
            MavenLog.LOG.warn((Throwable)e);
        }
    }

    public boolean runBatch(List<MavenRunnerParameters> commands, @Nullable MavenGeneralSettings coreSettings, @Nullable MavenRunnerSettings runnerSettings, @Nullable String action, @Nullable ProgressIndicator indicator) {
        return this.runBatch(commands, coreSettings, runnerSettings, action, indicator, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean runBatch(List<MavenRunnerParameters> commands, @Nullable MavenGeneralSettings coreSettings, @Nullable MavenRunnerSettings runnerSettings, @Nullable String action, @Nullable ProgressIndicator indicator, @Nullable MavenConsole mavenConsole) {
        MavenConsole console;
        LOG.assertTrue(!ApplicationManager.getApplication().isReadAccessAllowed());
        if (commands.isEmpty()) {
            return true;
        }
        MavenConsole mavenConsole2 = console = mavenConsole != null ? mavenConsole : (MavenConsole)ReadAction.compute(() -> {
            if (this.myProject.isDisposed()) {
                return null;
            }
            return this.createConsole();
        });
        if (console == null) {
            return false;
        }
        try {
            int count = 0;
            for (MavenRunnerParameters command : commands) {
                MavenExecutor executor;
                if (indicator != null) {
                    indicator.setFraction((double)count++ / (double)commands.size());
                }
                if ((executor = (MavenExecutor)ReadAction.compute(() -> {
                    if (this.myProject.isDisposed()) {
                        return null;
                    }
                    return this.createExecutor(command, coreSettings, runnerSettings, console);
                })) == null) break;
                executor.setAction(action);
                if (executor.execute(indicator)) continue;
                this.updateTargetFolders();
                boolean bl = false;
                return bl;
            }
            this.updateTargetFolders();
        }
        finally {
            console.finish();
        }
        return true;
    }

    private void updateTargetFolders() {
        if (this.myProject.isDisposed()) {
            return;
        }
        MavenProjectsManager.getInstance(this.myProject).updateProjectTargetFolders();
    }

    private MavenConsole createConsole() {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return new SoutMavenConsole();
        }
        return new MavenConsoleImpl("Maven Goal", this.myProject);
    }

    private MavenExecutor createExecutor(MavenRunnerParameters taskParameters, @Nullable MavenGeneralSettings coreSettings, @Nullable MavenRunnerSettings runnerSettings, MavenConsole console) {
        return new MavenExternalExecutor(this.myProject, taskParameters, coreSettings, runnerSettings, console);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/execution/MavenRunner";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/execution/MavenRunner";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

