/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.server;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.model.MavenArtifactInfo;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.model.MavenModel;
import org.jetbrains.idea.maven.model.MavenPlugin;
import org.jetbrains.idea.maven.model.MavenRemoteRepository;
import org.jetbrains.idea.maven.model.MavenWorkspaceMap;
import org.jetbrains.idea.maven.project.MavenConsole;
import org.jetbrains.idea.maven.server.MavenServerConsole;
import org.jetbrains.idea.maven.server.MavenServerEmbedder;
import org.jetbrains.idea.maven.server.MavenServerExecutionResult;
import org.jetbrains.idea.maven.server.MavenServerManager;
import org.jetbrains.idea.maven.server.MavenServerProcessCanceledException;
import org.jetbrains.idea.maven.server.MavenServerProgressIndicator;
import org.jetbrains.idea.maven.server.NativeMavenProjectHolder;
import org.jetbrains.idea.maven.server.RemoteObjectWrapper;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.maven.utils.MavenProcessCanceledException;
import org.jetbrains.idea.maven.utils.MavenProgressIndicator;

public abstract class MavenEmbedderWrapper
extends RemoteObjectWrapper<MavenServerEmbedder> {
    private Customization myCustomization;

    public MavenEmbedderWrapper(@Nullable RemoteObjectWrapper<?> parent) {
        super(parent);
    }

    @Override
    protected synchronized void onWrappeeCreated() throws RemoteException {
        super.onWrappeeCreated();
        if (this.myCustomization != null) {
            this.doCustomize();
        }
    }

    public void customizeForResolve(MavenConsole console, MavenProgressIndicator indicator) {
        this.setCustomization(console, indicator, null, false, false, null);
        this.perform(() -> {
            this.doCustomize();
            return null;
        });
    }

    public void customizeForResolve(MavenWorkspaceMap workspaceMap, MavenConsole console, MavenProgressIndicator indicator, boolean alwaysUpdateSnapshot) {
        this.customizeForResolve(workspaceMap, console, indicator, alwaysUpdateSnapshot, null);
    }

    public void customizeForResolve(MavenWorkspaceMap workspaceMap, MavenConsole console, MavenProgressIndicator indicator, boolean alwaysUpdateSnapshot, @Nullable Properties userProperties) {
        this.setCustomization(console, indicator, workspaceMap, false, alwaysUpdateSnapshot, userProperties);
        this.perform(() -> {
            this.doCustomize();
            return null;
        });
    }

    public void customizeForStrictResolve(MavenWorkspaceMap workspaceMap, MavenConsole console, MavenProgressIndicator indicator) {
        this.setCustomization(console, indicator, workspaceMap, true, false, null);
        this.perform(() -> {
            this.doCustomize();
            return null;
        });
    }

    public void customizeForGetVersions() {
        this.perform(() -> {
            this.doCustomizeComponents();
            return null;
        });
    }

    private synchronized void doCustomizeComponents() throws RemoteException {
        ((MavenServerEmbedder)this.getOrCreateWrappee()).customizeComponents();
    }

    private synchronized void doCustomize() throws RemoteException {
        ((MavenServerEmbedder)this.getOrCreateWrappee()).customize(this.myCustomization.workspaceMap, this.myCustomization.failOnUnresolvedDependency, this.myCustomization.console, this.myCustomization.indicator, this.myCustomization.alwaysUpdateSnapshot, this.myCustomization.userProperties);
    }

    public MavenServerExecutionResult resolveProject(@NotNull VirtualFile file, @NotNull Collection<String> activeProfiles, @NotNull Collection<String> inactiveProfiles) throws MavenProcessCanceledException {
        if (file == null) {
            MavenEmbedderWrapper.$$$reportNull$$$0(0);
        }
        if (activeProfiles == null) {
            MavenEmbedderWrapper.$$$reportNull$$$0(1);
        }
        if (inactiveProfiles == null) {
            MavenEmbedderWrapper.$$$reportNull$$$0(2);
        }
        return this.resolveProject(Collections.singleton(file), activeProfiles, inactiveProfiles).iterator().next();
    }

    @NotNull
    public Collection<MavenServerExecutionResult> resolveProject(@NotNull Collection<VirtualFile> files, @NotNull Collection<String> activeProfiles, @NotNull Collection<String> inactiveProfiles) throws MavenProcessCanceledException {
        if (files == null) {
            MavenEmbedderWrapper.$$$reportNull$$$0(3);
        }
        if (activeProfiles == null) {
            MavenEmbedderWrapper.$$$reportNull$$$0(4);
        }
        if (inactiveProfiles == null) {
            MavenEmbedderWrapper.$$$reportNull$$$0(5);
        }
        Collection collection = this.performCancelable(() -> {
            if (files == null) {
                MavenEmbedderWrapper.$$$reportNull$$$0(53);
            }
            if (activeProfiles == null) {
                MavenEmbedderWrapper.$$$reportNull$$$0(54);
            }
            if (inactiveProfiles == null) {
                MavenEmbedderWrapper.$$$reportNull$$$0(55);
            }
            List ioFiles = ContainerUtil.map((Collection)files, file -> new File(file.getPath()));
            return ((MavenServerEmbedder)this.getOrCreateWrappee()).resolveProject((Collection)ioFiles, activeProfiles, inactiveProfiles);
        });
        if (collection == null) {
            MavenEmbedderWrapper.$$$reportNull$$$0(6);
        }
        return collection;
    }

    @Nullable
    public String evaluateEffectivePom(@NotNull VirtualFile file, @NotNull Collection<String> activeProfiles, @NotNull Collection<String> inactiveProfiles) throws MavenProcessCanceledException {
        if (file == null) {
            MavenEmbedderWrapper.$$$reportNull$$$0(7);
        }
        if (activeProfiles == null) {
            MavenEmbedderWrapper.$$$reportNull$$$0(8);
        }
        if (inactiveProfiles == null) {
            MavenEmbedderWrapper.$$$reportNull$$$0(9);
        }
        return this.performCancelable(() -> {
            if (file == null) {
                MavenEmbedderWrapper.$$$reportNull$$$0(50);
            }
            if (activeProfiles == null) {
                MavenEmbedderWrapper.$$$reportNull$$$0(51);
            }
            if (inactiveProfiles == null) {
                MavenEmbedderWrapper.$$$reportNull$$$0(52);
            }
            return ((MavenServerEmbedder)this.getOrCreateWrappee()).evaluateEffectivePom(new File(file.getPath()), new ArrayList(activeProfiles), new ArrayList(inactiveProfiles));
        });
    }

    @NotNull
    public MavenArtifact resolve(@NotNull MavenArtifactInfo info, @NotNull List<MavenRemoteRepository> remoteRepositories) throws MavenProcessCanceledException {
        if (info == null) {
            MavenEmbedderWrapper.$$$reportNull$$$0(10);
        }
        if (remoteRepositories == null) {
            MavenEmbedderWrapper.$$$reportNull$$$0(11);
        }
        MavenArtifact mavenArtifact = this.performCancelable(() -> {
            if (info == null) {
                MavenEmbedderWrapper.$$$reportNull$$$0(48);
            }
            if (remoteRepositories == null) {
                MavenEmbedderWrapper.$$$reportNull$$$0(49);
            }
            return ((MavenServerEmbedder)this.getOrCreateWrappee()).resolve(info, remoteRepositories);
        });
        if (mavenArtifact == null) {
            MavenEmbedderWrapper.$$$reportNull$$$0(12);
        }
        return mavenArtifact;
    }

    @NotNull
    public List<MavenArtifact> resolveTransitively(@NotNull List<MavenArtifactInfo> artifacts, @NotNull List<MavenRemoteRepository> remoteRepositories) throws MavenProcessCanceledException {
        if (artifacts == null) {
            MavenEmbedderWrapper.$$$reportNull$$$0(13);
        }
        if (remoteRepositories == null) {
            MavenEmbedderWrapper.$$$reportNull$$$0(14);
        }
        List list = this.performCancelable(() -> {
            if (artifacts == null) {
                MavenEmbedderWrapper.$$$reportNull$$$0(46);
            }
            if (remoteRepositories == null) {
                MavenEmbedderWrapper.$$$reportNull$$$0(47);
            }
            return ((MavenServerEmbedder)this.getOrCreateWrappee()).resolveTransitively(artifacts, remoteRepositories);
        });
        if (list == null) {
            MavenEmbedderWrapper.$$$reportNull$$$0(15);
        }
        return list;
    }

    @NotNull
    public List<String> retrieveVersions(@NotNull String groupId, @NotNull String artifactId, @NotNull List<MavenRemoteRepository> remoteRepositories) throws MavenProcessCanceledException {
        if (groupId == null) {
            MavenEmbedderWrapper.$$$reportNull$$$0(16);
        }
        if (artifactId == null) {
            MavenEmbedderWrapper.$$$reportNull$$$0(17);
        }
        if (remoteRepositories == null) {
            MavenEmbedderWrapper.$$$reportNull$$$0(18);
        }
        List list = this.performCancelable(() -> {
            if (groupId == null) {
                MavenEmbedderWrapper.$$$reportNull$$$0(43);
            }
            if (artifactId == null) {
                MavenEmbedderWrapper.$$$reportNull$$$0(44);
            }
            if (remoteRepositories == null) {
                MavenEmbedderWrapper.$$$reportNull$$$0(45);
            }
            return ((MavenServerEmbedder)this.getOrCreateWrappee()).retrieveAvailableVersions(groupId, artifactId, remoteRepositories);
        });
        if (list == null) {
            MavenEmbedderWrapper.$$$reportNull$$$0(19);
        }
        return list;
    }

    public Collection<MavenArtifact> resolvePlugin(@NotNull MavenPlugin plugin, @NotNull List<MavenRemoteRepository> repositories, @NotNull NativeMavenProjectHolder nativeMavenProject, boolean transitive) throws MavenProcessCanceledException {
        int id;
        if (plugin == null) {
            MavenEmbedderWrapper.$$$reportNull$$$0(20);
        }
        if (repositories == null) {
            MavenEmbedderWrapper.$$$reportNull$$$0(21);
        }
        if (nativeMavenProject == null) {
            MavenEmbedderWrapper.$$$reportNull$$$0(22);
        }
        try {
            id = nativeMavenProject.getId();
        }
        catch (RemoteException e) {
            return Collections.emptyList();
        }
        try {
            return ((MavenServerEmbedder)this.getOrCreateWrappee()).resolvePlugin(plugin, repositories, id, transitive);
        }
        catch (RemoteException e) {
            this.handleRemoteError(e);
            return Collections.emptyList();
        }
        catch (MavenServerProcessCanceledException e) {
            throw new MavenProcessCanceledException();
        }
    }

    public MavenModel readModel(File file) throws MavenProcessCanceledException {
        return this.performCancelable(() -> ((MavenServerEmbedder)this.getOrCreateWrappee()).readModel(file));
    }

    @NotNull
    public MavenServerExecutionResult execute(@NotNull VirtualFile file, @NotNull Collection<String> activeProfiles, @NotNull Collection<String> inactiveProfiles, @NotNull List<String> goals) throws MavenProcessCanceledException {
        if (file == null) {
            MavenEmbedderWrapper.$$$reportNull$$$0(23);
        }
        if (activeProfiles == null) {
            MavenEmbedderWrapper.$$$reportNull$$$0(24);
        }
        if (inactiveProfiles == null) {
            MavenEmbedderWrapper.$$$reportNull$$$0(25);
        }
        if (goals == null) {
            MavenEmbedderWrapper.$$$reportNull$$$0(26);
        }
        MavenServerExecutionResult mavenServerExecutionResult = this.performCancelable(() -> {
            if (file == null) {
                MavenEmbedderWrapper.$$$reportNull$$$0(39);
            }
            if (activeProfiles == null) {
                MavenEmbedderWrapper.$$$reportNull$$$0(40);
            }
            if (inactiveProfiles == null) {
                MavenEmbedderWrapper.$$$reportNull$$$0(41);
            }
            if (goals == null) {
                MavenEmbedderWrapper.$$$reportNull$$$0(42);
            }
            return ((MavenServerEmbedder)this.getOrCreateWrappee()).execute(new File(file.getPath()), activeProfiles, inactiveProfiles, goals, Collections.emptyList(), false, false);
        });
        if (mavenServerExecutionResult == null) {
            MavenEmbedderWrapper.$$$reportNull$$$0(27);
        }
        return mavenServerExecutionResult;
    }

    @NotNull
    public MavenServerExecutionResult execute(@NotNull VirtualFile file, @NotNull Collection<String> activeProfiles, @NotNull Collection<String> inactiveProfiles, @NotNull List<String> goals, @NotNull List<String> selectedProjects, boolean alsoMake, boolean alsoMakeDependents) throws MavenProcessCanceledException {
        if (file == null) {
            MavenEmbedderWrapper.$$$reportNull$$$0(28);
        }
        if (activeProfiles == null) {
            MavenEmbedderWrapper.$$$reportNull$$$0(29);
        }
        if (inactiveProfiles == null) {
            MavenEmbedderWrapper.$$$reportNull$$$0(30);
        }
        if (goals == null) {
            MavenEmbedderWrapper.$$$reportNull$$$0(31);
        }
        if (selectedProjects == null) {
            MavenEmbedderWrapper.$$$reportNull$$$0(32);
        }
        MavenServerExecutionResult mavenServerExecutionResult = this.performCancelable(() -> {
            if (file == null) {
                MavenEmbedderWrapper.$$$reportNull$$$0(34);
            }
            if (activeProfiles == null) {
                MavenEmbedderWrapper.$$$reportNull$$$0(35);
            }
            if (inactiveProfiles == null) {
                MavenEmbedderWrapper.$$$reportNull$$$0(36);
            }
            if (goals == null) {
                MavenEmbedderWrapper.$$$reportNull$$$0(37);
            }
            if (selectedProjects == null) {
                MavenEmbedderWrapper.$$$reportNull$$$0(38);
            }
            return ((MavenServerEmbedder)this.getOrCreateWrappee()).execute(new File(file.getPath()), activeProfiles, inactiveProfiles, goals, selectedProjects, alsoMake, alsoMakeDependents);
        });
        if (mavenServerExecutionResult == null) {
            MavenEmbedderWrapper.$$$reportNull$$$0(33);
        }
        return mavenServerExecutionResult;
    }

    public void reset() {
        MavenServerEmbedder w = (MavenServerEmbedder)this.getWrappee();
        if (w == null) {
            return;
        }
        try {
            w.reset();
        }
        catch (RemoteException e) {
            this.handleRemoteError(e);
        }
        this.resetCustomization();
    }

    public void release() {
        MavenServerEmbedder w = (MavenServerEmbedder)this.getWrappee();
        if (w == null) {
            return;
        }
        try {
            w.release();
        }
        catch (RemoteException e) {
            this.handleRemoteError(e);
        }
        this.resetCustomization();
    }

    public void clearCaches() {
        MavenServerEmbedder w = (MavenServerEmbedder)this.getWrappee();
        if (w == null) {
            return;
        }
        try {
            w.clearCaches();
        }
        catch (RemoteException e) {
            this.handleRemoteError(e);
        }
    }

    public void clearCachesFor(MavenId projectId) {
        MavenServerEmbedder w = (MavenServerEmbedder)this.getWrappee();
        if (w == null) {
            return;
        }
        try {
            w.clearCachesFor(projectId);
        }
        catch (RemoteException e) {
            this.handleRemoteError(e);
        }
    }

    private synchronized void setCustomization(MavenConsole console, MavenProgressIndicator indicator, MavenWorkspaceMap workspaceMap, boolean failOnUnresolvedDependency, boolean alwaysUpdateSnapshot, @Nullable Properties userProperties) {
        this.resetCustomization();
        this.myCustomization = new Customization(MavenServerManager.wrapAndExport(console), MavenServerManager.wrapAndExport(indicator), workspaceMap, failOnUnresolvedDependency, alwaysUpdateSnapshot, userProperties);
    }

    private synchronized void resetCustomization() {
        if (this.myCustomization == null) {
            return;
        }
        try {
            UnicastRemoteObject.unexportObject((Remote)this.myCustomization.console, true);
        }
        catch (NoSuchObjectException e) {
            MavenLog.LOG.warn((Throwable)e);
        }
        try {
            UnicastRemoteObject.unexportObject((Remote)this.myCustomization.indicator, true);
        }
        catch (NoSuchObjectException e) {
            MavenLog.LOG.warn((Throwable)e);
        }
        this.myCustomization = null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 12: 
            case 15: 
            case 19: 
            case 27: 
            case 33: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 12: 
            case 15: 
            case 19: 
            case 27: 
            case 33: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 4: 
            case 8: 
            case 24: 
            case 29: 
            case 35: 
            case 40: 
            case 51: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "activeProfiles";
                break;
            }
            case 2: 
            case 5: 
            case 9: 
            case 25: 
            case 30: 
            case 36: 
            case 41: 
            case 52: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inactiveProfiles";
                break;
            }
            case 3: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 6: 
            case 12: 
            case 15: 
            case 19: 
            case 27: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/server/MavenEmbedderWrapper";
                break;
            }
            case 10: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 11: 
            case 14: 
            case 18: 
            case 45: 
            case 47: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteRepositories";
                break;
            }
            case 13: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifacts";
                break;
            }
            case 16: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupId";
                break;
            }
            case 17: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifactId";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "plugin";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositories";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nativeMavenProject";
                break;
            }
            case 26: 
            case 31: 
            case 37: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "goals";
                break;
            }
            case 32: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedProjects";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/server/MavenEmbedderWrapper";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveProject";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "resolve";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveTransitively";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "retrieveVersions";
                break;
            }
            case 27: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "execute";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "resolveProject";
                break;
            }
            case 6: 
            case 12: 
            case 15: 
            case 19: 
            case 27: 
            case 33: {
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "evaluateEffectivePom";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "resolve";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "resolveTransitively";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "retrieveVersions";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "resolvePlugin";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "lambda$execute$12";
                break;
            }
            case 39: 
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "lambda$execute$11";
                break;
            }
            case 43: 
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "lambda$retrieveVersions$9";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "lambda$resolveTransitively$8";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "lambda$resolve$7";
                break;
            }
            case 50: 
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "lambda$evaluateEffectivePom$6";
                break;
            }
            case 53: 
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "lambda$resolveProject$5";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 12: 
            case 15: 
            case 19: 
            case 27: 
            case 33: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Customization {
        private final MavenServerConsole console;
        private final MavenServerProgressIndicator indicator;
        private final MavenWorkspaceMap workspaceMap;
        private final boolean failOnUnresolvedDependency;
        private final boolean alwaysUpdateSnapshot;
        private final Properties userProperties;

        private Customization(MavenServerConsole console, MavenServerProgressIndicator indicator, MavenWorkspaceMap workspaceMap, boolean failOnUnresolvedDependency, boolean alwaysUpdateSnapshot, @Nullable Properties userProperties) {
            this.console = console;
            this.indicator = indicator;
            this.workspaceMap = workspaceMap;
            this.failOnUnresolvedDependency = failOnUnresolvedDependency;
            this.alwaysUpdateSnapshot = alwaysUpdateSnapshot;
            this.userProperties = userProperties;
        }
    }
}

